/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class XmlMultiViewDataSynchronizer {
    private final int updateDelay;
    private long timeStamp;
    private final XmlMultiViewDataObject dataObject;
    private int reloading = 0;
    private int updating = 0;
    protected final RequestProcessor requestProcessor = new RequestProcessor("XmlMultiViewDataSynchronizer RequestProcessor", 1);
    private FileLock updateLock = null;
    private final RequestProcessor.Task updateTask = this.requestProcessor.create(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (XmlMultiViewDataSynchronizer.this.isUpdateLock()) {
                XmlMultiViewDataSynchronizer.this.finishUpdateTask.cancel();
                XmlMultiViewDataSynchronizer.this.updateData(XmlMultiViewDataSynchronizer.this.updateLock, true);
                RequestProcessor.Task task = XmlMultiViewDataSynchronizer.this.updateTask;
                synchronized (task) {
                    if (XmlMultiViewDataSynchronizer.this.updateTask.getDelay() <= 0) {
                        XmlMultiViewDataSynchronizer.this.finishUpdateTask.schedule(1);
                    }
                }
            }
        }
    });
    private final RequestProcessor.Task finishUpdateTask = this.requestProcessor.create(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RequestProcessor.Task task = XmlMultiViewDataSynchronizer.this.updateTask;
            synchronized (task) {
                if (XmlMultiViewDataSynchronizer.this.isUpdateLock()) {
                    XmlMultiViewDataSynchronizer.this.updateLock.releaseLock();
                    XmlMultiViewDataSynchronizer.this.updateLock = null;
                }
            }
        }
    });
    private final RequestProcessor.Task reloadTask = this.requestProcessor.create(new Runnable(){

        public void run() {
            XmlMultiViewDataSynchronizer.this.reloadModel();
        }
    });
    private final XmlMultiViewDataObject.DataCache dataCache;

    public XmlMultiViewDataSynchronizer(XmlMultiViewDataObject dataObject, int delay) {
        this.dataObject = dataObject;
        this.dataCache = dataObject.getDataCache();
        this.updateDelay = delay;
        this.dataObject.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("data modified".equals(evt.getPropertyName())) {
                    XmlMultiViewDataSynchronizer.this.dataModified((Long)evt.getNewValue());
                } else if ("data changed".equals(evt.getPropertyName())) {
                    XmlMultiViewDataSynchronizer.this.dataUpdated((Long)evt.getNewValue());
                }
            }
        });
    }

    protected void dataModified(long timeStamp) {
        if (this.timeStamp < timeStamp) {
            this.reloadTask.schedule(10);
        }
    }

    protected void dataUpdated(long timeStamp) {
        if (this.updating == 0 && this.timeStamp < timeStamp) {
            this.reloadTask.schedule(10);
        }
    }

    public FileLock takeLock() throws IOException {
        FileLock lock = this.dataObject.waitForLock(1000L);
        if (lock != null) {
            if (this.mayUpdateData(true)) {
                return lock;
            }
            lock.releaseLock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestUpdateData() {
        if (this.reloading == 0) {
            RequestProcessor.Task task = this.updateTask;
            synchronized (task) {
                this.finishUpdateTask.cancel();
                if (!this.isUpdateLock()) {
                    try {
                        this.updateLock = this.takeLock();
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                        return;
                    }
                }
                this.updateTask.schedule(this.dataObject.isModified() ? this.updateDelay : 1);
            }
        }
    }

    private boolean isUpdateLock() {
        return this.updateLock != null && this.updateLock.isValid();
    }

    protected abstract boolean mayUpdateData(boolean var1);

    protected abstract void updateDataFromModel(Object var1, FileLock var2, boolean var3);

    protected abstract Object getModel();

    protected abstract void reloadModelFromData();

    final void reloadingStarted() {
        ++this.reloading;
    }

    final void reloadingFinished() {
        --this.reloading;
    }

    public final RequestProcessor.Task getReloadTask() {
        return this.reloadTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reloadModel() {
        long newTimeStamp = this.dataCache.getTimeStamp();
        if (this.timeStamp < newTimeStamp) {
            this.reloadingStarted();
            try {
                this.timeStamp = newTimeStamp;
                this.reloadModelFromData();
            }
            finally {
                this.reloadingFinished();
            }
        }
    }

    public Transaction openTransaction() {
        try {
            FileLock lock = this.takeLock();
            if (lock != null) {
                return new Transaction(lock);
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().annotate((Throwable)e, NbBundle.getMessage((Class)XmlMultiViewDataSynchronizer.class, (String)"START_TRANSACTION_FAILED"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateData(FileLock dataLock, boolean modify) {
        ++this.updating;
        try {
            this.updateDataFromModel(this.getModel(), dataLock, modify);
            this.timeStamp = this.dataCache.getTimeStamp();
        }
        finally {
            --this.updating;
            if (dataLock != null && dataLock.isValid()) {
                dataLock.releaseLock();
            }
        }
    }

    public class Transaction {
        private FileLock lock;

        private Transaction(FileLock lock) {
            this.lock = lock;
        }

        public void rollback() {
            if (this.lock != null) {
                XmlMultiViewDataSynchronizer.this.reloadModel();
                this.lock.releaseLock();
                this.lock = null;
            }
        }

        public void commit() throws IOException {
            XmlMultiViewDataSynchronizer.this.dataCache.testLock(this.lock);
            XmlMultiViewDataSynchronizer.this.updateData(this.lock, false);
            this.lock.releaseLock();
            this.lock = null;
        }
    }
}

