/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspparser;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ContextUtil {
    public static String getThrowableMessage(Throwable throwable, boolean includeStackTrace) {
        if (includeStackTrace) {
            StringWriter swriter = new StringWriter();
            PrintWriter pw = new PrintWriter(swriter);
            throwable.printStackTrace(pw);
            pw.close();
            return swriter.toString();
        }
        return throwable.getMessage();
    }

    public static boolean isInSubTree(FileObject folder, FileObject fo) {
        if (fo == folder) {
            return true;
        }
        return FileUtil.isParentOf((FileObject)folder, (FileObject)fo);
    }

    public static String findRelativePath(FileObject rootFolder, FileObject relativeObject) {
        String rfp = rootFolder.getPath();
        String rop = relativeObject.getPath();
        if (!ContextUtil.isInSubTree(rootFolder, relativeObject)) {
            throw new IllegalArgumentException("" + rootFolder + " / " + relativeObject);
        }
        String result = rop.substring(rfp.length());
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    public static String findRelativeContextPath(FileObject rootFolder, FileObject relativeObject) {
        String result = "/" + ContextUtil.findRelativePath(rootFolder, relativeObject);
        return relativeObject.isFolder() ? result + "/" : result;
    }

    public static FileObject findRelativeFileObject(FileObject rootFolder, String relativePath) {
        FileObject myObj;
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        StringTokenizer st = new StringTokenizer(relativePath, "/");
        for (myObj = rootFolder; myObj != null && st.hasMoreTokens(); myObj = myObj.getFileObject(st.nextToken())) {
        }
        return myObj;
    }
}

