/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskListener;
import org.netbeans.modules.tasklist.core.TaskNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public class TaskChildren
extends Children.Keys {
    private final Task parent;
    private Monitor monitor;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TaskChildren(Task parent) {
        this.parent = parent;
    }

    private void refreshKeys() {
        Collection keys = !this.parent.hasSubtasks() ? Collections.EMPTY_SET : this.parent.getSubtasks();
        Object[] tasks = keys.toArray(new Task[keys.size()]);
        this.setKeys(tasks);
    }

    protected void addNotify() {
        super.addNotify();
        if (!$assertionsDisabled && this.monitor != null) {
            throw new AssertionError((Object)"Dangling addNotify()");
        }
        this.monitor = new Monitor();
        TaskListener l = (TaskListener)WeakListeners.create((Class)TaskListener.class, (EventListener)this.monitor, (Object)this.parent);
        this.parent.addTaskListener(l);
        this.refreshKeys();
    }

    protected void removeNotify() {
        if (!$assertionsDisabled && this.monitor == null) {
            throw new AssertionError((Object)"Dangling removeNotify()");
        }
        this.monitor = null;
        this.setKeys(Collections.EMPTY_SET);
        super.removeNotify();
    }

    protected Node[] createNodes(Object key) {
        Task task = (Task)key;
        return new Node[]{this.createNode(task)};
    }

    public Object clone() {
        return new TaskChildren(this.parent);
    }

    protected TaskNode createNode(Task task) {
        return new TaskNode(task);
    }

    static {
        $assertionsDisabled = !TaskChildren.class.desiredAssertionStatus();
    }

    private class Monitor
    implements TaskListener {
        public void selectedTask(Task t) {
        }

        public void warpedTask(Task t) {
        }

        public void addedTask(Task t) {
            if (t.getParent() == TaskChildren.this.parent) {
                TaskChildren.this.refreshKeys();
            }
        }

        public void removedTask(Task pt, Task t, int index) {
            if (t.getParent() == TaskChildren.this.parent) {
                TaskChildren.this.refreshKeys();
            }
        }

        public void structureChanged(Task t) {
            if (t == null || t.isParentOf(TaskChildren.this.parent)) {
                TaskChildren.this.refreshKeys();
            }
        }
    }
}

