/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.modules.tasklist.client.SuggestionPriority;
import org.netbeans.modules.tasklist.core.checklist.CheckList;
import org.netbeans.modules.tasklist.core.checklist.DefaultCheckListModel;
import org.netbeans.modules.tasklist.core.filter.FilterCondition;
import org.netbeans.modules.tasklist.core.filter.Util;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PriorityCondition
extends FilterCondition {
    private static int NPRIORITIES = 5;
    private boolean[] priorities = new boolean[NPRIORITIES];

    public static PriorityCondition[] createConditions() {
        return new PriorityCondition[]{new PriorityCondition()};
    }

    public PriorityCondition() {
        Arrays.fill(this.priorities, true);
    }

    public PriorityCondition(PriorityCondition rhs) {
        super(rhs);
        for (int i = 0; i < NPRIORITIES; ++i) {
            this.priorities[i] = rhs.priorities[i];
        }
    }

    public Object clone() {
        return new PriorityCondition(this);
    }

    public boolean isTrue(Object o1) {
        SuggestionPriority k = (SuggestionPriority)o1;
        return this.priorities[k.intValue() - 1];
    }

    public JComponent createConstantComponent() {
        CheckList list = new CheckList(new DefaultCheckListModel(this.priorities, SuggestionPriority.getPriorityNames()));
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("TextField.border"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        panel.add((Component)list, "Center");
        panel.setToolTipText(Util.getString("prio_desc"));
        list.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)PriorityCondition.class, (String)"LBL_PriorityCheckList"));
        list.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PriorityCondition.class, (String)"LBL_PriorityCheckList"));
        return panel;
    }

    public void getConstantFrom(JComponent cmp) {
    }

    protected String getDisplayName() {
        return NbBundle.getMessage((Class)PriorityCondition.class, (String)"IsOneOf");
    }

    static /* synthetic */ boolean[] access$102(PriorityCondition x0, boolean[] x1) {
        x0.priorities = x1;
        return x1;
    }

    private static class Convertor
    extends FilterCondition.Convertor {
        private static final String ELEM_PRIORITY_CONDITION = "PriorityCondition";
        private static final String ATTR_PRIORITIES = "priorities";

        public Convertor() {
            super(ELEM_PRIORITY_CONDITION);
        }

        public static Convertor create() {
            return new Convertor();
        }

        protected Object readElement(Element element) throws IOException, ClassNotFoundException {
            PriorityCondition cond = new PriorityCondition();
            super.readCondition(element, cond);
            String spriorities = element.getAttribute(ATTR_PRIORITIES);
            boolean[] bpriorities = new boolean[NPRIORITIES];
            for (int i = 0; i < NPRIORITIES; ++i) {
                bpriorities[i] = spriorities.charAt(i) == '+';
            }
            PriorityCondition.access$102(cond, bpriorities);
            return cond;
        }

        protected void writeElement(Document document, Element element, Object obj) throws IOException, DOMException {
            PriorityCondition cond = (PriorityCondition)obj;
            super.writeCondition(document, element, cond);
            StringBuffer str = new StringBuffer(NPRIORITIES);
            for (int i = 0; i < NPRIORITIES; ++i) {
                str.append(cond.priorities[i] ? (char)'+' : '-');
            }
            element.setAttribute(ATTR_PRIORITIES, str.toString());
        }
    }
}

