/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jmiutils;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.mdr.JMIStreamFactory;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class FSSFImpl
extends JMIStreamFactory {
    private final FileSystem fileSystem;
    private final Date modelLastModified;

    public FSSFImpl(FileSystem fs) {
        this(fs, null);
    }

    public FSSFImpl(FileSystem fs, Date modelLastModified) {
        if (fs == null) {
            throw new IllegalArgumentException("ERROR: fs is null");
        }
        this.fileSystem = fs;
        this.modelLastModified = modelLastModified;
    }

    public OutputStream createStream(List pkg, String className, String extension) throws IOException {
        FileObject folder = this.fileSystem.getRoot();
        Iterator it = pkg.iterator();
        while (it.hasNext()) {
            String folderName = (String)it.next();
            FileObject tempFolder = folder.getFileObject(folderName);
            if (tempFolder == null) {
                tempFolder = folder.createFolder(folderName);
            }
            folder = tempFolder;
        }
        FileObject file = folder.getFileObject(className, extension);
        if (file != null) {
            if (this.modelLastModified != null && this.modelLastModified.before(file.lastModified())) {
                return null;
            }
            FileLock lock = file.lock();
            file.delete(lock);
            lock.releaseLock();
        }
        file = folder.createData(className, extension);
        FileLock fileLock = file.lock();
        return new FSStream(file.getOutputStream(fileLock), fileLock);
    }

    private static class FSStream
    extends FilterOutputStream {
        private final FileLock fileLock;

        private FSStream(OutputStream stream, FileLock fileLock) {
            super(stream);
            this.fileLock = fileLock;
        }

        public void close() throws IOException {
            super.close();
            this.fileLock.releaseLock();
        }
    }
}

