/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.ui;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.sun.api.ServerLocationManager;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.AddDomainWizardIterator;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.AddInstanceVisualPlatformPanel;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.Util;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class AddDomainPlatformPanel
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    private AddInstanceVisualPlatformPanel component;
    private WizardDescriptor wiz;
    private final Set listeners = new HashSet(1);

    AddDomainPlatformPanel() {
    }

    public Component getComponent() {
        if (this.component == null) {
            File f = ServerLocationManager.getLatestPlatformLocation();
            File defaultLoc = new File(System.getProperty("user.home"));
            if (f != null && f.exists()) {
                defaultLoc = f;
            }
            this.component = new AddInstanceVisualPlatformPanel(defaultLoc);
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("AS_RegServ_EnterPlatformDir");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Object selectedType;
        boolean retVal = true;
        this.wiz.putProperty("WizardPanel_errorMessage", null);
        String instLoc = this.component.getInstallLocation();
        if (instLoc.startsWith("\\\\")) {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainPlatformPanel.class, (String)"Msg_NoAuthorityComponent"));
            retVal = false;
        }
        File location = new File(this.component.getInstallLocation());
        if (retVal && !ServerLocationManager.isGoodAppServerLocation((File)location)) {
            selectedType = this.component.getSelectedType();
            if (selectedType == AddDomainWizardIterator.REMOTE) {
                this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainPlatformPanel.class, (String)"Msg_NeedValidInstallEvenForRemote"));
            } else {
                this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainPlatformPanel.class, (String)"Msg_InValidInstall"));
            }
            this.component.setDomainsList(new Object[0]);
            retVal = false;
        } else if (retVal) {
            String javaClassVersion;
            double jcv;
            Object oldPlatformLoc = this.wiz.getProperty("platform_location");
            if (!location.equals(oldPlatformLoc) || this.component.getDomainsListModel().getSize() < 1) {
                Object[] domainsList = this.getDomainList(Util.getRegisterableDefaultDomains(location));
                this.component.setDomainsList(domainsList);
            }
            if (ServerLocationManager.isGlassFish((File)location) && (jcv = Double.parseDouble(javaClassVersion = System.getProperty("java.class.version"))) < 49.0) {
                this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainPlatformPanel.class, (String)"Msg_RequireJ2SE5"));
                retVal = false;
            }
        }
        if (retVal) {
            this.wiz.putProperty("platform_location", (Object)location);
            this.wiz.putProperty("username", (Object)"");
            this.wiz.putProperty("password", (Object)"");
            selectedType = this.component.getSelectedType();
            if (selectedType == AddDomainWizardIterator.DEFAULT) {
                File[] usableDomains = Util.getRegisterableDefaultDomains(location);
                if (usableDomains.length == 0) {
                    this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainPlatformPanel.class, (String)"Msg_NoDefaultDomainsAvailable"));
                    retVal = false;
                }
                this.wiz.putProperty("type", selectedType);
                String dirCandidate = this.component.getDomainDir();
                if (null != dirCandidate) {
                    File domainDir = new File(dirCandidate);
                    if (!Util.rootOfUsableDomain(domainDir)) {
                        this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainPlatformPanel.class, (String)"Msg_InValidDomainDir", (Object)this.component.getDomainDir()));
                        retVal = false;
                    } else {
                        Util.fillDescriptorFromDomainXml(this.wiz, domainDir);
                        String username = "admin";
                        String password = null;
                        File f = new File(System.getProperty("user.home") + "/.asadminprefs");
                        if (f.exists()) {
                            FileInputStream fis = null;
                            try {
                                fis = new FileInputStream(f);
                                Properties p = new Properties();
                                p.load(fis);
                                fis.close();
                                Enumeration<?> e = p.propertyNames();
                                while (e.hasMoreElements()) {
                                    String v = (String)e.nextElement();
                                    if (v.equals("AS_ADMIN_USER")) {
                                        username = p.getProperty(v);
                                        continue;
                                    }
                                    if (!v.equals("AS_ADMIN_PASSWORD")) continue;
                                    password = p.getProperty(v);
                                }
                            }
                            catch (Exception e) {
                                ErrorManager.getDefault().notify(1, (Throwable)e);
                            }
                            finally {
                                if (null != fis) {
                                    try {
                                        fis.close();
                                    }
                                    catch (IOException ex) {
                                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                                    }
                                }
                            }
                        }
                        this.wiz.putProperty("password", password);
                        this.wiz.putProperty("username", (Object)username);
                    }
                }
            } else if (selectedType == AddDomainWizardIterator.REMOTE) {
                this.wiz.putProperty("type", selectedType);
                this.wiz.putProperty("install_location", (Object)"");
                this.wiz.putProperty("domain", (Object)"");
            } else if (selectedType == AddDomainWizardIterator.LOCAL) {
                this.wiz.putProperty("type", selectedType);
            } else if (selectedType == AddDomainWizardIterator.PERSONAL) {
                this.wiz.putProperty("type", selectedType);
            } else {
                this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainPlatformPanel.class, (String)"Msg_UnsupportedType"));
                retVal = false;
            }
        }
        return retVal;
    }

    private Object[] getDomainList(File[] dirs) {
        return this.getServerList(dirs);
    }

    private Object[] getServerList(File[] dirs) {
        ArrayList<String> xmlList = new ArrayList<String>();
        Object[] retVal = null;
        File platformDir = (File)this.wiz.getProperty("platform_location");
        for (int i = 0; platformDir != null && i < dirs.length; ++i) {
            String hostPort = Util.getHostPort(dirs[i], platformDir);
            if (hostPort == null) continue;
            xmlList.add(NbBundle.getMessage(AddDomainPlatformPanel.class, (String)"LBL_domainListEntry", (Object[])new Object[]{hostPort, dirs[i].toString()}));
        }
        if (xmlList != null) {
            retVal = xmlList.toArray();
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ChangeListener l = (ChangeListener)it.next();
            l.stateChanged(ev);
        }
    }

    public void readSettings(Object settings) {
        this.wiz = (WizardDescriptor)settings;
    }

    public void storeSettings(Object settings) {
    }

    public void stateChanged(ChangeEvent e) {
        this.wiz.putProperty("type", this.component.getSelectedType());
        this.fireChangeEvent();
    }

    public boolean isFinishPanel() {
        Object selectedType = this.component.getSelectedType();
        return selectedType == AddDomainWizardIterator.DEFAULT;
    }
}

