/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.j2ee.sun.api.ServerLocationManager;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.AddDomainWizardIterator;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.AddInstanceVisualDirectoryPanel;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class AddInstanceVisualPlatformPanel
extends JPanel {
    private Object type;
    private Set listenrs = new HashSet();
    RequestProcessor.Task changeEvent = null;
    private JRadioButton createPersonal;
    private JLabel description;
    private JComboBox instanceSelector;
    private JLabel instanceSelectorLabel;
    private ButtonGroup instanceTypeButtonGroup;
    private JButton openDirectoryCooser;
    private JTextField platformField;
    private JLabel platformFieldLabel;
    private JRadioButton registerDefault;
    private JRadioButton registerLocal;
    private JRadioButton registerRemote;
    private JLabel spacingHack;

    public AddInstanceVisualPlatformPanel(File defaultLoc) {
        this.initComponents();
        this.platformField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                AddInstanceVisualPlatformPanel.this.fireChangeEvent();
            }

            public void insertUpdate(DocumentEvent e) {
                AddInstanceVisualPlatformPanel.this.fireChangeEvent();
            }

            public void removeUpdate(DocumentEvent e) {
                AddInstanceVisualPlatformPanel.this.fireChangeEvent();
            }
        });
        this.type = AddDomainWizardIterator.DEFAULT;
        this.platformField.setText(defaultLoc.getAbsolutePath());
        this.registerDefault.setSelected(true);
        this.instanceSelector.setModel(new ComboBoxModel(){

            public void addListDataListener(ListDataListener listDataListener) {
            }

            public Object getElementAt(int i) {
                return null;
            }

            public Object getSelectedItem() {
                return null;
            }

            public int getSize() {
                return 0;
            }

            public void removeListDataListener(ListDataListener listDataListener) {
            }

            public void setSelectedItem(Object object) {
            }
        });
    }

    Object getSelectedType() {
        return this.type;
    }

    String getInstallLocation() {
        return this.platformField.getText();
    }

    void setDomainsList(Object[] domainsList) {
        if (domainsList != null) {
            this.instanceSelector.setModel(new DefaultComboBoxModel<Object>(domainsList));
        } else {
            this.instanceSelector.setModel(new DefaultComboBoxModel());
        }
    }

    String getDomainDir() {
        String retVal = null;
        boolean okay = true;
        String tmp = (String)this.instanceSelector.getSelectedItem();
        if (null != tmp) {
            int firstParen = tmp.lastIndexOf(40);
            int lastParen = tmp.lastIndexOf(41);
            if (firstParen < 0) {
                ErrorManager.getDefault().log(65536, NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"ERRMSG_PARSE_DOMAIN_DIR", (Object)tmp));
                okay = false;
            }
            if (okay && lastParen < 0) {
                ErrorManager.getDefault().log(65536, NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"ERRMSG_PARSE_DOMAIN_DIR", (Object)tmp));
                okay = false;
            }
            if (okay && lastParen < firstParen) {
                ErrorManager.getDefault().log(65536, NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"ERRMSG_PARSE_DOMAIN_DIR", (Object)tmp));
                okay = false;
            }
            if (okay) {
                retVal = tmp.substring(firstParen + 1, lastParen);
            }
        }
        return retVal;
    }

    public String getName() {
        return NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"StepName_EnterPlatformDirectory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChangeListener(ChangeListener l) {
        Set set = this.listenrs;
        synchronized (set) {
            this.listenrs.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChangeListener(ChangeListener l) {
        Set set = this.listenrs;
        synchronized (set) {
            this.listenrs.remove(l);
        }
    }

    private void fireChangeEvent() {
        if (this.changeEvent == null) {
            this.changeEvent = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            Iterator it;
                            Set set = AddInstanceVisualPlatformPanel.this.listenrs;
                            synchronized (set) {
                                it = new HashSet(AddInstanceVisualPlatformPanel.this.listenrs).iterator();
                            }
                            ChangeEvent ev = new ChangeEvent(this);
                            while (it.hasNext()) {
                                ((ChangeListener)it.next()).stateChanged(ev);
                            }
                        }
                    });
                }
            }, 100);
        } else {
            this.changeEvent.schedule(100);
        }
    }

    void setSelectedType(Object t, ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.type = t;
            this.fireChangeEvent();
        }
    }

    private String browseInstallLocation() {
        String insLocation = null;
        PlatformInstChooser chooser = new PlatformInstChooser();
        String fname = this.platformField.getText();
        Util.decorateChooser(chooser, fname, NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"LBL_Choose_Install"));
        int returnValue = chooser.showDialog(this, NbBundle.getMessage(AddInstanceVisualDirectoryPanel.class, (String)"LBL_Choose_Button"));
        if (returnValue == 0) {
            insLocation = chooser.getSelectedFile().getAbsolutePath();
        }
        return insLocation;
    }

    private void initComponents() {
        this.instanceTypeButtonGroup = new ButtonGroup();
        this.description = new JLabel();
        this.platformFieldLabel = new JLabel();
        this.platformField = new JTextField();
        this.openDirectoryCooser = new JButton();
        this.registerDefault = new JRadioButton();
        this.instanceSelector = new JComboBox();
        this.registerLocal = new JRadioButton();
        this.registerRemote = new JRadioButton();
        this.createPersonal = new JRadioButton();
        this.spacingHack = new JLabel();
        this.instanceSelectorLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.description.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("TXT_platformPanelDescription"));
        this.description.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.description, gridBagConstraints);
        this.platformFieldLabel.setDisplayedMnemonic(NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"MNM_platformFieldLabel").charAt(0));
        this.platformFieldLabel.setLabelFor(this.platformField);
        this.platformFieldLabel.setText(NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"platformFieldLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 0, 5, 6);
        this.add((Component)this.platformFieldLabel, gridBagConstraints);
        this.platformField.setColumns(21);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 5, 6);
        this.add((Component)this.platformField, gridBagConstraints);
        this.platformField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("DSC_platformField"));
        this.openDirectoryCooser.setMnemonic(NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"MNM_openDirectoryChooser").charAt(0));
        this.openDirectoryCooser.setText(NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"LBL_openDirectoryChooser"));
        this.openDirectoryCooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddInstanceVisualPlatformPanel.this.openDirectoryCooserActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(6, 7, 5, 0);
        this.add((Component)this.openDirectoryCooser, gridBagConstraints);
        this.openDirectoryCooser.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("DSC_openDirectoryChooser"));
        this.instanceTypeButtonGroup.add(this.registerDefault);
        this.registerDefault.setMnemonic(NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"MNM_registerDefault").charAt(0));
        this.registerDefault.setText(NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"LBL_registerDeafult"));
        this.registerDefault.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.registerDefault.setMargin(new Insets(0, 0, 0, 0));
        this.registerDefault.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                AddInstanceVisualPlatformPanel.this.registerDefaultItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 1, 5, 1);
        this.add((Component)this.registerDefault, gridBagConstraints);
        this.registerDefault.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("DSC_registerDefault"));
        this.instanceSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.instanceSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddInstanceVisualPlatformPanel.this.instanceSelectorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 11, 5, 0);
        this.add((Component)this.instanceSelector, gridBagConstraints);
        this.instanceSelector.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"Domain_A11Y_DESC"));
        this.instanceTypeButtonGroup.add(this.registerLocal);
        this.registerLocal.setMnemonic(NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"MNM_registerLocal").charAt(0));
        this.registerLocal.setText(NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"LBL_registerLocal"));
        this.registerLocal.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.registerLocal.setMargin(new Insets(0, 0, 0, 0));
        this.registerLocal.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                AddInstanceVisualPlatformPanel.this.registerLocalItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 5, 0);
        this.add((Component)this.registerLocal, gridBagConstraints);
        this.registerLocal.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("DSC_registerLocal"));
        this.instanceTypeButtonGroup.add(this.registerRemote);
        this.registerRemote.setMnemonic(NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"MNM_registerRemote").charAt(0));
        this.registerRemote.setText(NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"LBL_registerRemote"));
        this.registerRemote.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.registerRemote.setMargin(new Insets(0, 0, 0, 0));
        this.registerRemote.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                AddInstanceVisualPlatformPanel.this.registerRemoteItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 5, 0);
        this.add((Component)this.registerRemote, gridBagConstraints);
        this.registerRemote.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("DSC_registerRemote"));
        this.instanceTypeButtonGroup.add(this.createPersonal);
        this.createPersonal.setMnemonic(NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"MNM_createPersonal").charAt(0));
        this.createPersonal.setText(NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"LBL_createPersonal"));
        this.createPersonal.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.createPersonal.setMargin(new Insets(0, 0, 0, 0));
        this.createPersonal.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                AddInstanceVisualPlatformPanel.this.createPersonalItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.createPersonal, gridBagConstraints);
        this.createPersonal.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("DSC_createPersonal"));
        this.spacingHack.setEnabled(false);
        this.spacingHack.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.spacingHack, gridBagConstraints);
        this.instanceSelectorLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("MNM_instanceSelector").charAt(0));
        this.instanceSelectorLabel.setLabelFor(this.instanceSelector);
        this.instanceSelectorLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("LBL_instanceSelectorLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 23, 5, 6);
        this.add((Component)this.instanceSelectorLabel, gridBagConstraints);
        this.instanceSelectorLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"Domain_A11Y_DESC"));
    }

    private void instanceSelectorActionPerformed(ActionEvent evt) {
        this.fireChangeEvent();
    }

    private void createPersonalItemStateChanged(ItemEvent evt) {
        this.setSelectedType(AddDomainWizardIterator.PERSONAL, evt);
    }

    private void registerRemoteItemStateChanged(ItemEvent evt) {
        this.setSelectedType(AddDomainWizardIterator.REMOTE, evt);
    }

    private void registerLocalItemStateChanged(ItemEvent evt) {
        this.setSelectedType(AddDomainWizardIterator.LOCAL, evt);
    }

    private void registerDefaultItemStateChanged(ItemEvent evt) {
        this.setSelectedType(AddDomainWizardIterator.DEFAULT, evt);
    }

    private void openDirectoryCooserActionPerformed(ActionEvent evt) {
        String val = this.browseInstallLocation();
        if (null != val && val.length() >= 1) {
            this.platformField.setText(val);
        }
    }

    ComboBoxModel getDomainsListModel() {
        return this.instanceSelector.getModel();
    }

    private class PlatformInstChooser
    extends JFileChooser {
        private PlatformInstChooser() {
        }

        public void approveSelection() {
            File dir = FileUtil.normalizeFile((File)this.getSelectedFile());
            if (ServerLocationManager.isGoodAppServerLocation((File)dir)) {
                super.approveSelection();
            } else {
                this.setCurrentDirectory(dir);
            }
        }
    }
}

