/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.modules.ant.debugger.DebuggerAnnotation;
import org.netbeans.modules.ant.debugger.breakpoints.AntBreakpoint;
import org.openide.text.Annotatable;

public class BreakpointAnnotationListener
extends DebuggerManagerAdapter
implements PropertyChangeListener {
    private Map breakpointToAnnotation = new HashMap();

    public String[] getProperties() {
        return new String[]{"breakpoints"};
    }

    public void breakpointAdded(Breakpoint b) {
        if (!(b instanceof AntBreakpoint)) {
            return;
        }
        this.addAnnotation(b);
    }

    public void breakpointRemoved(Breakpoint b) {
        if (!(b instanceof AntBreakpoint)) {
            return;
        }
        this.removeAnnotation(b);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() != "enabled") {
            return;
        }
        this.removeAnnotation((Breakpoint)evt.getSource());
        this.addAnnotation((Breakpoint)evt.getSource());
    }

    private void addAnnotation(Breakpoint b) {
        this.breakpointToAnnotation.put(b, new DebuggerAnnotation(b.isEnabled() ? DebuggerAnnotation.BREAKPOINT_ANNOTATION_TYPE : DebuggerAnnotation.DISABLED_BREAKPOINT_ANNOTATION_TYPE, (Annotatable)((AntBreakpoint)b).getLine()));
        b.addPropertyChangeListener("enabled", (PropertyChangeListener)this);
    }

    private void removeAnnotation(Breakpoint b) {
        DebuggerAnnotation annotation = (DebuggerAnnotation)((Object)this.breakpointToAnnotation.remove(b));
        if (annotation == null) {
            return;
        }
        annotation.detach();
        b.removePropertyChangeListener("enabled", (PropertyChangeListener)this);
    }
}

