/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog.impl.sun;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.netbeans.modules.xml.catalog.impl.sun.Util;
import org.netbeans.modules.xml.catalog.spi.CatalogDescriptor;
import org.netbeans.modules.xml.catalog.spi.CatalogListener;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Catalog
implements CatalogReader,
CatalogDescriptor,
Serializable,
EntityResolver {
    private static final long serialVersionUID = 123659121L;
    private transient PropertyChangeSupport pchs;
    private transient EntityResolver peer;
    private transient String desc;
    private String location;
    private boolean preference = true;
    private static final String PROP_LOCATION = "cat-loc";
    private static final String PROP_PREF_PUBLIC = "cat-pref";
    private static final String PROP_DESC = "ca-desc";

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setShortDescription(Util.THIS.getString("MSG_prepared", this.location));
    }

    public synchronized void setLocation(String location) {
        String old = this.location;
        this.location = location;
        this.peer = null;
        this.getPCHS().firePropertyChange(PROP_LOCATION, old, location);
        this.updateDisplayName();
    }

    public String getLocation() {
        return this.location;
    }

    public void setPreferPublic(boolean val) {
        boolean old = this.preference;
        this.preference = val;
        this.getPCHS().firePropertyChange(PROP_LOCATION, old, val);
    }

    public boolean isPreferPublic() {
        return this.preference;
    }

    public void addCatalogListener(CatalogListener l) {
        throw new UnsupportedOperationException();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPCHS().addPropertyChangeListener(l);
    }

    public String getDisplayName() {
        String src = this.location;
        if (src == null || "".equals(src.trim())) {
            return Util.THIS.getString("PROP_missing_location");
        }
        return Util.THIS.getString("TITLE_catalog", this.location);
    }

    public String getName() {
        return this.getClass() + this.location + this.preference;
    }

    public void updateDisplayName() {
        String name = this.getDisplayName();
        this.getPCHS().firePropertyChange("ca-name", null, name);
    }

    public Image getIcon(int type) {
        return null;
    }

    public Iterator getPublicIDs() {
        EntityResolver p = this.getPeer();
        if (p instanceof CatalogResolver) {
            org.apache.xml.resolver.Catalog cat = ((CatalogResolver)p).getCatalog();
            return cat.getPublicIDs();
        }
        return null;
    }

    public String getShortDescription() {
        return this.desc;
    }

    public void setShortDescription(String desc) {
        String old = this.desc;
        this.desc = desc;
        this.getPCHS().firePropertyChange(PROP_DESC, old, desc);
    }

    public String getSystemID(String publicId) {
        EntityResolver p = this.getPeer();
        if (p instanceof CatalogResolver) {
            try {
                return ((CatalogResolver)p).getCatalog().resolveSystem(publicId);
            }
            catch (MalformedURLException ex) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public synchronized void refresh() {
        this.peer = this.createPeer(this.location, this.preference);
    }

    public void removeCatalogListener(CatalogListener l) {
        throw new UnsupportedOperationException();
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getPCHS().removePropertyChangeListener(l);
    }

    public InputSource resolveEntity(String publicID, String systemID) throws SAXException, IOException {
        return this.getPeer().resolveEntity(publicID, systemID);
    }

    private EntityResolver createPeer(String location, boolean pref) {
        try {
            CatalogManager manager = new CatalogManager(null);
            manager.setUseStaticCatalog(false);
            manager.setPreferPublic(pref);
            CatalogResolver catalogResolver = new CatalogResolver(manager);
            org.apache.xml.resolver.Catalog cat = catalogResolver.getCatalog();
            cat.parseCatalog(new URL(location));
            this.setShortDescription(Util.THIS.getString("DESC_loaded"));
            return catalogResolver;
        }
        catch (IOException ex) {
            this.setShortDescription(Util.THIS.getString("DESC_error_loading", ex.getLocalizedMessage()));
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("I/O error loading catalog " + location, ex);
            }
            return new EntityResolver(){

                public InputSource resolveEntity(String p, String s) {
                    return null;
                }
            };
        }
    }

    private synchronized PropertyChangeSupport getPCHS() {
        if (this.pchs == null) {
            this.pchs = new PropertyChangeSupport(this);
        }
        return this.pchs;
    }

    private synchronized EntityResolver getPeer() {
        if (this.peer == null) {
            this.peer = this.createPeer(this.location, this.preference);
        }
        return this.peer;
    }

    public String resolveURI(String name) {
        EntityResolver p = this.getPeer();
        if (p instanceof CatalogResolver) {
            try {
                return ((CatalogResolver)p).getCatalog().resolveURI(name);
            }
            catch (MalformedURLException ex) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public String resolvePublic(String publicId) {
        EntityResolver p = this.getPeer();
        if (p instanceof CatalogResolver) {
            try {
                return ((CatalogResolver)p).getCatalog().resolvePublic(publicId, null);
            }
            catch (MalformedURLException ex) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

