/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.text.Format;
import javax.swing.SwingUtilities;
import org.netbeans.modules.extbrowser.ExtBrowserImpl;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.extbrowser.URLUtil;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class UnixBrowserImpl
extends ExtBrowserImpl {
    protected static final int CMD_TIMEOUT = 6;

    protected static NbProcessDescriptor createPatchedExecutable(NbProcessDescriptor p) {
        NbProcessDescriptor newP = null;
        String[] args = Utilities.parseParameters((String)p.getArguments());
        if (args.length > 1) {
            if (ExtWebBrowser.getEM().isLoggable(1)) {
                ExtWebBrowser.getEM().log("Old arguments: " + p.getArguments());
            }
            StringBuffer newArgs = new StringBuffer();
            boolean found = false;
            for (int i = 0; i < args.length - 1; ++i) {
                if (newArgs.length() > 0) {
                    newArgs.append(" ");
                }
                if (args[i].indexOf("-remote") >= 0 && args[i + 1].indexOf("openURL(") >= 0) {
                    found = true;
                    newArgs.append("\"{URL}\"");
                    continue;
                }
                newArgs.append("\"" + args[i] + "\"");
            }
            if (found) {
                newP = new NbProcessDescriptor(p.getProcessName(), newArgs.toString(), p.getInfo());
            }
            if (ExtWebBrowser.getEM().isLoggable(1)) {
                ExtWebBrowser.getEM().log("ProcessName: " + p.getProcessName());
                ExtWebBrowser.getEM().log("New arguments: " + newArgs.toString());
            }
        }
        return newP;
    }

    public UnixBrowserImpl() {
        this(null);
    }

    public UnixBrowserImpl(ExtWebBrowser extBrowserFactory) {
        this.extBrowserFactory = extBrowserFactory;
        if (ExtWebBrowser.getEM().isLoggable(1)) {
            ExtWebBrowser.getEM().log("UnixBrowserImpl created from factory: " + extBrowserFactory);
        }
    }

    public void setURL(URL url) {
        if (SwingUtilities.isEventDispatchThread()) {
            final URL newUrl = url;
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    UnixBrowserImpl.this.setURL(newUrl);
                }
            });
            return;
        }
        NbProcessDescriptor cmd = this.extBrowserFactory.getBrowserExecutable();
        StatusDisplayer sd = StatusDisplayer.getDefault();
        try {
            url = URLUtil.createExternalURL(url, false);
            if (ExtWebBrowser.getEM().isLoggable(1)) {
                ExtWebBrowser.getEM().log(1, "External url: " + url);
            }
            cmd = this.extBrowserFactory.getBrowserExecutable();
            if (ExtWebBrowser.getEM().isLoggable(1)) {
                ExtWebBrowser.getEM().log(1, "Executable: " + cmd);
            }
            sd.setStatusText(NbBundle.getMessage((Class)UnixBrowserImpl.class, (String)"MSG_Running_command", (Object)cmd.getProcessName()));
            Process p = cmd.exec((Format)((Object)new ExtWebBrowser.UnixBrowserFormat(url.toString())));
            RequestProcessor.getDefault().post((Runnable)new Status(cmd, p, url), 1000);
            URL old = this.url;
            this.url = url;
            this.pcs.firePropertyChange("url", old, url);
        }
        catch (IOException ex) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)UnixBrowserImpl.class, (String)"MSG_Cant_run_netscape", (Object[])new Object[]{cmd.getProcessName()}), 2));
        }
        catch (NumberFormatException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private class Status
    implements Runnable {
        private static final String FAILURE_MSG_BADWINDOW = "BadWindow";
        private static final String FAILURE_MSG = "No running window found.";
        private NbProcessDescriptor cmd;
        private Process p;
        private URL url;
        private int retries = 6;

        public Status(NbProcessDescriptor cmd, Process p, URL url) {
            this.cmd = cmd;
            this.p = p;
            this.url = url;
        }

        public void run() {
            int l;
            StringBuffer sb;
            char[] buff;
            InputStreamReader r;
            int exitStatus;
            boolean retried;
            block23: {
                retried = false;
                if (ExtWebBrowser.getEM().isLoggable(1)) {
                    ExtWebBrowser.getEM().log(1, "Retried: " + retried);
                }
                exitStatus = 1;
                r = new InputStreamReader(this.p.getErrorStream());
                try {
                    exitStatus = this.p.exitValue();
                    if (ExtWebBrowser.getEM().isLoggable(1)) {
                        ExtWebBrowser.getEM().log(1, "Command executed. exitValue = " + exitStatus);
                    }
                }
                catch (IllegalThreadStateException ex) {
                    --this.retries;
                    if (ExtWebBrowser.getEM().isLoggable(1)) {
                        ExtWebBrowser.getEM().log(1, "Retries: " + this.retries);
                        ExtWebBrowser.getEM().log(1, "Time: " + System.currentTimeMillis());
                    }
                    if (this.retries > 0) {
                        RequestProcessor.getDefault().post((Runnable)this, 1000);
                        return;
                    }
                    if (!ExtWebBrowser.getEM().isLoggable(1)) break block23;
                    ExtWebBrowser.getEM().log(1, "Command not finished yet");
                }
            }
            if (exitStatus == 0 && Utilities.getOperatingSystem() == 16) {
                int LEN = 2048;
                buff = new char[2048];
                sb = new StringBuffer();
                try {
                    while ((l = ((Reader)r).read(buff, 0, 2048)) != -1) {
                        sb.append(buff, 0, l);
                    }
                    if (sb.toString().indexOf(FAILURE_MSG) >= 0) {
                        if (ExtWebBrowser.getEM().isLoggable(1)) {
                            ExtWebBrowser.getEM().log(1, "Browser output: \"No running window found.\"");
                        }
                        exitStatus = 2;
                    }
                }
                catch (IOException ioe) {
                    ExtWebBrowser.getEM().notify(16, (Throwable)ioe);
                }
            }
            if (exitStatus == 1 && Utilities.getOperatingSystem() == 16) {
                int LEN = 2048;
                buff = new char[2048];
                sb = new StringBuffer();
                try {
                    while ((l = ((Reader)r).read(buff, 0, 2048)) != -1) {
                        sb.append(buff, 0, l);
                    }
                    if (sb.toString().indexOf(FAILURE_MSG_BADWINDOW) >= 0) {
                        if (ExtWebBrowser.getEM().isLoggable(1)) {
                            ExtWebBrowser.getEM().log(1, "Browser output: \"BadWindow\"");
                        }
                        exitStatus = 0;
                    }
                }
                catch (IOException ioe) {
                    ExtWebBrowser.getEM().notify(16, (Throwable)ioe);
                }
            }
            if (exitStatus == 2) {
                try {
                    NbProcessDescriptor startCmd = UnixBrowserImpl.createPatchedExecutable(this.cmd);
                    if (startCmd != null) {
                        retried = true;
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$UnixBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$UnixBrowserImpl = UnixBrowserImpl.class$("org.netbeans.modules.extbrowser.UnixBrowserImpl")) : class$org$netbeans$modules$extbrowser$UnixBrowserImpl), (String)"MSG_Running_command", (Object)startCmd.getProcessName()));
                        Process pr = startCmd.exec((Format)((Object)new ExtWebBrowser.UnixBrowserFormat(this.url.toString())));
                    }
                }
                catch (IOException ioe) {
                    ExtWebBrowser.getEM().notify(16, (Throwable)ioe);
                }
            }
            if (exitStatus != 0 && !retried) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$UnixBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$UnixBrowserImpl = UnixBrowserImpl.class$("org.netbeans.modules.extbrowser.UnixBrowserImpl")) : class$org$netbeans$modules$extbrowser$UnixBrowserImpl), (String)"MSG_Cant_run_netscape", (Object[])new Object[]{this.cmd.getProcessName()}), 2));
                return;
            }
        }
    }
}

