/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.ReferenceableSerializer;
import com.sun.xml.rpc.encoding.SOAPSerializationState;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.soap.SOAPConstantsFactory;
import com.sun.xml.rpc.soap.SOAPEncodingConstants;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.streaming.XMLWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.soap.SOAPMessage;

public class SOAPSerializationContext {
    protected HashMap map;
    protected Map properties;
    protected LinkedList list;
    protected String prefix;
    protected long next;
    protected Stack encodingStyleContext = new Stack();
    protected String curEncodingStyle = null;
    protected Set activeObjects;
    protected SOAPMessage message;
    private SOAPVersion soapVer = SOAPVersion.SOAP_11;
    private SOAPEncodingConstants soapEncodingConstants = null;

    public SOAPSerializationContext() {
        this(null);
    }

    public void beginFragment() {
        this.activeObjects = new HashSet();
    }

    public void endFragment() {
        this.activeObjects = null;
    }

    private void initEncodingStyleInfo() {
        this.curEncodingStyle = this.encodingStyleContext.empty() ? null : (String)this.encodingStyleContext.peek();
    }

    public void popEncodingStyle() {
        this.encodingStyleContext.pop();
        this.initEncodingStyleInfo();
    }

    public SOAPVersion getSOAPVersion() {
        return this.soapVer;
    }

    private void init(SOAPVersion ver) {
        this.soapEncodingConstants = SOAPConstantsFactory.getSOAPEncodingConstants(ver);
        this.soapVer = ver;
    }

    public void serializeMultiRefObjects(XMLWriter writer) {
        while (!this.list.isEmpty()) {
            SOAPSerializationState state = (SOAPSerializationState)this.list.removeFirst();
            Object obj = state.getObject();
            ReferenceableSerializer ser = state.getSerializer();
            ser.serializeInstance(obj, null, true, writer, this);
        }
    }

    public void beginSerializing(Object obj) throws SerializationException {
        if (obj != null && this.activeObjects != null) {
            if (this.activeObjects.contains(obj)) {
                throw new SerializationException("soap.circularReferenceDetected", new Object[]{obj});
            }
            this.activeObjects.add(obj);
        }
    }

    public void doneSerializing(Object obj) throws SerializationException {
        if (obj != null && this.activeObjects != null) {
            this.activeObjects.remove(obj);
        }
    }

    public boolean isRegistered(Object obj) {
        return this.map.get(new MapKey(obj)) != null;
    }

    public String getEncodingStyle() {
        return this.curEncodingStyle;
    }

    public String nextID() {
        return this.prefix + this.next++;
    }

    public SOAPSerializationContext(String prefix) {
        this(prefix, SOAPVersion.SOAP_11);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public boolean setImplicitEncodingStyle(String newEncodingStyle) {
        if (newEncodingStyle == this.curEncodingStyle || newEncodingStyle.equals(this.curEncodingStyle)) {
            return false;
        }
        this.encodingStyleContext.push(newEncodingStyle);
        this.initEncodingStyleInfo();
        return true;
    }

    public SOAPMessage getMessage() {
        return this.message;
    }

    public void setMessage(SOAPMessage m) {
        this.message = m;
    }

    public SOAPSerializationState lookupObject(Object obj) {
        MapKey key = new MapKey(obj);
        return (SOAPSerializationState)this.map.get(key);
    }

    public SOAPSerializationContext(String prefix, SOAPVersion ver) {
        this.init(ver);
        if (prefix == null) {
            prefix = "ID";
        }
        this.map = new HashMap();
        this.properties = new HashMap();
        this.list = new LinkedList();
        this.prefix = prefix;
        this.next = 1L;
    }

    public boolean pushEncodingStyle(String newEncodingStyle, XMLWriter writer) throws Exception {
        if (newEncodingStyle == this.curEncodingStyle || newEncodingStyle.equals(this.curEncodingStyle)) {
            return false;
        }
        writer.writeAttribute(this.soapEncodingConstants.getQNameEnvelopeEncodingStyle(), newEncodingStyle);
        this.encodingStyleContext.push(newEncodingStyle);
        this.initEncodingStyleInfo();
        return true;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public SOAPSerializationState registerObject(Object obj, ReferenceableSerializer serializer) {
        MapKey key = new MapKey(obj);
        SOAPSerializationState state = (SOAPSerializationState)this.map.get(key);
        if (state == null) {
            state = new SOAPSerializationState(obj, this.nextID(), serializer);
            this.map.put(key, state);
            this.list.add(state);
        }
        return state;
    }

    private static class MapKey {
        Object obj;

        public int hashCode() {
            return System.identityHashCode(this.obj);
        }

        public MapKey(Object obj) {
            this.obj = obj;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MapKey)) {
                return false;
            }
            return this.obj == ((MapKey)o).obj;
        }
    }
}

