/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.literal;

import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.literal.LiteralObjectSerializerBase;
import com.sun.xml.rpc.encoding.xsd.XSDConstants;
import com.sun.xml.rpc.soap.SOAPConstantsFactory;
import com.sun.xml.rpc.soap.SOAPEncodingConstants;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.Text;

public class LiteralFragmentSerializer
extends LiteralObjectSerializerBase {
    protected SOAPFactory soapFactory;
    private SOAPEncodingConstants soapEncodingConstants = null;
    private static final String FIRST_PREFIX = "ns";

    private void init(SOAPVersion ver) {
        this.soapEncodingConstants = SOAPConstantsFactory.getSOAPEncodingConstants(ver);
        try {
            this.soapFactory = SOAPFactory.newInstance();
        }
        catch (SOAPException e) {}
    }

    protected boolean isAcceptableType(QName actualType) {
        return true;
    }

    protected boolean hasDefaultNamespace(SOAPElement element) {
        Iterator iter = element.getAllAttributes();
        while (iter.hasNext()) {
            Name aname = (Name)iter.next();
            if (!aname.getLocalName().equals("xmlns")) continue;
            return true;
        }
        return false;
    }

    protected void writeAdditionalNamespaceDeclarations(Object obj, XMLWriter writer) throws Exception {
    }

    public LiteralFragmentSerializer(QName type, boolean isNullable, String encodingStyle) {
        this(type, isNullable, encodingStyle, SOAPVersion.SOAP_11);
    }

    protected void doSerialize(Object obj, XMLWriter writer, SOAPSerializationContext context) throws Exception {
    }

    protected void doSerializeAttributes(Object obj, XMLWriter writer, SOAPSerializationContext context) throws Exception {
    }

    public LiteralFragmentSerializer(QName type, boolean isNullable, String encodingStyle, SOAPVersion ver) {
        this(type, isNullable, encodingStyle, false, ver);
    }

    public LiteralFragmentSerializer(QName type, boolean isNullable, String encodingStyle, boolean encodeType, SOAPVersion ver) {
        super(type, isNullable, encodingStyle, encodeType);
        this.init(ver);
    }

    protected Object doDeserialize(XMLReader reader, SOAPDeserializationContext context) throws Exception {
        String elementURI = reader.getURI();
        SOAPElement element = elementURI == null || elementURI.equals("") ? this.soapFactory.createElement(reader.getLocalName()) : this.soapFactory.createElement(reader.getLocalName(), FIRST_PREFIX, reader.getURI());
        String defaultURI = reader.getURI("");
        if (defaultURI != null) {
            element.addNamespaceDeclaration("", defaultURI);
        }
        Iterator iter = reader.getPrefixes();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            String uri = reader.getURI(prefix);
            element.addNamespaceDeclaration(prefix, uri);
        }
        Attributes attributes = reader.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            if (!attributes.isNamespaceDeclaration(i)) {
                Name name;
                String uri = attributes.getURI(i);
                if (uri == null) {
                    name = this.soapFactory.createName(attributes.getLocalName(i));
                } else {
                    String prefix = attributes.getPrefix(i);
                    name = this.soapFactory.createName(attributes.getLocalName(i), prefix, uri);
                }
                element.addAttribute(name, attributes.getValue(i));
            }
            ++i;
        }
        reader.next();
        while (reader.getState() != 2) {
            int state = reader.getState();
            if (state == 1) {
                SOAPElement child = (SOAPElement)this.deserialize(null, reader, context);
                element.addChildElement(child);
            } else if (state == 3) {
                element.addTextNode(reader.getValue());
            }
            reader.next();
        }
        return element;
    }

    protected void internalSerialize(Object obj, QName name, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        boolean pushedEncodingStyle = false;
        if (obj == null) {
            if (!this.isNullable) {
                throw new SerializationException("literal.unexpectedNull");
            }
            writer.startElement(name != null ? name : this.type);
            writer.writeAttributeUnquoted(XSDConstants.QNAME_XSI_NIL, "1");
            writer.endElement();
        } else {
            SOAPElement element = (SOAPElement)obj;
            Name elementName = element.getElementName();
            if (this.hasDefaultNamespace(element)) {
                writer.startElement(elementName.getLocalName(), elementName.getURI());
            } else {
                writer.startElement(elementName.getLocalName(), elementName.getURI(), elementName.getPrefix());
            }
            Iterator iter = element.getNamespacePrefixes();
            while (iter.hasNext()) {
                String prefix = (String)iter.next();
                String uri = element.getNamespaceURI(prefix);
                String existingURI = writer.getURI(prefix);
                if (existingURI != null && existingURI.equals(uri)) continue;
                writer.writeNamespaceDeclaration(prefix, uri);
            }
            if (this.encodingStyle != null) {
                pushedEncodingStyle = context.pushEncodingStyle(this.encodingStyle, writer);
            }
            Iterator iter2 = element.getAllAttributes();
            while (iter2.hasNext()) {
                Name aname = (Name)iter2.next();
                String value = element.getAttributeValue(aname);
                writer.writeAttribute(aname.getLocalName(), aname.getURI(), value);
            }
            Iterator iter3 = element.getChildElements();
            while (iter3.hasNext()) {
                Node node = (Node)iter3.next();
                if (node instanceof Text) {
                    Text text = (Text)node;
                    if (text.isComment()) continue;
                    writer.writeChars(text.getValue());
                    continue;
                }
                if (!(node instanceof SOAPElement)) continue;
                this.serialize(node, null, null, writer, context);
            }
            writer.endElement();
            if (pushedEncodingStyle) {
                context.popEncodingStyle();
            }
        }
    }
}

