/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.LiteralEncoding;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SOAPEncoding;
import com.sun.xml.rpc.processor.generator.writer.LiteralSequenceSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.SOAPObjectSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriterBase;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.GeneratedFileInfo;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.soap.SOAPVersion;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class InterfaceSerializerGenerator
extends GeneratorBase {
    private Set visitedTypes;
    private Fault currentFault = null;
    private static final String OBJECT_SERIALIZER_BASE = "ObjectSerializerBase";
    private static final String INTERFACE_SERIALIZER_BASE = "InterfaceSerializerBase";

    public InterfaceSerializerGenerator() {
    }

    private void typeVisited(AbstractType type) {
        this.visitedTypes.add(type);
    }

    private void writeObjectSerializerForType(AbstractType type) throws IOException {
        boolean isInterface;
        boolean bl = isInterface = ((JavaStructureType)type.getJavaType()).getAllSubclasses() != null;
        if (!isInterface) {
            return;
        }
        JavaType javaType = type.getJavaType();
        String className = this.env.getNames().typeInterfaceSerializerClassName(this.servicePackage, type);
        if (this.donotOverride && GeneratorUtil.classExists(this.env, className)) {
            this.log("Class " + className + " exists. Not overriding.");
            return;
        }
        File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
        try {
            GeneratedFileInfo fi = new GeneratedFileInfo();
            fi.setFile(classFile);
            fi.setType("InterfaceSerializer");
            this.env.addGeneratedFile(fi);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            this.writeObjectSerializerCode(out, type);
            out.close();
        }
        catch (IOException e) {
            GeneratorBase.fail("generator.cant.write", classFile.toString());
        }
    }

    private boolean haveVisited(AbstractType type) {
        return this.visitedTypes.contains(type);
    }

    protected void preVisitFault(Fault fault) throws Exception {
        if (fault.getBlock().getType().isSOAPType()) {
            this.currentFault = fault;
            ((SOAPType)fault.getBlock().getType()).accept(this);
            this.currentFault = null;
        }
        if (fault.getBlock().getType().isLiteralType()) {
            this.currentFault = fault;
            ((LiteralType)fault.getBlock().getType()).accept(this);
            this.currentFault = null;
        }
    }

    protected void postVisitModel(Model model) throws Exception {
        Iterator types = model.getExtraTypes();
        while (types.hasNext()) {
            AbstractType type = (AbstractType)types.next();
            if (!type.isSOAPType()) continue;
            ((SOAPType)type).accept(this);
        }
        this.visitedTypes = null;
    }

    protected void preVisitModel(Model model) throws Exception {
        this.visitedTypes = new HashSet();
    }

    public void preVisitLiteralAllType(LiteralAllType type) throws Exception {
        this.visitLiteralStructuredType(type);
    }

    public void preVisitLiteralSequenceType(LiteralSequenceType type) throws Exception {
        this.visitLiteralStructuredType(type);
    }

    private void visitLiteralStructuredType(LiteralStructuredType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
        try {
            this.writeObjectSerializerForType(type);
        }
        catch (IOException e) {
            GeneratorBase.fail("generator.cant.write", type.getName().getLocalPart());
        }
    }

    protected void preVisitSOAPAnyType(SOAPAnyType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    protected void preVisitSOAPArrayType(SOAPArrayType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    protected void preVisitSOAPEnumerationType(SOAPEnumerationType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    protected void preVisitSOAPSimpleType(SOAPSimpleType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    public void preVisitSOAPStructureType(SOAPStructureType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
        try {
            this.writeObjectSerializerForType(type);
        }
        catch (IOException e) {
            GeneratorBase.fail("generator.cant.write", type.getName().getLocalPart());
        }
    }

    private void writeImports(IndentingWriter p) throws IOException {
        p.pln("import com.sun.xml.rpc.encoding.*;");
        p.pln("import com.sun.xml.rpc.encoding.literal.DetailFragmentDeserializer;");
        p.pln("import com.sun.xml.rpc.encoding.soap.SOAPConstants;");
        p.pln("import com.sun.xml.rpc.soap.SOAPVersion;");
        p.pln("import com.sun.xml.rpc.streaming.*;");
        p.pln("import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;");
        p.pln("import javax.xml.namespace.QName;");
    }

    private void writeDoDeserializeMethod(IndentingWriter p, AbstractType type) throws IOException {
        String serializer;
        SerializerWriter writer;
        p.plnI("public java.lang.Object doDeserialize(javax.xml.namespace.QName name, XMLReader reader,");
        p.pln("SOAPDeserializationContext context) throws Exception {");
        JavaStructureType javaType = (JavaStructureType)type.getJavaType();
        TreeSet subclassSet = new TreeSet(new GeneratorUtil.SubclassComparator());
        subclassSet.addAll(javaType.getAllSubclassesSet());
        Iterator subclasses = subclassSet.iterator();
        p.pln("javax.xml.namespace.QName elementType = getType(reader);");
        int i = 0;
        while (subclasses != null && subclasses.hasNext()) {
            JavaStructureType subclass = (JavaStructureType)subclasses.next();
            AbstractType abstractType = (AbstractType)subclass.getOwner();
            writer = this.writerFactory.createWriter(this.servicePackage, abstractType);
            serializer = writer.deserializerMemberName();
            if (i > 0) {
                p.p(" else ");
            }
            p.plnI("if (elementType != null && elementType.equals(" + serializer + ".getXmlType())) {");
            p.pln("return " + serializer + ".deserialize(name, reader, context);");
            p.pO("}");
            ++i;
        }
        if (i > 0) {
            p.p(" else ");
        }
        writer = type.isSOAPType() ? new SOAPObjectSerializerWriter(this.servicePackage, (SOAPType)type, this.env.getNames()) : new LiteralSequenceSerializerWriter(this.servicePackage, (LiteralType)type, this.env.getNames());
        serializer = writer.deserializerMemberName();
        p.plnI("if (elementType == null || elementType.equals(" + serializer + ".getXmlType())) {");
        p.pln("Object obj = " + serializer + ".deserialize(name, reader, context);");
        if (javaType instanceof JavaException) {
            p.plnI("while (reader.getState() == XMLReader.START) {");
            p.pln("reader.skipElement();");
            p.pln("reader.nextElementContent();");
            p.pOln("}");
        }
        p.pln("return obj;");
        p.pOln("}");
        p.pln("throw new DeserializationException(\"soap.unexpectedElementType\", new Object[] {\"\", elementType.toString()});");
        p.pOln("}");
    }

    private void writeDoSerializeInstanceMethod(IndentingWriter p, AbstractType type) throws IOException {
        String serializer;
        SerializerWriter writer;
        p.plnI("public void doSerializeInstance(java.lang.Object obj, javax.xml.namespace.QName name, SerializerCallback callback,");
        p.pln("XMLWriter writer, SOAPSerializationContext context) throws Exception {");
        p.pln(type.getJavaType().getName() + " instance = (" + type.getJavaType().getName() + ")obj;");
        p.pln();
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        TreeSet subclassSet = new TreeSet(new GeneratorUtil.SubclassComparator());
        subclassSet.addAll(javaStructure.getAllSubclassesSet());
        Iterator subclasses = subclassSet.iterator();
        Iterator iterator = javaStructure.getMembers();
        if (subclasses != null) {
            int i = 0;
            while (subclasses.hasNext()) {
                JavaStructureType subclass = (JavaStructureType)subclasses.next();
                AbstractType abstractType = (AbstractType)subclass.getOwner();
                writer = this.writerFactory.createWriter(this.servicePackage, abstractType);
                serializer = writer.deserializerMemberName();
                if (i > 0) {
                    p.p(" else ");
                }
                p.plnI("if (obj instanceof " + subclass.getName() + ") {");
                p.pln(serializer + ".serialize(obj, name, callback, writer, context);");
                p.pO("}");
                ++i;
            }
            p.plnI(" else {");
        }
        writer = type.isSOAPType() ? new SOAPObjectSerializerWriter(this.servicePackage, (SOAPType)type, this.env.getNames()) : new LiteralSequenceSerializerWriter(this.servicePackage, (LiteralType)type, this.env.getNames());
        serializer = writer.deserializerMemberName();
        p.pln(serializer + ".serialize(obj, name, callback, writer, context);");
        p.pOln("}");
        p.pOln("}");
    }

    private void writeInitialize(IndentingWriter p, AbstractType type) throws IOException {
        SerializerWriter writer;
        p.plnI("public void initialize(InternalTypeMappingRegistry registry) throws Exception {");
        HashSet processedTypes = new HashSet();
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        TreeSet subclassSet = new TreeSet(new GeneratorUtil.SubclassComparator());
        subclassSet.addAll(javaStructure.getAllSubclassesSet());
        Iterator iterator = subclassSet.iterator();
        while (iterator != null && iterator.hasNext()) {
            AbstractType abstractType = (AbstractType)((JavaStructureType)iterator.next()).getOwner();
            writer = this.writerFactory.createWriter(this.servicePackage, abstractType);
            writer.initializeSerializer(p, this.env.getNames().getTypeQName(abstractType.getName()), "registry");
            p.pln(writer.serializerMemberName() + " = " + writer.serializerMemberName() + ".getInnermostSerializer();");
        }
        writer = type.isSOAPType() ? new SOAPObjectSerializerWriter(this.servicePackage, (SOAPType)type, this.env.getNames()) : new LiteralSequenceSerializerWriter(this.servicePackage, (LiteralType)type, this.env.getNames());
        StringBuffer typeName = new StringBuffer(40);
        typeName.append("type");
        writer.createSerializer(p, typeName, "interfaceSerializer", this.encodeTypes, false, null);
        p.pln(writer.serializerMemberName() + " = interfaceSerializer.getInnermostSerializer();");
        p.plnI("if (" + writer.serializerMemberName() + " instanceof Initializable) {");
        p.pln("((Initializable)" + writer.serializerMemberName() + ").initialize(registry);");
        p.pOln("}");
        p.pOln("}");
    }

    private void writeMembers(IndentingWriter p, AbstractType type) throws IOException {
        HashSet processedTypes = new HashSet();
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        TreeSet subclassSet = new TreeSet(new GeneratorUtil.SubclassComparator());
        subclassSet.addAll(javaStructure.getAllSubclassesSet());
        Iterator iterator = subclassSet.iterator();
        while (iterator != null && iterator.hasNext()) {
            if (type.isSOAPType()) {
                SOAPEncoding.writeStaticSerializer(p, this.servicePackage, (SOAPType)((JavaStructureType)iterator.next()).getOwner(), processedTypes, this.writerFactory, this.env.getNames());
                continue;
            }
            LiteralEncoding.writeStaticSerializer(p, this.servicePackage, (LiteralType)((JavaStructureType)iterator.next()).getOwner(), processedTypes, this.writerFactory, this.env.getNames());
        }
        SerializerWriterBase writer = type.isSOAPType() ? new SOAPObjectSerializerWriter(this.servicePackage, (SOAPType)type, this.env.getNames()) : new LiteralSequenceSerializerWriter(this.servicePackage, (LiteralType)type, this.env.getNames());
        p.pln("private CombinedSerializer " + writer.serializerMemberName() + ";");
    }

    private void writeObjectSerializerCode(IndentingWriter p, AbstractType type) throws IOException {
        this.log("writing  serializer/deserializer for: " + type.getName().getLocalPart());
        String className = this.env.getNames().typeInterfaceSerializerClassName(this.servicePackage, type);
        this.writePackage(p, className);
        this.writeImports(p);
        p.pln();
        this.writeClassDecl(p, className);
        this.writeMembers(p, type);
        p.pln();
        this.writeConstructor(p, className, type);
        p.pln();
        this.writeInitialize(p, type);
        p.pln();
        this.writeDoDeserializeMethod(p, type);
        p.pln();
        this.writeDoSerializeInstanceMethod(p, type);
        if (type instanceof RPCResponseStructureType) {
            this.writeVerifyNameOverrideMethod(p, type);
        }
        p.pOln("}");
    }

    private void writeVerifyNameOverrideMethod(IndentingWriter p, AbstractType type) throws IOException {
        p.plnI("protected void verifyName(XMLReader reader, javax.xml.namespace.QName expectedName) throws java.lang.Exception {");
        p.pOln("}");
    }

    private void writeClassDecl(IndentingWriter p, String className) throws IOException {
        String baseClass = INTERFACE_SERIALIZER_BASE;
        p.plnI("public class " + Names.stripQualifier(className) + " extends " + baseClass + " implements Initializable {");
    }

    private void writeConstructor(IndentingWriter p, String className, AbstractType type) throws IOException {
        if (type.isSOAPType()) {
            p.plnI("public " + Names.stripQualifier(className) + "(QName type, boolean encodeType, " + "boolean isNullable, String encodingStyle) {");
            p.pln("super(type, encodeType, isNullable, encodingStyle);");
            p.pOln("}");
        } else {
            p.plnI("public " + Names.stripQualifier(className) + "(QName type, String encodingStyle, " + "boolean encodeType) {");
            p.pln("super(type, encodeType, true, encodingStyle);");
            p.pOln("}");
        }
    }

    private InterfaceSerializerGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new InterfaceSerializerGenerator(model, config, properties);
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties, SOAPVersion ver) {
        return new InterfaceSerializerGenerator(model, config, properties);
    }
}

