/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.wsdl.parser;

import com.sun.xml.rpc.util.xml.XmlUtil;
import com.sun.xml.rpc.wsdl.document.WSDLConstants;
import com.sun.xml.rpc.wsdl.document.mime.MIMEConstants;
import com.sun.xml.rpc.wsdl.document.mime.MIMEContent;
import com.sun.xml.rpc.wsdl.document.mime.MIMEMultipartRelated;
import com.sun.xml.rpc.wsdl.document.mime.MIMEPart;
import com.sun.xml.rpc.wsdl.document.mime.MIMEXml;
import com.sun.xml.rpc.wsdl.framework.Extensible;
import com.sun.xml.rpc.wsdl.framework.Extension;
import com.sun.xml.rpc.wsdl.framework.ParserContext;
import com.sun.xml.rpc.wsdl.framework.WriterContext;
import com.sun.xml.rpc.wsdl.parser.ExtensionHandler;
import com.sun.xml.rpc.wsdl.parser.Util;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class MIMEExtensionHandler
extends ExtensionHandler {
    public String getNamespaceURI() {
        return "http://schemas.xmlsoap.org/wsdl/mime/";
    }

    public void doHandleExtension(WriterContext context, Extension extension) throws IOException {
        if (extension instanceof MIMEContent) {
            MIMEContent content = (MIMEContent)extension;
            context.writeStartTag(content.getElementName());
            context.writeAttribute("part", content.getPart());
            context.writeAttribute("type", content.getType());
            context.writeEndTag(content.getElementName());
        } else if (extension instanceof MIMEXml) {
            MIMEXml mimeXml = (MIMEXml)extension;
            context.writeStartTag(mimeXml.getElementName());
            context.writeAttribute("part", mimeXml.getPart());
            context.writeEndTag(mimeXml.getElementName());
        } else if (extension instanceof MIMEMultipartRelated) {
            MIMEMultipartRelated mpr = (MIMEMultipartRelated)extension;
            context.writeStartTag(mpr.getElementName());
            Iterator iter = mpr.getParts();
            while (iter.hasNext()) {
                MIMEPart part = (MIMEPart)iter.next();
                context.writeStartTag(part.getElementName());
                Iterator iter2 = part.extensions();
                while (iter2.hasNext()) {
                    Extension e = (Extension)iter2.next();
                    ExtensionHandler h = (ExtensionHandler)this._extensionHandlers.get(e.getElementName().getNamespaceURI());
                    if (h == null) continue;
                    h.doHandleExtension(context, e);
                }
                context.writeEndTag(part.getElementName());
            }
            context.writeEndTag(mpr.getElementName());
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected MIMEContent parseMIMEContent(ParserContext context, Element e) {
        String type;
        context.push();
        context.registerNamespaces(e);
        MIMEContent content = new MIMEContent();
        String part = XmlUtil.getAttributeOrNull(e, "part");
        if (part != null) {
            content.setPart(part);
        }
        if ((type = XmlUtil.getAttributeOrNull(e, "type")) != null) {
            content.setType(type);
        }
        context.pop();
        context.fireDoneParsingEntity(MIMEConstants.QNAME_CONTENT, content);
        return content;
    }

    protected MIMEXml parseMIMEXml(ParserContext context, Element e) {
        context.push();
        context.registerNamespaces(e);
        MIMEXml mimeXml = new MIMEXml();
        String part = XmlUtil.getAttributeOrNull(e, "part");
        if (part != null) {
            mimeXml.setPart(part);
        }
        context.pop();
        context.fireDoneParsingEntity(MIMEConstants.QNAME_MIME_XML, mimeXml);
        return mimeXml;
    }

    public boolean doHandleExtension(ParserContext context, Extensible parent, Element e) {
        if (parent.getElementName().equals(WSDLConstants.QNAME_OUTPUT)) {
            return this.handleInputOutputExtension(context, parent, e);
        }
        if (parent.getElementName().equals(WSDLConstants.QNAME_INPUT)) {
            return this.handleInputOutputExtension(context, parent, e);
        }
        if (parent.getElementName().equals(MIMEConstants.QNAME_PART)) {
            return this.handleMIMEPartExtension(context, parent, e);
        }
        context.fireIgnoringExtension(new QName(e.getNamespaceURI(), e.getLocalName()), parent.getElementName());
        return false;
    }

    protected boolean handleInputOutputExtension(ParserContext context, Extensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, MIMEConstants.QNAME_MULTIPART_RELATED)) {
            context.push();
            context.registerNamespaces(e);
            MIMEMultipartRelated mpr = new MIMEMultipartRelated();
            Iterator iter = XmlUtil.getAllChildren(e);
            while (iter.hasNext()) {
                Element e2 = Util.nextElement(iter);
                if (e2 == null) break;
                if (XmlUtil.matchesTagNS(e2, MIMEConstants.QNAME_PART)) {
                    context.push();
                    context.registerNamespaces(e2);
                    MIMEPart part = new MIMEPart();
                    String name = XmlUtil.getAttributeOrNull(e2, "name");
                    if (name != null) {
                        part.setName(name);
                    }
                    Iterator iter2 = XmlUtil.getAllChildren(e2);
                    while (iter2.hasNext()) {
                        Element e3 = Util.nextElement(iter2);
                        if (e3 == null) break;
                        ExtensionHandler h = (ExtensionHandler)this._extensionHandlers.get(e3.getNamespaceURI());
                        boolean handled = false;
                        if (h != null) {
                            handled = h.doHandleExtension(context, part, e3);
                        }
                        if (handled) continue;
                        String required = XmlUtil.getAttributeNSOrNull(e3, "required", "http://schemas.xmlsoap.org/wsdl/");
                        if (required != null && required.equals("true")) {
                            Util.fail("parsing.requiredExtensibilityElement", e3.getTagName(), e3.getNamespaceURI());
                            continue;
                        }
                        context.fireIgnoringExtension(new QName(e3.getNamespaceURI(), e3.getLocalName()), part.getElementName());
                    }
                    mpr.add(part);
                    context.pop();
                    context.fireDoneParsingEntity(MIMEConstants.QNAME_PART, part);
                    continue;
                }
                Util.fail("parsing.invalidElement", e2.getTagName(), e2.getNamespaceURI());
            }
            parent.addExtension(mpr);
            context.pop();
            context.fireDoneParsingEntity(MIMEConstants.QNAME_MULTIPART_RELATED, mpr);
            return true;
        }
        if (XmlUtil.matchesTagNS(e, MIMEConstants.QNAME_CONTENT)) {
            MIMEContent content = this.parseMIMEContent(context, e);
            parent.addExtension(content);
            return true;
        }
        if (XmlUtil.matchesTagNS(e, MIMEConstants.QNAME_MIME_XML)) {
            MIMEXml mimeXml = this.parseMIMEXml(context, e);
            parent.addExtension(mimeXml);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    protected boolean handleMIMEPartExtension(ParserContext context, Extensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, MIMEConstants.QNAME_CONTENT)) {
            MIMEContent content = this.parseMIMEContent(context, e);
            parent.addExtension(content);
            return true;
        }
        if (XmlUtil.matchesTagNS(e, MIMEConstants.QNAME_MIME_XML)) {
            MIMEXml mimeXml = this.parseMIMEXml(context, e);
            parent.addExtension(mimeXml);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }
}

