/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.classpath;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;

public class ClassPathSupport {
    private PropertyEvaluator evaluator;
    private ReferenceHelper referenceHelper;
    private AntProjectHelper antProjectHelper;
    private Set wellKnownPaths;
    private String libraryPrefix;
    private String librarySuffix;
    private String antArtifactPrefix;
    static /* synthetic */ Class class$org$netbeans$modules$java$j2seproject$classpath$ClassPathSupport;

    public ClassPathSupport(PropertyEvaluator evaluator, ReferenceHelper referenceHelper, AntProjectHelper antProjectHelper, String[] wellKnownPaths, String libraryPrefix, String librarySuffix, String antArtifactPrefix) {
        this.evaluator = evaluator;
        this.referenceHelper = referenceHelper;
        this.antProjectHelper = antProjectHelper;
        this.wellKnownPaths = wellKnownPaths == null ? null : new HashSet<String>(Arrays.asList(wellKnownPaths));
        this.libraryPrefix = libraryPrefix;
        this.librarySuffix = librarySuffix;
        this.antArtifactPrefix = antArtifactPrefix;
    }

    public Iterator itemsIterator(String propertyValue) {
        return this.itemsList(propertyValue).iterator();
    }

    public List itemsList(String propertyValue) {
        String[] pe = PropertyUtils.tokenizePath((String)(propertyValue == null ? "" : propertyValue));
        ArrayList<Item> items = new ArrayList<Item>(pe.length);
        for (int i = 0; i < pe.length; ++i) {
            Item item;
            if (this.isWellKnownPath(pe[i])) {
                item = Item.create(pe[i]);
            } else if (this.isLibrary(pe[i])) {
                String libraryName = pe[i].substring(this.libraryPrefix.length(), pe[i].lastIndexOf(46));
                Library library = LibraryManager.getDefault().getLibrary(libraryName);
                item = library == null ? Item.createBroken(1, pe[i]) : Item.create(library, pe[i]);
            } else if (this.isAntArtifact(pe[i])) {
                Object[] ret = this.referenceHelper.findArtifactAndLocation(pe[i]);
                if (ret[0] == null || ret[1] == null) {
                    item = Item.createBroken(2, pe[i]);
                } else {
                    File artifactFile;
                    AntArtifact artifact = (AntArtifact)ret[0];
                    URI uri = (URI)ret[1];
                    File usedFile = this.antProjectHelper.resolveFile(this.evaluator.evaluate(pe[i]));
                    item = usedFile.equals(artifactFile = new File(artifact.getScriptLocation().toURI().resolve(uri).normalize())) ? Item.create(artifact, uri, pe[i]) : Item.createBroken(2, pe[i]);
                }
            } else {
                String eval = this.evaluator.evaluate(pe[i]);
                File f = null;
                if (eval != null) {
                    f = this.antProjectHelper.resolveFile(eval);
                }
                item = f == null || !f.exists() ? Item.createBroken(0, pe[i]) : Item.create(f, pe[i]);
            }
            items.add(item);
        }
        return items;
    }

    public String[] encodeToStrings(Iterator classpath) {
        ArrayList<String> result = new ArrayList<String>();
        while (classpath.hasNext()) {
            Item item = (Item)classpath.next();
            String reference = null;
            switch (item.getType()) {
                case 0: {
                    reference = item.getReference();
                    if (item.isBroken() || reference != null) break;
                    File file = item.getFile();
                    reference = this.referenceHelper.createForeignFileReference(file, null);
                    break;
                }
                case 1: {
                    reference = item.getReference();
                    if (item.isBroken()) break;
                    Library library = item.getLibrary();
                    if (reference != null || library == null) break;
                    reference = this.getLibraryReference(item);
                    break;
                }
                case 2: {
                    reference = item.getReference();
                    if (item.isBroken()) break;
                    AntArtifact artifact = item.getArtifact();
                    if (reference != null || artifact == null) break;
                    reference = this.referenceHelper.addReference(item.getArtifact(), item.getArtifactURI());
                    break;
                }
                case 3: {
                    reference = item.getReference();
                }
            }
            if (reference == null) continue;
            result.add(reference);
        }
        String[] items = new String[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            items[i] = i < result.size() - 1 ? result.get(i) + ":" : (String)result.get(i);
        }
        return items;
    }

    public String getLibraryReference(Item item) {
        if (item.getType() != 1) {
            throw new IllegalArgumentException("Item must be of type LIBRARY");
        }
        return this.libraryPrefix + item.getLibrary().getName() + this.librarySuffix;
    }

    private boolean isWellKnownPath(String property) {
        return this.wellKnownPaths == null ? false : this.wellKnownPaths.contains(property);
    }

    private boolean isAntArtifact(String property) {
        return this.antArtifactPrefix == null ? false : property.startsWith(this.antArtifactPrefix);
    }

    private boolean isLibrary(String property) {
        if (this.libraryPrefix != null && property.startsWith(this.libraryPrefix)) {
            return this.librarySuffix == null ? true : property.endsWith(this.librarySuffix);
        }
        return false;
    }

    public static class Item {
        public static final int TYPE_JAR = 0;
        public static final int TYPE_LIBRARY = 1;
        public static final int TYPE_ARTIFACT = 2;
        public static final int TYPE_CLASSPATH = 3;
        private static final String BROKEN = "BrokenReference";
        private Object object;
        private URI artifactURI;
        private int type;
        private String property;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Item(int type, Object object, String property) {
            this.type = type;
            this.object = object;
            this.property = property;
        }

        private Item(int type, Object object, URI artifactURI, String property) {
            this(type, object, property);
            this.artifactURI = artifactURI;
        }

        public static Item create(Library library, String property) {
            if (library == null) {
                throw new IllegalArgumentException("library must not be null");
            }
            return new Item(1, library, property);
        }

        public static Item create(AntArtifact artifact, URI artifactURI, String property) {
            if (artifactURI == null) {
                throw new IllegalArgumentException("artifactURI must not be null");
            }
            if (artifact == null) {
                throw new IllegalArgumentException("artifact must not be null");
            }
            return new Item(2, artifact, artifactURI, property);
        }

        public static Item create(File file, String property) {
            if (file == null) {
                throw new IllegalArgumentException("file must not be null");
            }
            return new Item(0, file, property);
        }

        public static Item create(String property) {
            if (property == null) {
                throw new IllegalArgumentException("property must not be null");
            }
            return new Item(3, null, property);
        }

        public static Item createBroken(int type, String property) {
            if (property == null) {
                throw new IllegalArgumentException("property must not be null in broken items");
            }
            return new Item(type, BROKEN, property);
        }

        public int getType() {
            return this.type;
        }

        public Library getLibrary() {
            if (this.getType() != 1) {
                throw new IllegalArgumentException("Item is not of required type - LIBRARY");
            }
            if (!$assertionsDisabled && !(this.object instanceof Library)) {
                throw new AssertionError((Object)("Invalid object type: " + this.object.getClass().getName() + " instance: " + this.object.toString() + " expected type: Library"));
            }
            return (Library)this.object;
        }

        public File getFile() {
            if (this.getType() != 0) {
                throw new IllegalArgumentException("Item is not of required type - JAR");
            }
            return (File)this.object;
        }

        public AntArtifact getArtifact() {
            if (this.getType() != 2) {
                throw new IllegalArgumentException("Item is not of required type - ARTIFACT");
            }
            return (AntArtifact)this.object;
        }

        public URI getArtifactURI() {
            if (this.getType() != 2) {
                throw new IllegalArgumentException("Item is not of required type - ARTIFACT");
            }
            return this.artifactURI;
        }

        public String getReference() {
            return this.property;
        }

        public boolean isBroken() {
            return this.object == BROKEN;
        }

        public int hashCode() {
            int hash = this.getType();
            if (this.object == BROKEN) {
                return BROKEN.hashCode();
            }
            switch (this.getType()) {
                case 2: {
                    hash += this.getArtifact().getType().hashCode();
                    hash += this.getArtifact().getScriptLocation().hashCode();
                    hash += this.getArtifactURI().hashCode();
                    break;
                }
                case 3: {
                    hash += this.property.hashCode();
                    break;
                }
                default: {
                    hash += this.object.hashCode();
                }
            }
            return hash;
        }

        public boolean equals(Object itemObject) {
            if (!(itemObject instanceof Item)) {
                return false;
            }
            Item item = (Item)itemObject;
            if (this.getType() != item.getType()) {
                return false;
            }
            if (this.isBroken() != item.isBroken()) {
                return false;
            }
            if (this.isBroken()) {
                return this.getReference().equals(item.getReference());
            }
            switch (this.getType()) {
                case 2: {
                    if (this.getArtifact().getType() != item.getArtifact().getType()) {
                        return false;
                    }
                    if (!this.getArtifact().getScriptLocation().equals(item.getArtifact().getScriptLocation())) {
                        return false;
                    }
                    return this.getArtifactURI().equals(item.getArtifactURI());
                }
                case 3: {
                    return this.property.equals(item.property);
                }
            }
            return this.object.equals(item.object);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$j2seproject$classpath$ClassPathSupport == null ? (class$org$netbeans$modules$java$j2seproject$classpath$ClassPathSupport = ClassPathSupport.class$("org.netbeans.modules.java.j2seproject.classpath.ClassPathSupport")) : class$org$netbeans$modules$java$j2seproject$classpath$ClassPathSupport).desiredAssertionStatus();
        }
    }
}

