/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.blueprints.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.openide.awt.HtmlBrowser;

public class HtmlBrowserWithScrollPosition
extends JPanel
implements HyperlinkListener {
    private HtmlBrowser.URLDisplayer displayer = HtmlBrowser.URLDisplayer.getDefault();
    private Timer scrollTimer = null;
    private JLabel statusBar;
    protected JEditorPane html;

    public HtmlBrowserWithScrollPosition() {
        this.setLayout(new BorderLayout());
        this.html = new JEditorPane();
        this.html.setEditorKitForContentType("text/html", new HTMLEditorKit());
        this.html.setEditable(false);
        this.html.addHyperlinkListener(this);
        this.add((Component)new JScrollPane(this.html), "Center");
        this.statusBar = new JLabel(" ");
        this.statusBar.setBackground(new Color(80, 80, 80));
        this.add((Component)this.statusBar, "South");
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        HyperlinkEvent.EventType type = e.getEventType();
        if (type == HyperlinkEvent.EventType.ACTIVATED) {
            this.setURL(e.getURL());
        } else if (type == HyperlinkEvent.EventType.ENTERED) {
            this.statusBar.setText(e.getURL().toString());
        } else if (type == HyperlinkEvent.EventType.EXITED) {
            this.statusBar.setText(" ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setURL(URL u) {
        if (u != null) {
            String protocol = u.getProtocol();
            if (protocol != null && (protocol.equals("http") || protocol.equals("https"))) {
                this.displayer.showURL(u);
            } else {
                Cursor currentC = this.html.getCursor();
                Cursor busyC = Cursor.getPredefinedCursor(3);
                this.html.setCursor(busyC);
                try {
                    this.html.setPage(u);
                }
                catch (IOException e) {
                    this.statusBar.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/Bundle").getString("doc_not_found"));
                }
                finally {
                    this.html.setCursor(currentC);
                }
            }
        }
    }

    public int getScrollPosition() {
        int result = 0;
        Component c = this.getComponent(0);
        if (c instanceof JScrollPane) {
            JScrollPane pane = (JScrollPane)c;
            result = pane.getVerticalScrollBar().getValue();
        }
        return result;
    }

    public void setScrollPosition(final int position) {
        if (this.scrollTimer != null) {
            this.scrollTimer.stop();
        }
        this.scrollTimer = new Timer(100, new ActionListener(){
            int timeout = 50;

            public void actionPerformed(ActionEvent e) {
                boolean done = true;
                Component c = HtmlBrowserWithScrollPosition.this.getComponent(0);
                if (c instanceof JScrollPane) {
                    JScrollPane pane = (JScrollPane)c;
                    JScrollBar bar = pane.getVerticalScrollBar();
                    if (position <= bar.getMaximum()) {
                        bar.setValue(position);
                    } else {
                        done = false;
                    }
                }
                --this.timeout;
                if (this.timeout <= 0) {
                    done = true;
                }
                if (done) {
                    HtmlBrowserWithScrollPosition.this.scrollTimer.stop();
                    HtmlBrowserWithScrollPosition.this.scrollTimer = null;
                }
            }
        });
        this.scrollTimer.start();
    }
}

