/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.blueprints.ui.projects;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.modules.j2ee.blueprints.catalog.SolutionsCatalog;
import org.netbeans.modules.j2ee.blueprints.catalog.bpcatalogxmlparser.Nbcatalog;
import org.netbeans.modules.j2ee.blueprints.catalog.bpcatalogxmlparser.Nbcategory;
import org.netbeans.modules.j2ee.blueprints.catalog.bpcatalogxmlparser.Nbsolution;
import org.netbeans.modules.j2ee.blueprints.catalog.bpcatalogxmlparser.Nbwriteup;
import org.netbeans.modules.j2ee.blueprints.ui.BpcatalogLocalizedResource;
import org.netbeans.modules.j2ee.blueprints.ui.overview.OverviewPageTopComponent;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.modules.InstalledFileLocator;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class J2eeSampleProjectGenerator {
    public static final String PROJECT_CONFIGURATION_NAMESPACE = "http://www.netbeans.org/ns/web-project/3";
    public static final String PROJECT_CONFIGURATION_NS_FREE = "http://www.netbeans.org/ns/freeform-project/1";
    public static final String EJBJAR_NAMESPACE = "http://www.netbeans.org/ns/j2ee-ejbjarproject/3";
    public static final String PROJECT_CONFIGURATION_J2SE = "http://www.netbeans.org/ns/j2se-project/2";
    public static final String SUNWEBDD_XMLLOC = "web/WEB-INF/sun-web.xml";

    private J2eeSampleProjectGenerator() {
    }

    public static FileObject createProjectFromTemplate(FileObject template, File projectLocation, String name) throws IOException {
        FileObject prjLoc = null;
        String slashname = "/" + name;
        if (template.getExt().endsWith("zip")) {
            FileObject p;
            J2eeSampleProjectGenerator.unzip(template.getInputStream(), projectLocation);
            String extra = (String)template.getAttribute("extrazip");
            if (extra != null && (p = template.getParent().getFileObject(extra + ".zip")) != null) {
                J2eeSampleProjectGenerator.unzip(p.getInputStream(), new File(projectLocation.getParentFile(), extra));
            }
            try {
                File sunwebXml;
                Document swdoc;
                NodeList swnlist;
                FileObject sunwebfile;
                prjLoc = FileUtil.toFileObject((File)projectLocation);
                NodeList nlist = null;
                File projXml = FileUtil.toFile((FileObject)prjLoc.getFileObject("nbproject/project.xml"));
                Document doc = XMLUtil.parse((InputSource)new InputSource(projXml.toURI().toString()), (boolean)false, (boolean)true, null, null);
                nlist = doc.getElementsByTagNameNS(PROJECT_CONFIGURATION_NAMESPACE, "name");
                if (nlist == null || nlist.getLength() == 0) {
                    nlist = doc.getElementsByTagNameNS(EJBJAR_NAMESPACE, "name");
                }
                if (nlist == null || nlist.getLength() == 0) {
                    nlist = doc.getElementsByTagNameNS(PROJECT_CONFIGURATION_J2SE, "name");
                }
                if (nlist != null) {
                    for (int i = 0; i < nlist.getLength(); ++i) {
                        Node n = nlist.item(i);
                        if (n.getNodeType() != 1) continue;
                        Element e = (Element)n;
                        J2eeSampleProjectGenerator.replaceText(e, name);
                        J2eeSampleProjectGenerator.saveXml(doc, prjLoc, "nbproject/project.xml");
                    }
                }
                if ((sunwebfile = prjLoc.getFileObject(SUNWEBDD_XMLLOC)) != null && (swnlist = (swdoc = XMLUtil.parse((InputSource)new InputSource((sunwebXml = FileUtil.toFile((FileObject)sunwebfile)).toURI().toString()), (boolean)false, (boolean)true, null, (EntityResolver)SunWebDDResolver.getInstance())).getElementsByTagName("context-root")) != null) {
                    for (int i = 0; i < swnlist.getLength(); ++i) {
                        Node n = swnlist.item(i);
                        if (n.getNodeType() != 1) continue;
                        Element e = (Element)n;
                        J2eeSampleProjectGenerator.replaceText(e, slashname);
                        J2eeSampleProjectGenerator.saveXml(swdoc, prjLoc, SUNWEBDD_XMLLOC);
                    }
                }
                J2eeSampleProjectGenerator.replaceProperties(prjLoc, name);
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
            prjLoc.refresh(false);
        }
        return prjLoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void replaceProperties(FileObject dir, String prjName) throws IOException {
        String DIST_JAR = "dist.jar";
        String DIST_DIR = "${dist.dir}/";
        String DIST_EAR_JAR = "dist.ear.jar";
        String WAR_NAME = "war.name";
        String WAR_EAR_NAME = "war.ear.name";
        String BP_LIB_DIR = "bp-lib.dir";
        String BP_UI5_JAR = "file.reference.bp-ui-5.jar";
        EditableProperties props = new EditableProperties(true);
        FileObject prjProp = FileUtil.createData((FileObject)dir, (String)"nbproject/project.properties");
        try {
            InputStream in = prjProp.getInputStream();
            props.load(in);
            in.close();
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
        String distJar = props.getProperty("dist.jar");
        if (distJar != null) {
            props.setProperty("dist.jar", "${dist.dir}/" + prjName + distJar.substring(distJar.lastIndexOf(46)));
            String currentProp = props.getProperty("dist.ear.jar");
            if (currentProp != null) {
                props.setProperty("dist.ear.jar", "${dist.dir}/" + prjName + currentProp.substring(currentProp.indexOf(".")));
            }
        } else if (props.getProperty("war.name") != null) {
            props.setProperty("war.name", prjName + ".war");
            String currentProp = props.getProperty("war.ear.name");
            if (currentProp != null) {
                props.setProperty("war.ear.name", prjName + currentProp.substring(currentProp.indexOf(".")));
            }
        }
        String bpLibsLocation = J2eeSampleProjectGenerator.getBlueprintsLibsLocation();
        props.setProperty(BP_LIB_DIR, bpLibsLocation);
        if (props.getProperty(BP_UI5_JAR) != null) {
            props.setProperty(BP_UI5_JAR, bpLibsLocation + File.separator + "bp-ui-5.jar");
        }
        FileLock lock = prjProp.lock();
        try {
            OutputStream os = prjProp.getOutputStream(lock);
            try {
                props.store(os);
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(InputStream source, File targetFolder) throws IOException {
        ZipInputStream zip = new ZipInputStream(source);
        try {
            ZipEntry ent;
            while ((ent = zip.getNextEntry()) != null) {
                File f = new File(targetFolder, ent.getName());
                if (ent.isDirectory()) {
                    f.mkdirs();
                    continue;
                }
                f.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(f);
                try {
                    FileUtil.copy((InputStream)zip, (OutputStream)out);
                }
                finally {
                    out.close();
                }
            }
        }
        finally {
            zip.close();
        }
    }

    private static void replaceText(Element parent, String name) {
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (l.item(i).getNodeType() != 3) continue;
            Text text = (Text)l.item(i);
            text.setNodeValue(name);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveXml(Document doc, FileObject dir, String path) throws IOException {
        FileObject xml = FileUtil.createData((FileObject)dir, (String)path);
        FileLock lock = xml.lock();
        try {
            OutputStream os = xml.getOutputStream(lock);
            try {
                XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    private static String getBlueprintsLibsLocation() {
        String location = "";
        File f = InstalledFileLocator.getDefault().locate("modules/ext/blueprints/bp-ui-14.jar", null, true);
        if (f != null) {
            location = f.getParentFile().getAbsolutePath();
        }
        return location;
    }

    public static void getOverviewPage(TemplateWizard templateWizard) {
        TopComponent tc = WindowManager.getDefault().findTopComponent("BluePrints");
        if (tc.isOpened()) {
            return;
        }
        FileObject template = templateWizard.getTemplate().getPrimaryFile();
        String currentModName = template.getName();
        SolutionsCatalog solutionsCatalog = SolutionsCatalog.getInstance();
        Nbcatalog nbcatalog = solutionsCatalog.getCatalogXml();
        HashMap overviewFiles = J2eeSampleProjectGenerator.populateEntries(nbcatalog);
        String pagePath = (String)overviewFiles.get(currentModName);
        String overviewPage = J2eeSampleProjectGenerator.getLocalizedPath(pagePath);
        OverviewPageTopComponent win = OverviewPageTopComponent.findInstance();
        OverviewPageTopComponent comp = win;
        if (comp.isOpened()) {
            comp.close();
        }
        comp.setOverviewFile(overviewPage);
        comp.open();
        comp.requestActive();
    }

    private static HashMap populateEntries(Nbcatalog nbcatalog) {
        HashMap<String, String> overviewFiles = new HashMap<String, String>();
        List cats = nbcatalog.fetchNbcategoryList();
        for (int catNum = 0; catNum < cats.size(); ++catNum) {
            Nbcategory category = (Nbcategory)cats.get(catNum);
            List sols = category.fetchNbsolutionList();
            for (int solNum = 0; solNum < sols.size(); ++solNum) {
                Nbsolution sol = (Nbsolution)sols.get(solNum);
                Nbwriteup write = sol.getNbwriteup();
                String categoryID = category.getId();
                String articlePath = write.getArticlePath();
                if (categoryID.equals("Ajax")) {
                    articlePath = "docs/ajax/overview-Ajax.html";
                } else if (categoryID.equals("JavaPersistence")) {
                    articlePath = "docs/persistence/overview-JavaPersistence.html";
                }
                overviewFiles.put(sol.getExampleId(), articlePath);
            }
        }
        return overviewFiles;
    }

    private static String getLocalizedPath(String articlePath) {
        String CATALOG_RESOURCES_URL = "/org/netbeans/modules/j2ee/blueprints/catalog/resources";
        String path = CATALOG_RESOURCES_URL + "/" + articlePath;
        BpcatalogLocalizedResource htmlrsc = new BpcatalogLocalizedResource(path, "html");
        String localizedPath = htmlrsc.getResourcePath();
        return localizedPath;
    }

    private static class SunWebDDResolver
    implements EntityResolver {
        static SunWebDDResolver resolver;

        private SunWebDDResolver() {
        }

        static synchronized SunWebDDResolver getInstance() {
            if (resolver == null) {
                resolver = new SunWebDDResolver();
            }
            return resolver;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            String resource = null;
            resource = "/org/netbeans/modules/j2ee/blueprints/ui/resources/sun-web-app_2_4-1.dtd";
            URL url = this.getClass().getResource(resource);
            return new InputSource(url.toString());
        }
    }
}

