/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui;

import java.awt.Dialog;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.UpdateHelper;
import org.netbeans.modules.web.project.classpath.WebProjectClassPathExtender;
import org.netbeans.modules.web.project.ui.ActionFilterNode;
import org.netbeans.modules.web.project.ui.FoldersListSettings;
import org.netbeans.modules.web.project.ui.J2eePlatformNode;
import org.netbeans.modules.web.project.ui.LibrariesSourceGroup;
import org.netbeans.modules.web.project.ui.PlatformNode;
import org.netbeans.modules.web.project.ui.ProjectNode;
import org.netbeans.modules.web.project.ui.customizer.AntArtifactChooser;
import org.netbeans.modules.web.project.ui.customizer.LibrariesChooser;
import org.netbeans.modules.web.project.ui.customizer.WebClassPathUi;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

final class LibrariesNode
extends AbstractNode {
    private static final Image ICON_BADGE = Utilities.loadImage((String)"org/netbeans/modules/web/project/ui/resources/libraries-badge.png");
    static final RequestProcessor rp = new RequestProcessor();
    private static Icon folderIconCache;
    private static Icon openedFolderIconCache;
    private final String displayName;
    private final Action[] librariesNodeActions;

    LibrariesNode(String displayName, Project project, PropertyEvaluator eval, UpdateHelper helper, ReferenceHelper refHelper, String classPathProperty, String[] classPathIgnoreRef, String platformProperty, String j2eePlatformProperty, Action[] librariesNodeActions, String webModuleElementName) {
        super((Children)new LibrariesChildren(eval, helper, refHelper, classPathProperty, classPathIgnoreRef, platformProperty, j2eePlatformProperty, webModuleElementName), Lookups.singleton((Object)project));
        this.displayName = displayName;
        this.librariesNodeActions = librariesNodeActions;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.getDisplayName();
    }

    public Image getIcon(int type) {
        return this.computeIcon(false, type);
    }

    public Image getOpenedIcon(int type) {
        return this.computeIcon(true, type);
    }

    public Action[] getActions(boolean context) {
        return this.librariesNodeActions;
    }

    public boolean canCopy() {
        return false;
    }

    public static Action createAddProjectAction(Project p, String classPathId, String webModuleElementName) {
        return new AddProjectAction(p, classPathId, webModuleElementName);
    }

    public static Action createAddLibraryAction(Project p, AntProjectHelper helper, String classPathId, String webModuleElementName) {
        return new AddLibraryAction(p, helper, classPathId, webModuleElementName);
    }

    public static Action createAddFolderAction(Project p, String classPathId, String webModuleElementName) {
        return new AddFolderAction(p, classPathId, webModuleElementName);
    }

    static synchronized Icon getFolderIcon(boolean opened) {
        if (openedFolderIconCache == null) {
            Node n = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
            openedFolderIconCache = new ImageIcon(n.getOpenedIcon(1));
            folderIconCache = new ImageIcon(n.getIcon(1));
        }
        if (opened) {
            return openedFolderIconCache;
        }
        return folderIconCache;
    }

    private Image computeIcon(boolean opened, int type) {
        Icon icon = LibrariesNode.getFolderIcon(opened);
        Image image = ((ImageIcon)icon).getImage();
        image = Utilities.mergeImages((Image)image, (Image)ICON_BADGE, (int)7, (int)7);
        return image;
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String description, String[] extensions) {
            this.description = description;
            this.extensions = Arrays.asList(extensions);
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            try {
                return FileUtil.isArchiveFile((URL)f.toURI().toURL());
            }
            catch (MalformedURLException mue) {
                ErrorManager.getDefault().notify((Throwable)mue);
                return false;
            }
        }

        public String getDescription() {
            return this.description;
        }
    }

    private static class AddFolderAction
    extends AbstractAction {
        private final Project project;
        private final String classPathId;
        private final String webModuleElementName;

        public AddFolderAction(Project project, String classPathId, String webModuleElementName) {
            super(NbBundle.getMessage(LibrariesNode.class, (String)"LBL_AddFolder_Action"));
            this.project = project;
            this.classPathId = classPathId;
            this.webModuleElementName = webModuleElementName;
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
            chooser.setFileSelectionMode(2);
            chooser.setMultiSelectionEnabled(true);
            chooser.setDialogTitle(NbBundle.getMessage(LibrariesNode.class, (String)"LBL_AddJar_DialogTitle"));
            chooser.setAcceptAllFileFilterUsed(false);
            SimpleFileFilter fileFilter = new SimpleFileFilter(NbBundle.getMessage(WebClassPathUi.class, (String)"LBL_ZipJarFolderFilter"), new String[]{"ZIP", "JAR"});
            chooser.setFileFilter(fileFilter);
            File curDir = FoldersListSettings.getDefault().getLastUsedClassPathFolder();
            chooser.setCurrentDirectory(curDir);
            int option = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
            if (option == 0) {
                File[] files = chooser.getSelectedFiles();
                this.addJarFiles(files, fileFilter);
                curDir = FileUtil.normalizeFile((File)chooser.getCurrentDirectory());
                FoldersListSettings.getDefault().setLastUsedClassPathFolder(curDir);
            }
        }

        private void addJarFiles(File[] files, FileFilter fileFilter) {
            WebProjectClassPathExtender cpExtender = (WebProjectClassPathExtender)this.project.getLookup().lookup(WebProjectClassPathExtender.class);
            if (cpExtender != null) {
                LinkedList<FileObject> fileObjects = new LinkedList<FileObject>();
                for (int i = 0; i < files.length; ++i) {
                    if (!fileFilter.accept(files[i])) continue;
                    FileObject fo = FileUtil.toFileObject((File)files[i]);
                    assert (fo != null) : files[i];
                    fileObjects.add(fo);
                }
                try {
                    FileObject[] fileObjectArray = new FileObject[fileObjects.size()];
                    fileObjects.toArray(fileObjectArray);
                    cpExtender.addArchiveFiles(this.classPathId, fileObjectArray, this.webModuleElementName);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            } else {
                ErrorManager.getDefault().log("WebProjectClassPathExtender not found in the project lookup of project: " + this.project.getProjectDirectory().getPath());
            }
        }
    }

    private static class AddLibraryAction
    extends AbstractAction {
        private final Project project;
        private final AntProjectHelper helper;
        private final String classPathId;
        private final String webModuleElementName;

        public AddLibraryAction(Project project, AntProjectHelper helper, String classPathId, String webModuleElementName) {
            super(NbBundle.getMessage(LibrariesNode.class, (String)"LBL_AddLibrary_Action"));
            this.project = project;
            this.helper = helper;
            this.classPathId = classPathId;
            this.webModuleElementName = webModuleElementName;
        }

        public void actionPerformed(ActionEvent e) {
            Object[] options = new Object[]{new JButton(NbBundle.getMessage(LibrariesNode.class, (String)"LBL_AddLibrary")), DialogDescriptor.CANCEL_OPTION};
            ((JButton)options[0]).setEnabled(false);
            ((JButton)options[0]).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebClassPathUi.class, (String)"AD_AddLibrary"));
            WebModule wm = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
            String j2eeVersion = wm.getJ2eePlatformVersion();
            LibrariesChooser panel = new LibrariesChooser((JButton)options[0], j2eeVersion);
            DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(LibrariesNode.class, (String)"LBL_CustomizeCompile_Classpath_AddLibrary"), true, options, options[0], 0, null, null);
            Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
            dlg.setVisible(true);
            if (desc.getValue() == options[0]) {
                this.addLibraries(panel.getSelectedLibraries());
            }
            dlg.dispose();
        }

        private void addLibraries(Library[] libraries) {
            WebProjectClassPathExtender cpExtender = (WebProjectClassPathExtender)this.project.getLookup().lookup(WebProjectClassPathExtender.class);
            if (cpExtender != null) {
                try {
                    cpExtender.addLibraries(this.classPathId, libraries, this.webModuleElementName);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            } else {
                ErrorManager.getDefault().log("WebProjectClassPathExtender not found in the project lookup of project: " + this.project.getProjectDirectory().getPath());
            }
        }

        private String getProjectJ2eeVersion() {
            String version = null;
            version = this.helper.getProperties("nbproject/project.properties").getProperty("j2ee.platform");
            if (version == null || version.equals("")) {
                version = "1.3";
            }
            return version;
        }
    }

    private static class AddProjectAction
    extends AbstractAction {
        private final Project project;
        private final String classPathId;
        private final String webModuleElementName;

        public AddProjectAction(Project project, String classPathId, String webModuleElementName) {
            super(NbBundle.getMessage(LibrariesNode.class, (String)"LBL_AddProject_Action"));
            this.project = project;
            this.classPathId = classPathId;
            this.webModuleElementName = webModuleElementName;
        }

        public void actionPerformed(ActionEvent e) {
            AntArtifactChooser.ArtifactItem[] artifacts = AntArtifactChooser.showDialog("jar", this.project, null);
            if (artifacts != null) {
                this.addArtifacts(artifacts);
            }
        }

        private void addArtifacts(AntArtifactChooser.ArtifactItem[] artifactItems) {
            WebProjectClassPathExtender cpExtender = (WebProjectClassPathExtender)this.project.getLookup().lookup(WebProjectClassPathExtender.class);
            if (cpExtender != null) {
                try {
                    cpExtender.addAntArtifacts(this.classPathId, artifactItems, this.webModuleElementName);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            } else {
                ErrorManager.getDefault().log("WebProjectClassPathExtender not found in the project lookup of project: " + this.project.getProjectDirectory().getPath());
            }
        }
    }

    private static class Key {
        static final int TYPE_PLATFORM = 0;
        static final int TYPE_LIBRARY = 1;
        static final int TYPE_PROJECT = 2;
        static final int TYPE_J2EE_PLATFORM = 3;
        private int type;
        private String classPathId;
        private String entryId;
        private SourceGroup sg;
        private AntArtifact antArtifact;
        private URI uri;

        Key() {
            this(false);
        }

        Key(boolean j2ee) {
            this.type = j2ee ? 3 : 0;
        }

        Key(SourceGroup sg, String classPathId, String entryId) {
            this.type = 1;
            this.sg = sg;
            this.classPathId = classPathId;
            this.entryId = entryId;
        }

        Key(AntArtifact a, URI uri, String classPathId, String entryId) {
            this.type = 2;
            this.antArtifact = a;
            this.uri = uri;
            this.classPathId = classPathId;
            this.entryId = entryId;
        }

        public int getType() {
            return this.type;
        }

        public String getClassPathId() {
            return this.classPathId;
        }

        public String getEntryId() {
            return this.entryId;
        }

        public SourceGroup getSourceGroup() {
            return this.sg;
        }

        public AntArtifact getProject() {
            return this.antArtifact;
        }

        public URI getArtifactLocation() {
            return this.uri;
        }

        public int hashCode() {
            int hashCode = this.type << 16;
            switch (this.type) {
                case 1: {
                    hashCode ^= this.sg == null ? 0 : this.sg.hashCode();
                    break;
                }
                case 2: {
                    hashCode ^= this.antArtifact == null ? 0 : this.antArtifact.hashCode();
                }
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (other.type != this.type) {
                return false;
            }
            switch (this.type) {
                case 1: {
                    return (this.sg == null ? other.sg == null : this.sg.equals(other.sg)) && (this.classPathId == null ? other.classPathId == null : this.classPathId.equals(other.classPathId)) && (this.entryId == null ? other.entryId == null : this.entryId.equals(other.entryId));
                }
                case 2: {
                    return (this.antArtifact == null ? other.antArtifact == null : this.antArtifact.equals(other.antArtifact)) && (this.classPathId == null ? other.classPathId == null : this.classPathId.equals(other.classPathId)) && (this.entryId == null ? other.entryId == null : this.entryId.equals(other.entryId));
                }
                case 0: 
                case 3: {
                    return true;
                }
            }
            throw new IllegalStateException();
        }
    }

    private static class LibrariesChildren
    extends Children.Keys
    implements PropertyChangeListener {
        private static final String LIBRARY_PREFIX = "${libs.";
        private static final String ANT_ARTIFACT_PREFIX = "${reference.";
        private static final String FILE_REF_PREFIX = "${file.reference.";
        private static final String REF_PREFIX = "${";
        private static final String LIBRARIES_ICON = "org/netbeans/modules/web/project/ui/resources/libraries.gif";
        private static final String ARCHIVE_ICON = "org/netbeans/modules/web/project/ui/resources/jar.gif";
        private final PropertyEvaluator eval;
        private final UpdateHelper helper;
        private final ReferenceHelper refHelper;
        private final String classPathProperty;
        private final String platformProperty;
        private final String j2eePlatformProperty;
        private final Set classPathIgnoreRef;
        private final String webModuleElementName;
        private ClassPath fsListener;

        LibrariesChildren(PropertyEvaluator eval, UpdateHelper helper, ReferenceHelper refHelper, String classPathProperty, String[] classPathIgnoreRef, String platformProperty, String j2eePlatformProperty, String webModuleElementName) {
            this.eval = eval;
            this.helper = helper;
            this.refHelper = refHelper;
            this.classPathProperty = classPathProperty;
            this.classPathIgnoreRef = new HashSet<String>(Arrays.asList(classPathIgnoreRef));
            this.platformProperty = platformProperty;
            this.j2eePlatformProperty = j2eePlatformProperty;
            this.webModuleElementName = webModuleElementName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (this.classPathProperty.equals(propName) || "roots".equals(propName)) {
                LibrariesChildren librariesChildren = this;
                synchronized (librariesChildren) {
                    if (this.fsListener != null) {
                        this.fsListener.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                }
                rp.post(new Runnable(){

                    public void run() {
                        LibrariesChildren.this.setKeys(LibrariesChildren.this.getKeys());
                    }
                });
            }
        }

        protected void addNotify() {
            this.eval.addPropertyChangeListener((PropertyChangeListener)this);
            this.setKeys(this.getKeys());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeNotify() {
            this.eval.removePropertyChangeListener((PropertyChangeListener)this);
            LibrariesChildren librariesChildren = this;
            synchronized (librariesChildren) {
                if (this.fsListener != null) {
                    this.fsListener.removePropertyChangeListener((PropertyChangeListener)this);
                    this.fsListener = null;
                }
            }
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object obj) {
            Node[] result = null;
            if (obj instanceof Key) {
                Key key = (Key)obj;
                switch (key.getType()) {
                    case 0: {
                        result = new Node[]{PlatformNode.create(this.eval, this.platformProperty)};
                        break;
                    }
                    case 3: {
                        Project p = FileOwnerQuery.getOwner((FileObject)this.helper.getAntProjectHelper().getProjectDirectory());
                        result = new Node[]{J2eePlatformNode.create(p, this.eval, this.j2eePlatformProperty)};
                        break;
                    }
                    case 2: {
                        result = new Node[]{new ProjectNode(key.getProject(), key.getArtifactLocation(), this.helper, this.eval, this.refHelper, key.getClassPathId(), key.getEntryId(), this.webModuleElementName)};
                        break;
                    }
                    case 1: {
                        result = new Node[]{ActionFilterNode.create(PackageView.createPackageView((SourceGroup)key.getSourceGroup()), this.helper, this.eval, this.refHelper, key.getClassPathId(), key.getEntryId(), this.webModuleElementName)};
                    }
                }
            }
            if (result == null) {
                assert (false) : "Unknown key type";
                result = new Node[]{};
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List getKeys() {
            EditableProperties projectSharedProps = this.helper.getProperties("nbproject/project.properties");
            EditableProperties projectPrivateProps = this.helper.getProperties("nbproject/private/private.properties");
            EditableProperties privateProps = PropertyUtils.getGlobalProperties();
            ArrayList rootsList = new ArrayList();
            List result = this.getKeys(projectSharedProps, projectPrivateProps, privateProps, this.classPathProperty, rootsList);
            if (this.platformProperty != null) {
                result.add(new Key());
            }
            if (this.j2eePlatformProperty != null) {
                result.add(new Key(true));
            }
            ClassPath cp = ClassPathSupport.createClassPath((URL[])rootsList.toArray(new URL[rootsList.size()]));
            cp.addPropertyChangeListener((PropertyChangeListener)this);
            cp.getRoots();
            LibrariesChildren librariesChildren = this;
            synchronized (librariesChildren) {
                this.fsListener = cp;
            }
            return result;
        }

        private List getKeys(EditableProperties projectSharedProps, EditableProperties projectPrivateProps, EditableProperties privateProps, String currentClassPath, List rootsList) {
            ArrayList<Key> result = new ArrayList<Key>();
            String raw = projectSharedProps.getProperty(currentClassPath);
            if (raw == null) {
                raw = projectPrivateProps.getProperty(currentClassPath);
            }
            if (raw == null) {
                raw = privateProps.getProperty(currentClassPath);
            }
            if (raw == null) {
                return result;
            }
            ArrayList<String> pe = new ArrayList<String>(Arrays.asList(PropertyUtils.tokenizePath((String)raw)));
            while (pe.size() > 0) {
                String prop = (String)pe.remove(0);
                String propName = WebProjectProperties.getAntPropertyName(prop);
                if (this.classPathIgnoreRef.contains(propName)) continue;
                if (prop.startsWith(LIBRARY_PREFIX)) {
                    String eval = prop.substring(LIBRARY_PREFIX.length(), prop.lastIndexOf(46));
                    Library lib = LibraryManager.getDefault().getLibrary(eval);
                    if (lib == null) continue;
                    List roots = lib.getContent("classpath");
                    ImageIcon libIcon = new ImageIcon(Utilities.loadImage((String)LIBRARIES_ICON));
                    for (URL rootUrl : roots) {
                        String displayName;
                        Object file;
                        rootsList.add(rootUrl);
                        FileObject root = URLMapper.findFileObject((URL)rootUrl);
                        if (root == null) continue;
                        if ("jar".equals(rootUrl.getProtocol())) {
                            file = FileUtil.getArchiveFile((FileObject)root);
                            displayName = file.getNameExt();
                        } else {
                            file = FileUtil.toFile((FileObject)root);
                            displayName = file != null ? ((File)file).getAbsolutePath() : root.getNameExt();
                        }
                        displayName = MessageFormat.format(NbBundle.getMessage(LibrariesNode.class, (String)"TXT_LibraryPartFormat"), lib.getDisplayName(), displayName);
                        LibrariesSourceGroup sg = new LibrariesSourceGroup(root, displayName, libIcon, libIcon);
                        result.add(new Key(sg, currentClassPath, propName));
                    }
                    continue;
                }
                if (prop.startsWith(ANT_ARTIFACT_PREFIX)) {
                    Object[] ref = this.refHelper.findArtifactAndLocation(prop);
                    if (ref[0] == null || ref[1] == null) continue;
                    AntArtifact artifact = (AntArtifact)ref[0];
                    URI uri = (URI)ref[1];
                    result.add(new Key(artifact, uri, currentClassPath, propName));
                    continue;
                }
                if (prop.startsWith(FILE_REF_PREFIX)) {
                    String evaluatedRef = this.eval.getProperty(propName);
                    File file = this.helper.getAntProjectHelper().resolveFile(evaluatedRef);
                    SourceGroup sg = LibrariesChildren.createFileSourceGroup(file, rootsList);
                    if (sg == null) continue;
                    result.add(new Key(sg, currentClassPath, propName));
                    continue;
                }
                if (prop.startsWith(REF_PREFIX)) {
                    result.addAll(this.getKeys(projectSharedProps, projectPrivateProps, privateProps, propName, rootsList));
                    continue;
                }
                File file = this.helper.getAntProjectHelper().resolveFile(prop);
                SourceGroup sg = LibrariesChildren.createFileSourceGroup(file, rootsList);
                if (sg == null) continue;
                result.add(new Key(sg, currentClassPath, propName));
            }
            return result;
        }

        private static SourceGroup createFileSourceGroup(File file, List rootsList) {
            try {
                String displayName;
                Icon icon;
                Icon openedIcon;
                URL url = file.toURI().toURL();
                if (FileUtil.isArchiveFile((URL)url)) {
                    url = FileUtil.getArchiveRoot((URL)url);
                    openedIcon = new ImageIcon(Utilities.loadImage((String)ARCHIVE_ICON));
                    icon = openedIcon;
                    displayName = file.getName();
                } else {
                    String sURL = url.toExternalForm();
                    if (!sURL.endsWith("/")) {
                        url = new URL(sURL + "/");
                    }
                    icon = LibrariesNode.getFolderIcon(false);
                    openedIcon = LibrariesNode.getFolderIcon(true);
                    displayName = file.getAbsolutePath();
                }
                rootsList.add(url);
                FileObject root = URLMapper.findFileObject((URL)url);
                if (root != null) {
                    return new LibrariesSourceGroup(root, displayName, icon, openedIcon);
                }
            }
            catch (MalformedURLException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            return null;
        }
    }
}

