/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.api.ejbjar.Ear;
import org.netbeans.modules.web.api.webmodule.WebFrameworkSupport;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.api.WebProjectCreateData;
import org.netbeans.modules.web.project.api.WebProjectUtilities;
import org.netbeans.modules.web.project.ui.FoldersListSettings;
import org.netbeans.modules.web.project.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.web.project.ui.wizards.PanelSupportedFrameworks;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class NewWebProjectWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private static final long serialVersionUID = 1L;
    static final String PROP_NAME_INDEX = "nameIndex";
    private transient int index;
    private transient int panelsCount;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;

    private String[] createSteps() {
        String[] steps = WebFrameworkSupport.getFrameworkProviders().size() > 0 ? new String[]{NbBundle.getMessage(NewWebProjectWizardIterator.class, (String)"LBL_NWP1_ProjectTitleName"), NbBundle.getMessage(NewWebProjectWizardIterator.class, (String)"LBL_NWP2_Frameworks")} : new String[]{NbBundle.getMessage(NewWebProjectWizardIterator.class, (String)"LBL_NWP1_ProjectTitleName")};
        return steps;
    }

    public Set instantiate() throws IOException {
        Ear ear;
        HashSet<FileObject> resultSet = new HashSet<FileObject>();
        File dirF = (File)this.wiz.getProperty("projdir");
        String servInstID = (String)this.wiz.getProperty("serverInstanceID");
        WebProjectCreateData createData = new WebProjectCreateData();
        createData.setProjectDir(dirF);
        createData.setName((String)this.wiz.getProperty("name"));
        createData.setServerInstanceID(servInstID);
        createData.setSourceStructure((String)this.wiz.getProperty("sourceStructure"));
        createData.setJavaEEVersion((String)this.wiz.getProperty("j2eeLevel"));
        createData.setContextPath((String)this.wiz.getProperty("contextPath"));
        createData.setJavaPlatformName((String)this.wiz.getProperty("setJavaPlatform"));
        createData.setSourceLevel((String)this.wiz.getProperty("setSourceLevel"));
        AntProjectHelper h = WebProjectUtilities.createProject(createData);
        try {
            FileObject webRoot = h.getProjectDirectory().getFileObject("web");
            FileObject indexJSPFo = this.getIndexJSPFO(webRoot, "index");
            assert (indexJSPFo != null) : "webRoot: " + webRoot + ", defaultJSP: index";
            resultSet.add(indexJSPFo);
        }
        catch (Exception x) {
            // empty catch block
        }
        FileObject dir = FileUtil.toFileObject((File)dirF);
        Project p = ProjectManager.getDefault().findProject(dir);
        Integer index = (Integer)this.wiz.getProperty(PROP_NAME_INDEX);
        if (index != null) {
            FoldersListSettings.getDefault().setNewProjectCount(index);
        }
        this.wiz.putProperty("name", null);
        Project earProject = (Project)this.wiz.getProperty("earApplication");
        WebProject createdWebProject = (WebProject)ProjectManager.getDefault().findProject(dir);
        if (earProject != null && createdWebProject != null && (ear = Ear.getEar((FileObject)earProject.getProjectDirectory())) != null) {
            ear.addWebModule(createdWebProject.getAPIWebModule());
        }
        FoldersListSettings.getDefault().setLastUsedServer(servInstID);
        File file = dirF = dirF != null ? dirF.getParentFile() : null;
        if (dirF != null && dirF.exists()) {
            ProjectChooser.setProjectsFolder((File)dirF);
        }
        resultSet.add(dir);
        List selectedFrameworks = (List)this.wiz.getProperty("frameworks");
        if (selectedFrameworks != null) {
            for (int i = 0; i < selectedFrameworks.size(); ++i) {
                Set o = ((WebFrameworkProvider)selectedFrameworks.get(i)).extend(createdWebProject.getAPIWebModule());
                if (o == null || !(o instanceof Set)) continue;
                resultSet.addAll(o);
            }
        }
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = WebFrameworkSupport.getFrameworkProviders().size() > 0 ? new WizardDescriptor.Panel[]{new PanelConfigureProject(), new PanelSupportedFrameworks()} : new WizardDescriptor.Panel[]{new PanelConfigureProject()};
        this.panelsCount = this.panels.length;
        String[] steps = this.createSteps();
        for (int i = 0; i < steps.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        if (this.wiz != null) {
            this.wiz.putProperty("projdir", null);
            this.wiz.putProperty("name", null);
            this.wiz = null;
        }
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(NewWebProjectWizardIterator.class, (String)"LBL_WizardStepsCount"), new Integer(this.index + 1).toString(), new Integer(this.panels.length).toString());
    }

    public boolean hasNext() {
        return this.index < this.panelsCount - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private FileObject getIndexJSPFO(FileObject webRoot, String indexJSP) {
        indexJSP = indexJSP.replace('.', '/');
        return webRoot.getFileObject(indexJSP, "jsp");
    }
}

