/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.net.URL;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.modules.web.core.syntax.completion.JspCompletionProvider;
import org.netbeans.modules.web.core.syntax.completion.ResultItemPaintComponent;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public abstract class ResultItem
implements CompletionQuery.ResultItem,
CompletionItem {
    static String toAdd;
    public static final String COMPLETION_SUBSTITUTE_TEXT = "completion-substitute-text";
    protected int selectionStartOffset = -1;
    protected int selectionEndOffset = -1;
    private int substituteOffset = -1;
    protected boolean shift = false;

    public int getSubstituteOffset() {
        return this.substituteOffset;
    }

    public void setSubstituteOffset(int offset) {
        this.substituteOffset = offset;
    }

    public abstract String getItemText();

    public abstract Component getPaintComponent(boolean var1);

    public abstract int getSortPriority();

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public void processKeyEvent(KeyEvent e) {
        this.shift = e.getKeyCode() == 10 && e.getID() == 401 && e.isShiftDown();
    }

    public boolean substituteCommonText(JTextComponent c, int offset, int len, int subLen) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
        BaseDocument doc = (BaseDocument)c.getDocument();
        String text = this.getItemText();
        if (text != null) {
            if (toAdd != null && !toAdd.equals("\n")) {
                text = text + toAdd;
            }
            doc.atomicLock();
            try {
                String textToReplace = doc.getText(offset, len);
                if (text.equals(textToReplace)) {
                    boolean bl = false;
                    return bl;
                }
                doc.remove(offset, len);
                doc.insertString(offset, text, null);
                if (this.selectionStartOffset >= 0) {
                    c.select(offset + this.selectionStartOffset, offset + this.selectionEndOffset);
                }
            }
            catch (BadLocationException e) {
            }
            finally {
                doc.atomicUnlock();
            }
        }
        return true;
    }

    public Component getPaintComponent(JList list, boolean isSelected, boolean cellHasFocus) {
        Component ret = this.getPaintComponent(isSelected);
        if (ret == null) {
            return null;
        }
        if (isSelected) {
            ret.setBackground(list.getSelectionBackground());
            ret.setForeground(list.getSelectionForeground());
        } else {
            ret.setBackground(list.getBackground());
            ret.setForeground(list.getForeground());
        }
        ret.getAccessibleContext().setAccessibleName(this.getItemText());
        ret.getAccessibleContext().setAccessibleDescription(this.getItemText());
        return ret;
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        Component renderComponent = this.getPaintComponent(false);
        return renderComponent.getPreferredSize().width;
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        Component renderComponent = this.getPaintComponent(selected);
        renderComponent.setFont(defaultFont);
        renderComponent.setForeground(defaultColor);
        renderComponent.setBackground(backgroundColor);
        renderComponent.setBounds(0, 0, width, height);
        ((ResultItemPaintComponent)renderComponent).paintComponent(g);
    }

    public boolean instantSubstitution(JTextComponent c) {
        this.defaultAction(c);
        return true;
    }

    public CompletionTask createDocumentationTask() {
        return new AsyncCompletionTask((AsyncCompletionQuery)new JspCompletionProvider.DocQuery(this));
    }

    public abstract URL getHelpURL();

    public abstract String getHelp();

    public abstract boolean hasHelp();

    public CompletionTask createToolTipTask() {
        return null;
    }

    public int getImportance() {
        return 0;
    }

    public void defaultAction(JTextComponent component) {
        int substOffset = this.getSubstituteOffset();
        if (substOffset == -1) {
            substOffset = component.getCaret().getDot();
        }
        if (!this.shift) {
            Completion.get().hideAll();
        }
        this.substituteText(component, substOffset, component.getCaret().getDot() - substOffset, this.shift);
    }
}

