/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Settings;
import org.netbeans.editor.ext.java.JavaSettingsInitializer;
import org.netbeans.editor.ext.java.JavaSettingsNames;
import org.netbeans.modules.editor.NbLocalizer;
import org.netbeans.modules.editor.java.JavaIndentEngine;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.editor.java.NbJavaSettingsInitializer;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.java.editor.options.JavaOptions;
import org.netbeans.modules.java.editor.options.JavaPrintOptions;
import org.netbeans.modules.javacore.IndentationSettingsProvider;
import org.netbeans.modules.javacore.JMManager;
import org.openide.modules.ModuleInstall;
import org.openide.options.SystemOption;
import org.openide.text.IndentEngine;
import org.openide.text.PrintSettings;
import org.openide.util.SharedClassObject;

public class JavaEditorModule
extends ModuleInstall {
    private NbLocalizer settingsNamesLocalizer;
    private NbLocalizer optionsLocalizer;
    private JavaIndentationSettingsProvider jisProvider = null;
    static boolean inited = false;

    public static void init() {
        if (inited) {
            return;
        }
        inited = true;
        Settings.addInitializer((Settings.Initializer)new JavaSettingsInitializer(JavaKit.class));
        Settings.addInitializer((Settings.Initializer)new NbJavaSettingsInitializer());
        Settings.reset();
    }

    public void restored() {
        JavaEditorModule.init();
        PrintSettings ps = (PrintSettings)SharedClassObject.findObject((Class)PrintSettings.class, (boolean)true);
        ps.addOption((SystemOption)SharedClassObject.findObject((Class)JavaPrintOptions.class, (boolean)true));
        JMManager.setDocumentLocksCounter((ThreadLocal)BaseDocument.THREAD_LOCAL_LOCK_DEPTH);
        this.settingsNamesLocalizer = new NbLocalizer(JavaSettingsNames.class);
        this.optionsLocalizer = new NbLocalizer(JavaOptions.class);
        LocaleSupport.addLocalizer((LocaleSupport.Localizer)this.settingsNamesLocalizer);
        LocaleSupport.addLocalizer((LocaleSupport.Localizer)this.optionsLocalizer);
        if (this.jisProvider == null) {
            this.jisProvider = new JavaIndentationSettingsProvider();
            JMManager.setIndentationSettingsProvider((IndentationSettingsProvider)this.jisProvider);
        }
    }

    public void uninstalled() {
        if (this.jisProvider != null) {
            this.jisProvider.release();
            JMManager.setIndentationSettingsProvider(null);
            this.jisProvider = null;
        }
        PrintSettings ps = (PrintSettings)SharedClassObject.findObject((Class)PrintSettings.class, (boolean)true);
        ps.removeOption((SystemOption)SharedClassObject.findObject((Class)JavaPrintOptions.class, (boolean)true));
        JMManager.setDocumentLocksCounter(null);
        Settings.removeInitializer((String)"java-settings-initializer");
        Settings.removeInitializer((String)"nb-java-settings-initializer");
        Settings.reset();
        LocaleSupport.removeLocalizer((LocaleSupport.Localizer)this.settingsNamesLocalizer);
        this.settingsNamesLocalizer = null;
        LocaleSupport.removeLocalizer((LocaleSupport.Localizer)this.optionsLocalizer);
        this.optionsLocalizer = null;
    }

    private static class JavaIndentationSettingsProvider
    implements IndentationSettingsProvider,
    PropertyChangeListener {
        private static final Map indentSettings2propertyName = new HashMap();
        private JavaIndentEngine indentEngine = null;
        private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        private synchronized JavaIndentEngine getIndentEngine() {
            IndentEngine eng;
            BaseOptions javaOptions;
            if (this.indentEngine == null && (javaOptions = BaseOptions.getOptions((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaEditorModule.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit))) instanceof JavaOptions && (eng = javaOptions.getIndentEngine()) instanceof JavaIndentEngine) {
                this.indentEngine = (JavaIndentEngine)eng;
                this.indentEngine.addPropertyChangeListener(this);
            }
            return this.indentEngine;
        }

        public Object getPropertyValue(String propertyName) {
            String settingsPropertyName;
            JavaIndentEngine eng = this.getIndentEngine();
            if (eng != null && (settingsPropertyName = (String)indentSettings2propertyName.get(propertyName)) != null) {
                return eng.getValue(settingsPropertyName);
            }
            return null;
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.getIndentEngine();
            this.pcs.removePropertyChangeListener(l);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.getIndentEngine();
            this.pcs.addPropertyChangeListener(l);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt == null) {
                return;
            }
            this.pcs.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }

        public synchronized void release() {
            if (this.indentEngine != null) {
                this.indentEngine.removePropertyChangeListener(this);
            }
        }

        static {
            indentSettings2propertyName.put("javaFormatLeadingStarInComment", "java-format-leading-star-in-comment");
            indentSettings2propertyName.put("javaFormatNewlineBeforeBrace", "java-format-newline-before-brace");
            indentSettings2propertyName.put("javaFormatSpaceBeforeParenthesis", "java-format-space-before-parenthesis");
            indentSettings2propertyName.put("javaFormatStatementContinuationIndent", "java-format-statement-continuation-indent");
            indentSettings2propertyName.put("expandTabs", "expand-tabs");
            indentSettings2propertyName.put("spacesPerTab", "spaces-per-tab");
        }
    }
}

