/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.EditableManifest;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleTypeProvider;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class Util {
    public static final ErrorManager err;
    private static final String SFS_VALID_PATH_RE = "(\\p{Alnum}|\\/|_)+";
    static final /* synthetic */ boolean $assertionsDisabled;

    private Util() {
    }

    public static Element findElement(Element parent, String name, String namespace) {
        Element result = null;
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (l.item(i).getNodeType() != 1) continue;
            Element el = (Element)l.item(i);
            if ((namespace != null || !name.equals(el.getTagName())) && (namespace == null || !name.equals(el.getLocalName()) || !namespace.equals(el.getNamespaceURI()))) continue;
            if (result == null) {
                result = el;
                continue;
            }
            return null;
        }
        return result;
    }

    public static String findText(Element parent) {
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (l.item(i).getNodeType() != 3) continue;
            Text text = (Text)l.item(i);
            return text.getNodeValue();
        }
        return null;
    }

    public static List findSubElements(Element parent) throws IllegalArgumentException {
        NodeList l = parent.getChildNodes();
        ArrayList<Element> elements = new ArrayList<Element>(l.getLength());
        for (int i = 0; i < l.getLength(); ++i) {
            Node n = l.item(i);
            if (n.getNodeType() == 1) {
                elements.add((Element)n);
                continue;
            }
            if (n.getNodeType() == 3) {
                String text = ((Text)n).getNodeValue();
                if (text.trim().length() <= 0) continue;
                throw new IllegalArgumentException("non-ws text encountered in " + parent + ": " + text);
            }
            if (n.getNodeType() == 8) continue;
            throw new IllegalArgumentException("unexpected non-element child of " + parent + ": " + n);
        }
        return elements;
    }

    public static URL urlForDir(File dir) {
        try {
            URL u = FileUtil.normalizeFile((File)dir).toURI().toURL();
            String s = u.toExternalForm();
            if (s.endsWith("/")) {
                return u;
            }
            return new URL(s + "/");
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static URL urlForJar(File jar) {
        try {
            return FileUtil.getArchiveRoot((URL)FileUtil.normalizeFile((File)jar).toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static URL urlForDirOrJar(File location) {
        try {
            URL u = FileUtil.normalizeFile((File)location).toURI().toURL();
            if (FileUtil.isArchiveFile((URL)u)) {
                u = FileUtil.getArchiveRoot((URL)u);
            } else {
                String us = u.toExternalForm();
                if (!us.endsWith("/")) {
                    u = new URL(us + "/");
                }
            }
            return u;
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String getDisplayName(FileObject projectDir) {
        try {
            Project p = ProjectManager.getDefault().findProject(projectDir);
            return ProjectUtils.getInformation((Project)p).getDisplayName();
        }
        catch (IOException e) {
            return FileUtil.getFileDisplayName((FileObject)projectDir);
        }
    }

    public static String normalizeCNB(String value) {
        StringTokenizer tk = new StringTokenizer(value.toLowerCase(Locale.ENGLISH), ".", true);
        StringBuffer normalizedCNB = new StringBuffer();
        boolean delimExpected = false;
        while (tk.hasMoreTokens()) {
            String namePart = tk.nextToken();
            if (!delimExpected) {
                if (namePart.equals(".")) continue;
                for (int i = 0; i < namePart.length(); ++i) {
                    char c = namePart.charAt(i);
                    if (i == 0 ? !Character.isJavaIdentifierStart(c) : !Character.isJavaIdentifierPart(c)) continue;
                    normalizedCNB.append(c);
                }
            } else if (namePart.equals(".")) {
                normalizedCNB.append(namePart);
            }
            delimExpected = !delimExpected;
        }
        return normalizedCNB.toString().replaceAll("\\.$", "");
    }

    public static boolean isValidJavaFQN(String name) {
        if (name.length() == 0) {
            return false;
        }
        StringTokenizer tk = new StringTokenizer(name, ".", true);
        boolean delimExpected = false;
        while (tk.hasMoreTokens()) {
            String namePart = tk.nextToken();
            if (delimExpected ^ namePart.equals(".")) {
                return false;
            }
            if (!delimExpected && !Utilities.isJavaIdentifier((String)namePart)) {
                return false;
            }
            delimExpected = !delimExpected;
        }
        return delimExpected;
    }

    public static LocalizedBundleInfo findLocalizedBundleInfo(FileObject sourceDir, Manifest manifest) {
        String locBundleResource = ManifestManager.getInstance(manifest, false).getLocalizingBundle();
        try {
            if (locBundleResource != null) {
                ArrayList<FileObject> bundleFOs = new ArrayList<FileObject>();
                Iterator it = Util.getPossibleResources(locBundleResource);
                while (it.hasNext()) {
                    String resource = (String)it.next();
                    FileObject bundleFO = sourceDir.getFileObject(resource);
                    if (bundleFO == null) continue;
                    bundleFOs.add(bundleFO);
                }
                if (!bundleFOs.isEmpty()) {
                    Collections.reverse(bundleFOs);
                    return LocalizedBundleInfo.load(bundleFOs.toArray(new FileObject[bundleFOs.size()]));
                }
            }
        }
        catch (IOException e) {
            err.notify(1, (Throwable)e);
        }
        return null;
    }

    public static LocalizedBundleInfo findLocalizedBundleInfo(File projectDir) {
        NbModuleProject p;
        block5: {
            p = null;
            try {
                p = (NbModuleProject)ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)projectDir));
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)e);
            }
        }
        if (!$assertionsDisabled && p == null) {
            throw new AssertionError((Object)("Not valid project under " + projectDir));
        }
        String src = p.evaluator().getProperty("src.dir");
        if (!$assertionsDisabled && src == null) {
            throw new AssertionError((Object)("Cannot evaluate src.dir property for " + p));
        }
        File srcF = FileUtil.normalizeFile((File)new File(projectDir, src));
        FileObject sourceDir = FileUtil.toFileObject((File)srcF);
        FileObject manifestFO = FileUtil.toFileObject((File)new File(projectDir, "manifest.mf"));
        LocalizedBundleInfo locInfo = null;
        Manifest mf = Util.getManifest(manifestFO);
        if (sourceDir != null && mf != null) {
            locInfo = Util.findLocalizedBundleInfo(sourceDir, mf);
        }
        return locInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LocalizedBundleInfo findLocalizedBundleInfoFromJAR(File binaryProject) {
        try {
            JarFile main = new JarFile(binaryProject);
            try {
                Manifest mf = main.getManifest();
                String locBundleResource = ManifestManager.getInstance(mf, false).getLocalizingBundle();
                if (locBundleResource == null) return null;
                ArrayList bundleISs = new ArrayList();
                ArrayList<JarFile> extraJarFiles = new ArrayList<JarFile>();
                try {
                    String name = binaryProject.getName();
                    int dot = name.lastIndexOf(46);
                    if (dot == -1) {
                        dot = name.length();
                    }
                    String base = name.substring(0, dot);
                    String suffix = name.substring(dot);
                    Iterator it = NbBundle.getLocalizingSuffixes();
                    while (it.hasNext()) {
                        String infix = (String)it.next();
                        File variant = new File(binaryProject.getParentFile(), "locale" + File.separatorChar + base + infix + suffix);
                        if (!variant.isFile()) continue;
                        JarFile jf = new JarFile(variant);
                        extraJarFiles.add(jf);
                        Util.addBundlesFromJar(jf, bundleISs, locBundleResource);
                    }
                    Util.addBundlesFromJar(main, bundleISs, locBundleResource);
                    if (!bundleISs.isEmpty()) {
                        Collections.reverse(bundleISs);
                        LocalizedBundleInfo localizedBundleInfo = LocalizedBundleInfo.load(bundleISs.toArray(new InputStream[bundleISs.size()]));
                        return localizedBundleInfo;
                    }
                }
                finally {
                    Iterator it = bundleISs.iterator();
                    while (it.hasNext()) {
                        ((InputStream)it.next()).close();
                    }
                    it = extraJarFiles.iterator();
                    while (it.hasNext()) {
                        ((JarFile)it.next()).close();
                    }
                }
            }
            finally {
                main.close();
            }
        }
        catch (IOException e) {
            err.notify(1, (Throwable)e);
        }
        return null;
    }

    private static void addBundlesFromJar(JarFile jf, List bundleISs, String locBundleResource) throws IOException {
        Iterator it = Util.getPossibleResources(locBundleResource);
        while (it.hasNext()) {
            String resource = (String)it.next();
            ZipEntry entry = jf.getEntry(resource);
            if (entry == null) continue;
            InputStream bundleIS = jf.getInputStream(entry);
            bundleISs.add(bundleIS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EditableProperties loadProperties(FileObject propsFO) throws IOException {
        InputStream propsIS = propsFO.getInputStream();
        EditableProperties props = new EditableProperties(true);
        try {
            props.load(propsIS);
        }
        finally {
            propsIS.close();
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeProperties(FileObject propsFO, EditableProperties props) throws IOException {
        FileLock lock = propsFO.lock();
        try {
            OutputStream os = propsFO.getOutputStream(lock);
            try {
                props.store(os);
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EditableManifest loadManifest(FileObject manifestFO) throws IOException {
        InputStream mfIS = manifestFO.getInputStream();
        try {
            EditableManifest editableManifest = new EditableManifest(mfIS);
            return editableManifest;
        }
        finally {
            mfIS.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeManifest(FileObject manifestFO, EditableManifest em) throws IOException {
        FileLock lock = manifestFO.lock();
        try {
            OutputStream os = manifestFO.getOutputStream(lock);
            try {
                em.write(os);
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    public static URL findJavadocForNetBeansOrgModules(ModuleDependency dep) {
        ModuleEntry entry = dep.getModuleEntry();
        File destDir = entry.getDestDir();
        File nbOrg = null;
        if (destDir.getParent() != null) {
            nbOrg = destDir.getParentFile().getParentFile();
        }
        if (nbOrg == null) {
            throw new IllegalArgumentException("ModuleDependency " + dep + " doesn't represent nb.org module");
        }
        File builtJavadoc = new File(nbOrg, "nbbuild/build/javadoc");
        URL[] javadocURLs = null;
        if (builtJavadoc.exists()) {
            File[] javadocs = builtJavadoc.listFiles();
            javadocURLs = new URL[javadocs.length];
            for (int i = 0; i < javadocs.length; ++i) {
                javadocURLs[i] = Util.urlForDirOrJar(javadocs[i]);
            }
        }
        return javadocURLs == null ? null : Util.findJavadocURL(dep.getModuleEntry().getCodeNameBase().replace('.', '-'), javadocURLs);
    }

    public static URL findJavadoc(ModuleDependency dep, NbPlatform platform) {
        String cnbdashes = dep.getModuleEntry().getCodeNameBase().replace('.', '-');
        URL[] roots = platform.getJavadocRoots();
        return roots == null ? null : Util.findJavadocURL(cnbdashes, roots);
    }

    public static boolean isValidSFSPath(String path) {
        return path.matches(SFS_VALID_PATH_RE);
    }

    public static boolean addDependency(NbModuleProject target, NbModuleProject dependency) throws IOException {
        return Util.addDependency(target, dependency.getCodeNameBase());
    }

    public static boolean addDependency(NbModuleProject target, String codeNameBase) throws IOException {
        return Util.addDependency(target, codeNameBase, null, null, true);
    }

    public static boolean addDependency(NbModuleProject target, String codeNameBase, String releaseVersion, SpecificationVersion version, boolean useInCompiler) throws IOException {
        ModuleEntry me = target.getModuleList().getEntry(codeNameBase);
        if (me == null) {
            err.log(1, "Trying to add " + codeNameBase + " which cannot be found in the module's universe.");
            return false;
        }
        ProjectXMLManager pxm = new ProjectXMLManager(target);
        SortedSet currentDeps = pxm.getDirectDependencies();
        Iterator it = currentDeps.iterator();
        while (it.hasNext()) {
            ModuleDependency md = (ModuleDependency)it.next();
            if (!codeNameBase.equals(md.getModuleEntry().getCodeNameBase())) continue;
            err.log(1, codeNameBase + " already added");
            return false;
        }
        ModuleDependency md = new ModuleDependency(me, releaseVersion == null ? me.getReleaseVersion() : releaseVersion, version == null ? me.getSpecificationVersion() : version.toString(), useInCompiler, false);
        pxm.addDependency(md);
        return true;
    }

    private static URL findJavadocURL(String cnbdashes, URL[] roots) {
        URL indexURL = null;
        for (int i = 0; i < roots.length; ++i) {
            URL root = roots[i];
            try {
                indexURL = Util.normalizeURL(new URL(root, cnbdashes + "/index.html"));
                if (indexURL == null && root.toExternalForm().indexOf(cnbdashes) != -1) {
                    indexURL = Util.normalizeURL(new URL(root, "index.html"));
                }
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
            if (indexURL != null) break;
        }
        return indexURL;
    }

    private static URL normalizeURL(URL url) {
        return URLMapper.findFileObject((URL)url) == null ? null : url;
    }

    private static Iterator getPossibleResources(String locBundleResource) {
        String locBundleResourceExt;
        String locBundleResourceBase;
        int idx = locBundleResource.lastIndexOf(46);
        if (idx != -1 && idx > locBundleResource.lastIndexOf(47)) {
            locBundleResourceBase = locBundleResource.substring(0, idx);
            locBundleResourceExt = locBundleResource.substring(idx);
        } else {
            locBundleResourceBase = locBundleResource;
            locBundleResourceExt = "";
        }
        LinkedHashSet<String> resources = new LinkedHashSet<String>();
        Iterator it = NbBundle.getLocalizingSuffixes();
        while (it.hasNext()) {
            String suffix = (String)it.next();
            String resource = locBundleResourceBase + suffix + locBundleResourceExt;
            resources.add(resource);
            resources.add(resource);
        }
        return resources.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest getManifest(FileObject manifestFO) {
        if (manifestFO != null) {
            Manifest manifest;
            InputStream is = manifestFO.getInputStream();
            try {
                manifest = new Manifest(is);
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException e) {
                    err.notify(1, (Throwable)e);
                }
            }
            is.close();
            return manifest;
        }
        return null;
    }

    public static Comparator projectDisplayNameComparator() {
        return new Comparator(){
            private final Collator LOC_COLLATOR = Collator.getInstance();

            public int compare(Object o1, Object o2) {
                ProjectInformation i1 = ProjectUtils.getInformation((Project)((Project)o1));
                ProjectInformation i2 = ProjectUtils.getInformation((Project)((Project)o2));
                int result = this.LOC_COLLATOR.compare(i1.getDisplayName(), i2.getDisplayName());
                if (result != 0) {
                    return result;
                }
                result = i1.getName().compareTo(i2.getName());
                if (result != 0) {
                    return result;
                }
                return System.identityHashCode(o1) - System.identityHashCode(o2);
            }
        };
    }

    public static NbModuleTypeProvider.NbModuleType getModuleType(Project project) {
        NbModuleTypeProvider provider = (NbModuleTypeProvider)project.getLookup().lookup(NbModuleTypeProvider.class);
        if (!$assertionsDisabled && provider == null) {
            throw new AssertionError((Object)"has NbModuleTypeProvider in the lookup");
        }
        return provider.getModuleType();
    }

    static {
        $assertionsDisabled = !Util.class.desiredAssertionStatus();
        err = ErrorManager.getDefault().getInstance("org.netbeans.modules.apisupport.project");
    }

    public static final class UserPropertiesFileProvider
    implements PropertyProvider,
    PropertyChangeListener,
    ChangeListener {
        private final PropertyEvaluator eval;
        private final File basedir;
        private final List listeners = new ArrayList();
        private PropertyProvider delegate;

        public UserPropertiesFileProvider(PropertyEvaluator eval, File basedir) {
            this.eval = eval;
            this.basedir = basedir;
            eval.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)eval));
            this.computeDelegate();
        }

        private void computeDelegate() {
            String buildS;
            if (this.delegate != null) {
                this.delegate.removeChangeListener((ChangeListener)this);
            }
            if ((buildS = this.eval.getProperty("user.properties.file")) != null) {
                this.delegate = PropertyUtils.propertiesFilePropertyProvider((File)PropertyUtils.resolveFile((File)this.basedir, (String)buildS));
                this.delegate.addChangeListener((ChangeListener)this);
            } else {
                this.delegate = PropertyUtils.globalPropertyProvider();
                this.delegate.addChangeListener((ChangeListener)this);
            }
        }

        public Map getProperties() {
            if (this.delegate != null) {
                return this.delegate.getProperties();
            }
            return Collections.EMPTY_MAP;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener l) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener l) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.remove(l);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String p = evt.getPropertyName();
            if (p == null || p.equals("user.properties.file")) {
                this.computeDelegate();
                this.fireChange();
            }
        }

        public void stateChanged(ChangeEvent e) {
            this.fireChange();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            Iterator it;
            ChangeEvent ev = new ChangeEvent(this);
            List list = this.listeners;
            synchronized (list) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                it = new HashSet(this.listeners).iterator();
            }
            while (it.hasNext()) {
                ((ChangeListener)it.next()).stateChanged(ev);
            }
        }
    }

    public static abstract class ComputedPropertyProvider
    implements PropertyProvider,
    PropertyChangeListener {
        private final PropertyEvaluator eval;
        private final List listeners = new ArrayList();

        protected ComputedPropertyProvider(PropertyEvaluator eval) {
            this.eval = eval;
            eval.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)eval));
        }

        protected abstract Map getProperties(Map var1);

        protected abstract Set inputProperties();

        public final Map getProperties() {
            HashMap<String, String> vals = new HashMap<String, String>();
            Iterator it = this.inputProperties().iterator();
            while (it.hasNext()) {
                String k = (String)it.next();
                vals.put(k, this.eval.getProperty(k));
            }
            return this.getProperties(vals);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addChangeListener(ChangeListener l) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeChangeListener(ChangeListener l) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.remove(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void propertyChange(PropertyChangeEvent evt) {
            Iterator it;
            String p = evt.getPropertyName();
            if (p != null && !this.inputProperties().contains(p)) {
                return;
            }
            ChangeEvent ev = new ChangeEvent(this);
            List list = this.listeners;
            synchronized (list) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                it = new HashSet(this.listeners).iterator();
            }
            while (it.hasNext()) {
                ((ChangeListener)it.next()).stateChanged(ev);
            }
        }
    }
}

