/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.awt.Image;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleTypeProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.BadgingSupport;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.xml.XMLUtil;

public final class LayerNode
extends FilterNode {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$netbeans$modules$apisupport$project$layers$PickNameAction;
    static /* synthetic */ Class class$org$netbeans$modules$apisupport$project$layers$PickIconAction;

    public LayerNode(LayerUtils.LayerHandle handle) {
        super(LayerNode.getDataNode(handle), (Children)new LayerChildren(handle));
    }

    private static Node getDataNode(LayerUtils.LayerHandle handle) {
        FileObject layer = handle.getLayerFile();
        try {
            return DataObject.find((FileObject)layer).getNodeDelegate();
        }
        catch (DataObjectNotFoundException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)e);
            }
            return Node.EMPTY;
        }
    }

    private static FileSystem badge(FileSystem base, ClassPath cp, FileObject layer, String rootLabel, FileSystem highlighted) {
        class BadgingMergedFileSystem
        extends MultiFileSystem {
            private final BadgingSupport status;
            private final /* synthetic */ FileSystem val$base;
            private final /* synthetic */ ClassPath val$cp;
            private final /* synthetic */ String val$rootLabel;
            private final /* synthetic */ FileSystem val$highlighted;
            private final /* synthetic */ FileObject val$layer;

            public BadgingMergedFileSystem(FileSystem fileSystem, ClassPath classPath, String string, FileSystem fileSystem2, FileObject fileObject) {
                this.val$base = fileSystem;
                this.val$cp = classPath;
                this.val$rootLabel = string;
                this.val$highlighted = fileSystem2;
                this.val$layer = fileObject;
                super(new FileSystem[]{fileSystem});
                this.status = new BadgingSupport((FileSystem)this);
                this.status.addFileStatusListener(new FileStatusListener(){

                    public void annotationChanged(FileStatusEvent ev) {
                        this.fireFileStatusChanged(ev);
                    }
                });
                this.status.setClasspath(this.val$cp);
                this.addFileChangeListener(new FileChangeListener(){

                    private void fire() {
                        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, true, true));
                    }

                    public void fileAttributeChanged(FileAttributeEvent fe) {
                        this.fire();
                    }

                    public void fileChanged(FileEvent fe) {
                        this.fire();
                    }

                    public void fileDataCreated(FileEvent fe) {
                        this.fire();
                    }

                    public void fileDeleted(FileEvent fe) {
                        this.fire();
                    }

                    public void fileFolderCreated(FileEvent fe) {
                        this.fire();
                    }

                    public void fileRenamed(FileRenameEvent fe) {
                        this.fire();
                    }
                });
            }

            public FileSystem.Status getStatus() {
                return new FileSystem.HtmlStatus(){

                    public String annotateNameHtml(String name, Set files) {
                        String htmlLabel;
                        String nonHtmlLabel = status.annotateName(name, files);
                        if (files.size() == 1 && ((FileObject)files.iterator().next()).isRoot()) {
                            nonHtmlLabel = val$rootLabel;
                        }
                        try {
                            htmlLabel = XMLUtil.toElementContent((String)nonHtmlLabel);
                        }
                        catch (CharConversionException e) {
                            Util.err.notify(1, (Throwable)e);
                            htmlLabel = nonHtmlLabel;
                        }
                        if (val$highlighted != null) {
                            boolean local = false;
                            Iterator it = files.iterator();
                            while (it.hasNext()) {
                                FileObject f = (FileObject)it.next();
                                if (f.isRoot() || val$highlighted.findResource(f.getPath()) == null) continue;
                                local = true;
                                break;
                            }
                            if (local) {
                                htmlLabel = "<b>" + htmlLabel + "</b>";
                            }
                        }
                        return htmlLabel;
                    }

                    public String annotateName(String name, Set files) {
                        return name;
                    }

                    public Image annotateIcon(Image icon, int iconType, Set files) {
                        return status.annotateIcon(icon, iconType, files);
                    }
                };
            }

            public String getDisplayName() {
                return FileUtil.getFileDisplayName((FileObject)this.val$layer);
            }

            public SystemAction[] getActions(Set foSet) {
                return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$apisupport$project$layers$PickNameAction == null ? (class$org$netbeans$modules$apisupport$project$layers$PickNameAction = LayerNode.class$("org.netbeans.modules.apisupport.project.layers.PickNameAction")) : class$org$netbeans$modules$apisupport$project$layers$PickNameAction)), SystemAction.get((Class)(class$org$netbeans$modules$apisupport$project$layers$PickIconAction == null ? (class$org$netbeans$modules$apisupport$project$layers$PickIconAction = LayerNode.class$("org.netbeans.modules.apisupport.project.layers.PickIconAction")) : class$org$netbeans$modules$apisupport$project$layers$PickIconAction))};
            }
        }
        return new BadgingMergedFileSystem(base, cp, rootLabel, highlighted, layer);
    }

    public String getDisplayName() {
        return NbBundle.getMessage((Class)LayerNode.class, (String)"LayerNode_label");
    }

    private static ClassPath createClasspath(NbModuleProject p) throws IOException {
        NbModuleTypeProvider.NbModuleType type = Util.getModuleType(p);
        if (type == NbModuleTypeProvider.STANDALONE) {
            return LayerUtils.createLayerClasspath(Collections.singleton(p), LayerUtils.getPlatformJarsForStandaloneProject(p));
        }
        if (type == NbModuleTypeProvider.SUITE_COMPONENT) {
            SuiteProject suite = SuiteUtils.findSuite(p);
            if (suite == null) {
                throw new IOException("Could not load suite for " + p);
            }
            Set modules = SuiteUtils.getSubProjects(suite);
            return LayerUtils.createLayerClasspath(modules, LayerUtils.getPlatformJarsForSuiteComponentProject(p, suite));
        }
        if (type == NbModuleTypeProvider.NETBEANS_ORG) {
            return LayerUtils.createLayerClasspath(LayerUtils.getProjectsForNetBeansOrgProject(p), Collections.EMPTY_SET);
        }
        throw new AssertionError(type);
    }

    static {
        $assertionsDisabled = !LayerNode.class.desiredAssertionStatus();
    }

    private static final class LayerChildren
    extends Children.Keys {
        private static final String KEY_WAIT = "wait";
        private static final Object KEY_RAW = "raw";
        private static final Object KEY_CONTEXTUALIZED = "contextualized";
        private final LayerUtils.LayerHandle handle;
        private ClassPath cp;
        private NbModuleProject p;
        private FileSystem layerfs;
        private FileSystem sfs;

        public LayerChildren(LayerUtils.LayerHandle handle) {
            this.handle = handle;
        }

        protected void addNotify() {
            super.addNotify();
            this.handle.setAutosave(true);
            this.setKeys(new Object[]{KEY_WAIT});
            RequestProcessor.getDefault().post(new Runnable(){
                static final /* synthetic */ boolean $assertionsDisabled;

                public void run() {
                    try {
                        FileObject layer = LayerChildren.this.handle.getLayerFile();
                        LayerChildren.this.p = (NbModuleProject)FileOwnerQuery.getOwner((FileObject)layer);
                        if (!$assertionsDisabled && LayerChildren.this.p == null) {
                            throw new AssertionError(layer);
                        }
                        try {
                            LayerChildren.this.cp = LayerNode.createClasspath(LayerChildren.this.p);
                        }
                        catch (IOException e) {
                            Util.err.notify(1, (Throwable)e);
                        }
                        LayerChildren.this.layerfs = LayerChildren.this.handle.layer(false);
                        LayerChildren.this.setKeys(new Object[]{KEY_RAW, LayerChildren.KEY_WAIT});
                        FileSystem _sfs = LayerUtils.getEffectiveSystemFilesystem(LayerChildren.this.p);
                        if (LayerChildren.this.cp != null) {
                            LayerChildren.this.sfs = _sfs;
                            LayerChildren.this.setKeys(new Object[]{KEY_RAW, KEY_CONTEXTUALIZED});
                        }
                    }
                    catch (IOException e) {
                        Util.err.notify(1, (Throwable)e);
                    }
                }

                static {
                    $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$layers$LayerNode == null ? (class$org$netbeans$modules$apisupport$project$layers$LayerNode = LayerNode.class$("org.netbeans.modules.apisupport.project.layers.LayerNode")) : class$org$netbeans$modules$apisupport$project$layers$LayerNode).desiredAssertionStatus();
                }
            });
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            this.cp = null;
            this.p = null;
            this.layerfs = null;
            this.sfs = null;
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            try {
                if (key == KEY_RAW) {
                    FileSystem fs = LayerNode.badge(this.layerfs, this.cp, this.handle.getLayerFile(), NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$layers$LayerNode == null ? (class$org$netbeans$modules$apisupport$project$layers$LayerNode = LayerNode.class$("org.netbeans.modules.apisupport.project.layers.LayerNode")) : class$org$netbeans$modules$apisupport$project$layers$LayerNode), (String)"LBL_this_layer"), null);
                    return new Node[]{DataObject.find((FileObject)fs.getRoot()).getNodeDelegate()};
                }
                if (key == KEY_CONTEXTUALIZED) {
                    FileSystem fs = LayerNode.badge(this.sfs, this.cp, this.handle.getLayerFile(), NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$layers$LayerNode == null ? (class$org$netbeans$modules$apisupport$project$layers$LayerNode = LayerNode.class$("org.netbeans.modules.apisupport.project.layers.LayerNode")) : class$org$netbeans$modules$apisupport$project$layers$LayerNode), (String)"LBL_this_layer_in_context"), this.handle.layer(false));
                    return new Node[]{DataObject.find((FileObject)fs.getRoot()).getNodeDelegate()};
                }
                if (key == KEY_WAIT) {
                    return new Node[]{new AbstractNode(FilterNode.Children.LEAF){

                        public String getName() {
                            return LayerChildren.KEY_WAIT;
                        }

                        public String getDisplayName() {
                            return NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$layers$LayerNode == null ? (class$org$netbeans$modules$apisupport$project$layers$LayerNode = LayerNode.class$("org.netbeans.modules.apisupport.project.layers.LayerNode")) : class$org$netbeans$modules$apisupport$project$layers$LayerNode), (String)"LayerNode_please_wait");
                        }
                    }};
                }
                throw new AssertionError(key);
            }
            catch (IOException e) {
                Util.err.notify(1, (Throwable)e);
                return new Node[0];
            }
        }
    }
}

