/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleProperties;
import org.openide.util.WeakListeners;

public class JavaPlatformComponentFactory {
    private static final ComboBoxModel MODEL = new Model();
    private static final ListCellRenderer RENDERER = new Renderer();

    private JavaPlatformComponentFactory() {
    }

    public static ComboBoxModel javaPlatformListModel() {
        return MODEL;
    }

    public static ListCellRenderer javaPlatformListCellRenderer() {
        return RENDERER;
    }

    private static final class Renderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String name = value != null ? ((JavaPlatform)value).getDisplayName() : null;
            return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
        }
    }

    private static final class Model
    implements ComboBoxModel,
    PropertyChangeListener,
    Comparator {
        private static final Collator COLL = Collator.getInstance();
        private static final JavaPlatformManager mgr = JavaPlatformManager.getDefault();
        private final SortedSet platforms = new TreeSet(this);
        private final List listeners = new ArrayList();
        private JavaPlatform selected;

        public Model() {
            this.refresh();
            mgr.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)mgr));
        }

        private void refresh() {
            this.platforms.clear();
            this.platforms.addAll(Arrays.asList(mgr.getInstalledPlatforms()));
        }

        public int getSize() {
            return this.platforms.size();
        }

        public Object getElementAt(int index) {
            return (JavaPlatform)new ArrayList(this.platforms).get(index);
        }

        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        public void setSelectedItem(Object sel) {
            if (sel != this.selected) {
                this.selected = (JavaPlatform)sel;
                this.fireChange();
            }
        }

        public Object getSelectedItem() {
            return this.selected;
        }

        private void fireChange() {
            ListDataEvent ev = new ListDataEvent(this, 0, 0, 0);
            Iterator it = new ArrayList(this.listeners).iterator();
            while (it.hasNext()) {
                ((ListDataListener)it.next()).contentsChanged(ev);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.refresh();
            this.fireChange();
        }

        public int compare(Object o1, Object o2) {
            JavaPlatform p1 = (JavaPlatform)o1;
            JavaPlatform p2 = (JavaPlatform)o2;
            int res = COLL.compare(p1.getDisplayName(), p2.getDisplayName());
            if (res != 0) {
                return res;
            }
            String id1 = ModuleProperties.getPlatformID(p1);
            String id2 = ModuleProperties.getPlatformID(p2);
            if (id1 != null && id2 != null) {
                return id1.compareTo(id2);
            }
            return System.identityHashCode(p1) - System.identityHashCode(p2);
        }
    }
}

