/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.archive.project;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.j2ee.archive.Util;
import org.netbeans.modules.j2ee.archive.customizer.ProvidesCustomizer;
import org.netbeans.modules.j2ee.archive.project.ArchiveProjectOperations;
import org.netbeans.modules.j2ee.archive.project.ArchiveProjectProperties;
import org.netbeans.modules.j2ee.archive.project.ProvidesAction;
import org.netbeans.modules.j2ee.archive.project.ProvidesJ2eeModule;
import org.netbeans.modules.j2ee.archive.project.ProvidesLogicalView;
import org.netbeans.modules.j2ee.archive.project.UpdateHelper;
import org.netbeans.modules.j2ee.common.ui.BrokenServerSupport;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.application.Module;
import org.netbeans.modules.j2ee.dd.api.application.Web;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ArchiveProject
implements Project {
    private final AuxiliaryConfiguration aux;
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final GeneratedFilesHelper genFilesHelper;
    private final Lookup lookup;
    private ArchiveProjectProperties projProperties;
    private static final Icon ARCHIVE_PROJECT_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/j2ee/archive/project/resources/application_assembler_16.gif"));
    private final UpdateHelper updateHelper;
    private HashMap nameMap;
    private static final String NAME_LIT = "name";

    public ArchiveProject(AntProjectHelper helper) {
        this.helper = helper;
        this.eval = helper.getStandardPropertyEvaluator();
        this.aux = helper.createAuxiliaryConfiguration();
        this.genFilesHelper = new GeneratedFilesHelper(helper);
        this.lookup = new HelpfulLookup();
        this.updateHelper = new UpdateHelper(this, this.helper, this.aux, this.genFilesHelper, UpdateHelper.createDefaultNotifier());
        this.nameMap = new HashMap(5);
    }

    public FileObject getProjectDirectory() {
        return this.helper.getProjectDirectory();
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public PropertyEvaluator getPropertyEvaluator() {
        return this.eval;
    }

    public String getProjectProperty(String propName) {
        return (String)this.getArchiveProjectProperties().get(propName);
    }

    public String getEarPath(String key) {
        return (String)this.nameMap.get(key);
    }

    public void setEarPath(String key, String val) {
        this.nameMap.put(key, val);
    }

    public void setName(final String name) {
        ProjectManager.mutex().writeAccess(new Mutex.Action(){

            public Object run() {
                Element nameEl;
                Element data = ArchiveProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/archive-project/1", ArchiveProject.NAME_LIT);
                if (nl.getLength() == 1) {
                    nameEl = (Element)nl.item(0);
                    NodeList deadKids = nameEl.getChildNodes();
                    while (deadKids.getLength() > 0) {
                        nameEl.removeChild(deadKids.item(0));
                    }
                } else {
                    nameEl = data.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/archive-project/1", ArchiveProject.NAME_LIT);
                    data.insertBefore(nameEl, data.getChildNodes().item(0));
                }
                nameEl.appendChild(data.getOwnerDocument().createTextNode(name));
                ArchiveProject.this.helper.putPrimaryConfigurationData(data, true);
                return null;
            }
        });
    }

    public String getName() {
        return (String)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                Element data = ArchiveProject.this.updateHelper.getPrimaryConfigurationData(true);
                NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/archive-project/1", ArchiveProject.NAME_LIT);
                if (nl.getLength() == 1 && (nl = nl.item(0).getChildNodes()).getLength() == 1 && nl.item(0).getNodeType() == 3) {
                    return ((Text)nl.item(0)).getNodeValue();
                }
                return "BINARCHIVE???";
            }
        });
    }

    public ArchiveProjectProperties getArchiveProjectProperties() {
        this.projProperties = new ArchiveProjectProperties(this, this.getAntProjectHelper());
        return this.projProperties;
    }

    public String getNamedProjectAttribute(final String attr) {
        return (String)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                Element data = ArchiveProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/archive-project/1", attr);
                if (nl.getLength() == 1 && (nl = nl.item(0).getChildNodes()).getLength() == 1 && nl.item(0).getNodeType() == 3) {
                    return ((Text)nl.item(0)).getNodeValue();
                }
                return "???";
            }
        });
    }

    public void setNamedProjectAttribute(final String attr, final String value) {
        ProjectManager.mutex().writeAccess(new Mutex.Action(){

            public Object run() {
                Element nameEl;
                Element data = ArchiveProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/archive-project/1", attr);
                if (nl.getLength() == 1) {
                    nameEl = (Element)nl.item(0);
                    NodeList deadKids = nameEl.getChildNodes();
                    while (deadKids.getLength() > 0) {
                        nameEl.removeChild(deadKids.item(0));
                    }
                } else {
                    nameEl = data.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/archive-project/1", attr);
                    data.insertBefore(nameEl, data.getChildNodes().item(0));
                }
                nameEl.appendChild(data.getOwnerDocument().createTextNode(value));
                ArchiveProject.this.helper.putPrimaryConfigurationData(data, true);
                return null;
            }
        });
    }

    private void doRegeneration() {
        GeneratedFilesHelper gFH = new GeneratedFilesHelper(this.helper);
        ArchiveProjectProperties app = this.getArchiveProjectProperties();
        String sourceArchive = this.eval.evaluate((String)app.get("source.archive"));
        try {
            if (sourceArchive.endsWith("war")) {
                gFH.refreshBuildScript("nbproject/build-impl.xml", ArchiveProject.class.getResource("resources/build-impl-war.xsl"), true);
            } else {
                gFH.refreshBuildScript("nbproject/build-impl.xml", ArchiveProject.class.getResource("resources/build-impl.xsl"), true);
            }
        }
        catch (IllegalStateException ex) {
            ErrorManager.getDefault().log(1, "IllegalStateException while opening project: " + ex);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().log(1, "IOException while opening project: " + ex);
        }
        try {
            gFH.refreshBuildScript("build.xml", ArchiveProject.class.getResource("resources/build.xsl"), true);
        }
        catch (IllegalStateException ex) {
            ErrorManager.getDefault().log(1, "IllegalStateException while opening project: " + ex);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().log(1, "IOException while opening project: " + ex);
        }
        String servInstID = (String)app.get("j2ee.server.instance");
        J2eePlatform platform = Deployment.getDefault().getJ2eePlatform(servInstID);
        if (platform != null) {
            ArchiveProjectProperties.setServerInstance(this, this.helper, servInstID);
        } else {
            String[] servInstIDs;
            String serverType = (String)app.get("j2ee.server.type");
            if (serverType != null && (servInstIDs = Deployment.getDefault().getInstancesOfServer(serverType)).length > 0) {
                ArchiveProjectProperties.setServerInstance(this, this.helper, servInstIDs[0]);
                platform = Deployment.getDefault().getJ2eePlatform(servInstIDs[0]);
            }
            if (platform == null) {
                BrokenServerSupport.showAlert();
            }
        }
        FileObject dir = this.helper.getProjectDirectory();
        try {
            FileUtil.createFolder((FileObject)dir, (String)"setup");
        }
        catch (IOException ex) {
            ErrorManager.getDefault().log(1, "Error while opening project: " + ex);
        }
    }

    static /* synthetic */ PropertyEvaluator access$400(ArchiveProject x0) {
        return x0.eval;
    }

    class MyOpenHook {
        MyOpenHook() {
        }

        public void regenerateBuildFiles() {
            ArchiveProject.this.doRegeneration();
        }
    }

    private static final class RecommendedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private static final String[] APPLICATION_TYPES = new String[]{"sunresource-types", "XML", "simple-files"};
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/SunResources/JDBC_Connection_Pool", "Templates/SunResources/JDBC_Resource", "Templates/SunResources/JMS_Resource", "Templates/SunResources/JavaMail_Resource", "Templates/Persistence/Schema.dbschema"};

        RecommendedTemplatesImpl() {
        }

        public String[] getRecommendedTypes() {
            return APPLICATION_TYPES;
        }

        public String[] getPrivilegedTemplates() {
            return PRIVILEGED_NAMES;
        }
    }

    private class J2eeModuleForAddModuleAction
    implements J2eeModule {
        private Object mt = null;

        J2eeModuleForAddModuleAction(Object mt) {
            this.mt = mt;
        }

        public String getModuleVersion() {
            return "1.5";
        }

        public Object getModuleType() {
            return this.mt;
        }

        public String getUrl() {
            return null;
        }

        public void setUrl(String url) {
            throw new UnsupportedOperationException();
        }

        public FileObject getArchive() throws IOException {
            FileObject distDir = ArchiveProject.this.getProjectDirectory().getFileObject("dist");
            FileObject[] kids = distDir.getChildren();
            FileObject retVal = null;
            if (null != kids && kids.length == 1) {
                retVal = kids[0];
            } else if (null != kids && kids.length > 1) {
                for (FileObject kid : kids) {
                    if (!kid.isData() || !kid.getNameExt().endsWith("ar")) continue;
                    retVal = kid;
                }
            }
            return retVal;
        }

        public Iterator getArchiveContents() throws IOException {
            throw new UnsupportedOperationException();
        }

        public FileObject getContentDirectory() throws IOException {
            return null;
        }

        public BaseBean getDeploymentDescriptor(String location) {
            BaseBean retVal = null;
            if ("META-INF/application.xml".equals(location)) {
                String dir = (String)ArchiveProject.this.getArchiveProjectProperties().get("proxy.project.dir");
                FileObject appFile = ArchiveProject.this.getProjectDirectory().getFileObject(dir).getFileObject("src").getFileObject("conf").getFileObject("application.xml");
                try {
                    Application appBean = DDProvider.getDefault().getDDRoot(appFile);
                    retVal = DDProvider.getDefault().getBaseBean((CommonDDBean)appBean);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().log(1, "" + ex);
                }
            } else if ("META-INF/ra.xml".equals(location)) {
                retVal = null;
            } else {
                throw new UnsupportedOperationException(location);
            }
            return retVal;
        }

        public void addVersionListener(J2eeModule.VersionListener listener) {
        }

        public void removeVersionListener(J2eeModule.VersionListener listener) {
        }
    }

    class ProjectXmlSaved
    extends ProjectXmlSavedHook {
        ProjectXmlSaved() {
        }

        protected void projectXmlSaved() throws IOException {
            FileObject subDir = ArchiveProject.this.getProjectDirectory().getFileObject("tmpproj");
            if (subDir != null) {
                Project tmpproj = null;
                try {
                    tmpproj = ProjectManager.getDefault().findProject(subDir);
                }
                catch (IllegalArgumentException ex) {
                    ErrorManager.getDefault().log(1, "" + ex);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().log(1, "" + ex);
                }
                ProvidesJ2eeModule tmp = (ProvidesJ2eeModule)((Object)ArchiveProject.this.getLookup().lookup(ProvidesJ2eeModule.class));
                if (null != tmpproj) {
                    tmp.setServerInstanceID((String)ArchiveProject.this.getArchiveProjectProperties().get("j2ee.server.instance"));
                }
            }
        }
    }

    class OpenCloseHook
    extends ProjectOpenedHook {
        List<ClassPath[]> paths = new ArrayList<ClassPath[]>();

        OpenCloseHook() {
        }

        protected void projectOpened() {
            ProjectManager.mutex().writeAccess(new Mutex.Action(){

                public Object run() {
                    ArchiveProject.this.doRegeneration();
                    FileObject dir = ArchiveProject.this.helper.getProjectDirectory();
                    FileObject subDir = null;
                    ArchiveProjectProperties app = ArchiveProject.this.getArchiveProjectProperties();
                    String type = (String)app.get("javaee.archive.type");
                    boolean isEar = "ear".equals(type);
                    subDir = dir.getFileObject("tmpproj");
                    if (subDir != null) {
                        Project tmpproj = null;
                        try {
                            tmpproj = ProjectManager.getDefault().findProject(subDir);
                        }
                        catch (IllegalArgumentException ex) {
                            ErrorManager.getDefault().log(1, "" + ex);
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().log(1, "" + ex);
                        }
                        ProvidesJ2eeModule tmp = (ProvidesJ2eeModule)((Object)ArchiveProject.this.getLookup().lookup(ProvidesJ2eeModule.class));
                        if (null != tmpproj) {
                            ArrayList<FileObject> roots = new ArrayList<FileObject>();
                            FileObject cpe = tmpproj.getProjectDirectory().getFileObject("src/java");
                            if (null != cpe) {
                                roots.add(cpe);
                            }
                            if (null != (cpe = tmpproj.getProjectDirectory().getFileObject("src/conf"))) {
                                roots.add(cpe);
                            }
                            if (null != (cpe = tmpproj.getProjectDirectory().getFileObject("web/WEB-INF/classes"))) {
                                roots.add(cpe);
                            }
                            if (roots.size() > 0) {
                                ClassPath cp = ClassPathSupport.createClassPath((FileObject[])roots.toArray(new FileObject[roots.size()]));
                                ClassPath[] aofcp = new ClassPath[]{cp};
                                GlobalPathRegistry.getDefault().register("classpath/source", aofcp);
                                GlobalPathRegistry.getDefault().register("classpath/compile", aofcp);
                                OpenCloseHook.this.paths.add(aofcp);
                            }
                            J2eeModuleProvider jmp = (J2eeModuleProvider)tmpproj.getLookup().lookup(J2eeModuleProvider.class);
                            jmp.getConfigSupport().ensureConfigurationReady();
                            tmp.setInner(jmp);
                        } else {
                            Object mt = isEar ? J2eeModule.EAR : J2eeModule.CONN;
                            tmp.setJ2eeModule(new J2eeModuleForAddModuleAction(mt));
                            tmp.setServerInstanceID((String)app.get("j2ee.server.instance"));
                            if (isEar) {
                                tmp.getConfigSupport().ensureConfigurationReady();
                            }
                        }
                    }
                    if (!isEar) {
                        return null;
                    }
                    FileObject appXml = ArchiveProject.this.getProjectDirectory().getFileObject("nbproject").getFileObject("application.xml");
                    if (null != appXml) {
                        try {
                            Module[] ms;
                            Application appDD = DDProvider.getDefault().getDDRoot(appXml);
                            for (Module m : ms = appDD.getModule()) {
                                String archivePath = m.getEjb();
                                if (null != archivePath) {
                                    OpenCloseHook.this.openSubarchiveProject(archivePath);
                                    continue;
                                }
                                archivePath = m.getJava();
                                if (null != archivePath) {
                                    OpenCloseHook.this.openSubarchiveProject(archivePath);
                                    continue;
                                }
                                archivePath = m.getConnector();
                                if (null != archivePath) {
                                    OpenCloseHook.this.openSubarchiveProject(archivePath);
                                    continue;
                                }
                                Web w = m.getWeb();
                                if (null == w || null == (archivePath = w.getWebUri())) continue;
                                OpenCloseHook.this.openSubarchiveProject(archivePath);
                            }
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().log(1, "" + ex);
                        }
                    } else {
                        ErrorManager.getDefault().log(16, NbBundle.getMessage(ArchiveProject.class, (String)"WARN_EAR_ARCH_MISSING_APPLICATION_XML", (Object)ArchiveProject.this.getName()));
                    }
                    return null;
                }
            });
        }

        private void openSubarchiveProject(String pathInEar) throws IOException {
            block11: {
                FileObject root = ArchiveProject.this.getProjectDirectory();
                FileObject subprojRoot = root.getFileObject("subarchives");
                String subprojkey = Util.getKey(pathInEar);
                try {
                    FileObject projDest = subprojRoot.getFileObject(subprojkey);
                    ArchiveProject.this.nameMap.put(subprojkey, pathInEar);
                    FileObject fo = projDest.getFileObject("tmpproj");
                    Project tmpproj = ProjectManager.getDefault().findProject(fo);
                    Project subproj = ProjectManager.getDefault().findProject(projDest);
                    MyOpenHook eh = (MyOpenHook)subproj.getLookup().lookup(MyOpenHook.class);
                    eh.regenerateBuildFiles();
                    ProvidesJ2eeModule tmp = (ProvidesJ2eeModule)((Object)subproj.getLookup().lookup(ProvidesJ2eeModule.class));
                    if (null != tmpproj) {
                        J2eeModuleProvider jmp = (J2eeModuleProvider)tmpproj.getLookup().lookup(J2eeModuleProvider.class);
                        ArrayList<FileObject> roots = new ArrayList<FileObject>();
                        FileObject cpe = tmpproj.getProjectDirectory().getFileObject("src/java");
                        if (null != cpe) {
                            roots.add(cpe);
                        }
                        if (null != (cpe = tmpproj.getProjectDirectory().getFileObject("src/conf"))) {
                            roots.add(cpe);
                        }
                        if (null != (cpe = tmpproj.getProjectDirectory().getFileObject("web/WEB-INF/classes"))) {
                            roots.add(cpe);
                        }
                        if (roots.size() > 0) {
                            ClassPath cp = ClassPathSupport.createClassPath((FileObject[])roots.toArray(new FileObject[roots.size()]));
                            ClassPath[] aofcp = new ClassPath[]{cp};
                            GlobalPathRegistry.getDefault().register("classpath/source", aofcp);
                            GlobalPathRegistry.getDefault().register("classpath/compile", aofcp);
                            this.paths.add(aofcp);
                        }
                        try {
                            jmp.getConfigSupport().ensureConfigurationReady();
                        }
                        catch (IllegalArgumentException iae) {
                            FileObject tfo = tmpproj.getProjectDirectory();
                            if (null != tfo) {
                                ErrorManager.getDefault().log(1, tmpproj.getProjectDirectory().toString());
                            } else {
                                ErrorManager.getDefault().log(1, "null");
                            }
                            throw iae;
                        }
                        tmp.setInner(jmp);
                        break block11;
                    }
                    Object mt = J2eeModule.CONN;
                    tmp.setJ2eeModule(new J2eeModuleForAddModuleAction(mt));
                    tmp.setServerInstanceID((String)ArchiveProject.this.getArchiveProjectProperties().get("j2ee.server.instance"));
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().log(1, "" + ex);
                }
            }
        }

        protected void projectClosed() {
            ArrayList<ClassPath[]> tmplist = new ArrayList<ClassPath[]>();
            for (ClassPath[] aofcp : this.paths) {
                GlobalPathRegistry.getDefault().unregister("classpath/source", aofcp);
                GlobalPathRegistry.getDefault().unregister("classpath/compile", aofcp);
                tmplist.add(aofcp);
            }
            for (ClassPath[] aofcp : tmplist) {
                this.paths.remove(aofcp);
            }
        }
    }

    private final class MyAntProvider
    implements AntArtifactProvider {
        private MyAntProvider() {
        }

        public AntArtifact[] getBuildArtifacts() {
            return new AntArtifact[]{ArchiveProject.this.helper.createSimpleAntArtifact("j2ee_ear_archive", "dist.archive", ArchiveProject.this.helper.getStandardPropertyEvaluator(), "dist", "clean")};
        }
    }

    private final class Info
    implements ProjectInformation {
        private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        private Info() {
        }

        public String getName() {
            return ArchiveProject.this.getNamedProjectAttribute(ArchiveProject.NAME_LIT);
        }

        public String getDisplayName() {
            return ArchiveProject.this.getNamedProjectAttribute(ArchiveProject.NAME_LIT);
        }

        public Icon getIcon() {
            return ARCHIVE_PROJECT_ICON;
        }

        public Project getProject() {
            return ArchiveProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    private final class HelpfulLookup
    extends Lookup {
        private boolean verbose = Boolean.getBoolean("archiveproject.lookup.verbose");
        Lookup inner = Lookups.fixed((Object[])new Object[]{new Info(), ArchiveProject.access$100(ArchiveProject.this).createAuxiliaryConfiguration(), ArchiveProject.access$100(ArchiveProject.this).createCacheDirectoryProvider(), ArchiveProject.access$100(ArchiveProject.this).createGlobFileBuiltQuery(ArchiveProject.access$400(ArchiveProject.this), new String[]{"${src.dir}/*.java"}, new String[]{"${build.classes.dir}/*.class"}), ArchiveProject.access$100(ArchiveProject.this).createSharabilityQuery(ArchiveProject.access$400(ArchiveProject.this), new String[]{"${src.dir}"}, new String[]{"${build.dir}", "${dist.dir}", "${proxy.project.dir}"}), new OpenCloseHook(), new ProvidesAction(ArchiveProject.this), new ProvidesLogicalView(ArchiveProject.this), ArchiveProject.access$100(ArchiveProject.this), new ProvidesJ2eeModule(ArchiveProject.access$100(ArchiveProject.this), ArchiveProject.this), new J2eeModuleForAddModuleAction(J2eeModule.EAR), new MyAntProvider(), new ProvidesCustomizer(ArchiveProject.this, ArchiveProject.access$100(ArchiveProject.this)), new RecommendedTemplatesImpl(), new ArchiveProjectOperations(ArchiveProject.this), ArchiveProject.this, new MyOpenHook(), new ProjectXmlSaved()});

        private HelpfulLookup() {
        }

        public Object lookup(Class clazz) {
            Object ret = this.inner.lookup(clazz);
            if (this.verbose && null == ret && ErrorManager.getDefault().isNotifiable(4096)) {
                StackTraceElement[] sTEs = Thread.currentThread().getStackTrace();
                ErrorManager.getDefault().log(4096, NbBundle.getMessage(ArchiveProject.class, (String)"LOOKUP_MISS", (Object)clazz.getName(), (Object)sTEs[3], (Object)sTEs[4]));
            }
            return ret;
        }

        public Lookup.Result lookup(Lookup.Template template) {
            Lookup.Result ret = this.inner.lookup(template);
            if (this.verbose && null == ret && ErrorManager.getDefault().isNotifiable(4096)) {
                StackTraceElement[] sTEs = Thread.currentThread().getStackTrace();
                ErrorManager.getDefault().log(4096, NbBundle.getMessage(ArchiveProject.class, (String)"LOOKUP_MISS", (Object)template.toString(), (Object)sTEs[3], (Object)sTEs[4]));
            }
            return ret;
        }
    }
}

