/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.archive.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.archive.ui.JavaEePlatformUiSupport;
import org.netbeans.modules.j2ee.archive.wizard.DeployableWizardPanel;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerManager;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

class DeployablePanelVisual
extends JPanel
implements DocumentListener,
ActionListener {
    private transient DeployableWizardPanel panel;
    private static File savedArchiveLoc = null;
    private JTextField archiveFileField;
    private JLabel archiveFileLabel;
    private JButton archiveLocationButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JButton manageServersButton;
    private JButton projectLocationButton;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JComboBox serverInstanceComboBox;
    private JLabel targetServerLabel;
    private static final String WP_eM = "WizardPanel_errorMessage";
    private static final ResourceBundle bundle = NbBundle.getBundle(DeployablePanelVisual.class);

    public DeployablePanelVisual(DeployableWizardPanel panel) {
        this.initComponents();
        this.panel = panel;
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
        this.archiveFileField.getDocument().addDocumentListener(this);
        this.serverInstanceComboBox.addActionListener(this);
    }

    public String getProjectName() {
        return this.projectNameTextField.getText();
    }

    private String validFreeProjectName(File parentFolder, String formater, int index) {
        String name = MessageFormat.format(formater, new Integer(index));
        File file = new File(parentFolder, name);
        return file.exists() ? null : name;
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.projectLocationButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.archiveFileLabel = new JLabel();
        this.archiveFileField = new JTextField();
        this.archiveLocationButton = new JButton();
        this.targetServerLabel = new JLabel();
        this.serverInstanceComboBox = new JComboBox();
        this.manageServersButton = new JButton();
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/j2ee/archive/wizard/Bundle").getString("projectName_TEXT"));
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/j2ee/archive/wizard/Bundle").getString("projectLocation_TEXT"));
        Mnemonics.setLocalizedText((AbstractButton)this.projectLocationButton, (String)ResourceBundle.getBundle("org/netbeans/modules/j2ee/archive/wizard/Bundle").getString("browse_TEXT"));
        this.projectLocationButton.setActionCommand(ResourceBundle.getBundle("org/netbeans/modules/j2ee/archive/wizard/Bundle").getString("BROWSE"));
        this.projectLocationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DeployablePanelVisual.this.projectLocationButtonActionPerformed(evt);
            }
        });
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/j2ee/archive/wizard/Bundle").getString("projectFolder_TEXT"));
        this.createdFolderTextField.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.archiveFileLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/j2ee/archive/wizard/Bundle").getString("archiveFileLabel_TEXT"));
        Mnemonics.setLocalizedText((AbstractButton)this.archiveLocationButton, (String)ResourceBundle.getBundle("org/netbeans/modules/j2ee/archive/wizard/Bundle").getString("browse_TEXT"));
        this.archiveLocationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DeployablePanelVisual.this.archiveLocationButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.targetServerLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/j2ee/archive/wizard/Bundle").getString("targetServerLabel_TEXT"));
        this.serverInstanceComboBox.setModel(JavaEePlatformUiSupport.createPlatformComboBoxModel(null));
        Mnemonics.setLocalizedText((AbstractButton)this.manageServersButton, (String)ResourceBundle.getBundle("org/netbeans/modules/j2ee/archive/wizard/Bundle").getString("LBL_ManageServers"));
        this.manageServersButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DeployablePanelVisual.this.manageServersButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.projectNameLabel).add((Component)this.projectLocationLabel, -1, 106, Short.MAX_VALUE).add((Component)this.createdFolderLabel).add((Component)this.archiveFileLabel)).addPreferredGap(0)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.targetServerLabel).add(33, 33, 33))).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.serverInstanceComboBox, 0, 195, Short.MAX_VALUE).add((Component)this.createdFolderTextField, -1, 195, Short.MAX_VALUE).add(2, (Component)this.projectNameTextField, -1, 195, Short.MAX_VALUE).add((Component)this.projectLocationTextField, -1, 195, Short.MAX_VALUE).add(2, (Component)this.archiveFileField, -1, 195, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.projectLocationButton).add((Component)this.archiveLocationButton).add((Component)this.manageServersButton)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.projectNameLabel).add((Component)this.projectNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.projectLocationLabel).add((Component)this.projectLocationTextField, -2, -1, -2).add((Component)this.projectLocationButton)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.createdFolderLabel).add((Component)this.createdFolderTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.archiveFileLabel).add((Component)this.archiveFileField, -2, -1, -2).add((Component)this.archiveLocationButton)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.targetServerLabel).add((Component)this.serverInstanceComboBox, -2, -1, -2).add((Component)this.manageServersButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void manageServersButtonActionPerformed(ActionEvent evt) {
        Object serverInstanceWrapper = this.serverInstanceComboBox.getSelectedItem();
        String lastSelectedServerInstanceID = null;
        if (serverInstanceWrapper != null) {
            lastSelectedServerInstanceID = JavaEePlatformUiSupport.getServerInstanceID(serverInstanceWrapper);
        }
        ServerManager.showCustomizer(lastSelectedServerInstanceID);
        this.serverInstanceComboBox.setModel(JavaEePlatformUiSupport.createPlatformComboBoxModel(lastSelectedServerInstanceID));
    }

    private void archiveLocationButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setDialogTitle(NbBundle.getMessage(DeployablePanelVisual.class, (String)"DLG_TITLE_ArchiveChooser"));
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String path = f.getAbsolutePath();
                return DeployablePanelVisual.this.acceptableArchive(path);
            }

            public String getDescription() {
                return NbBundle.getMessage(DeployablePanelVisual.class, (String)"ARCHIVE_CHOOSER_DESCRIPTOR");
            }
        });
        String path = this.archiveFileField.getText();
        if (path.length() > 0) {
            File f = new File(path);
            if (f.exists()) {
                chooser.setSelectedFile(f);
            }
        } else if (savedArchiveLoc != null) {
            chooser.setCurrentDirectory(savedArchiveLoc);
        }
        if (0 == chooser.showOpenDialog(this)) {
            File projectDir = chooser.getSelectedFile();
            this.archiveFileField.setText(FileUtil.normalizeFile((File)projectDir).getAbsolutePath());
            savedArchiveLoc = projectDir.getParentFile();
        }
        this.panel.fireChangeEvent();
    }

    private void projectLocationButtonActionPerformed(ActionEvent evt) {
        File f;
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setDialogTitle(NbBundle.getMessage(DeployablePanelVisual.class, (String)"DLG_TITLE_FolderChooser"));
        chooser.setFileSelectionMode(1);
        String path = this.projectLocationTextField.getText();
        if (path.length() > 0 && (f = new File(path)).exists()) {
            chooser.setSelectedFile(f);
        }
        if (0 == chooser.showOpenDialog(this)) {
            File projectDir = chooser.getSelectedFile();
            this.projectLocationTextField.setText(FileUtil.normalizeFile((File)projectDir).getAbsolutePath());
        }
        this.panel.fireChangeEvent();
    }

    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        File destFolder;
        File projLoc;
        if (this.projectNameTextField.getText().length() == 0) {
            wizardDescriptor.putProperty(WP_eM, (Object)bundle.getString("ERR_valid_folder_name"));
            return false;
        }
        File f = FileUtil.normalizeFile((File)new File(this.projectLocationTextField.getText()).getAbsoluteFile());
        if (!f.isDirectory()) {
            String message = bundle.getString("ERR_valid_path");
            wizardDescriptor.putProperty(WP_eM, (Object)message);
            return false;
        }
        for (projLoc = destFolder = FileUtil.normalizeFile((File)new File(this.createdFolderTextField.getText()).getAbsoluteFile()); projLoc != null && !projLoc.exists(); projLoc = projLoc.getParentFile()) {
        }
        if (projLoc == null || !projLoc.canWrite()) {
            wizardDescriptor.putProperty(WP_eM, (Object)bundle.getString("ERR_cannot_write_folder"));
            return false;
        }
        if (FileUtil.toFileObject((File)projLoc) == null) {
            String message = bundle.getString("ERR_valid_path");
            wizardDescriptor.putProperty(WP_eM, (Object)message);
            return false;
        }
        File[] kids = destFolder.listFiles();
        if (destFolder.exists() && kids != null && kids.length > 0) {
            wizardDescriptor.putProperty(WP_eM, (Object)bundle.getString("ERR_folder_not_empty"));
            return false;
        }
        f = FileUtil.normalizeFile((File)new File(this.archiveFileField.getText()).getAbsoluteFile());
        if (!(f.exists() && f.isFile() && f.canRead())) {
            String message = bundle.getString("ERR_invalid_archive");
            wizardDescriptor.putProperty(WP_eM, (Object)message);
            return false;
        }
        if (this.serverInstanceComboBox.getItemCount() == 0) {
            String message = bundle.getString("ERR_no_possible_target");
            wizardDescriptor.putProperty(WP_eM, (Object)message);
            return false;
        }
        if (this.serverInstanceComboBox.getSelectedItem() == null) {
            String message = bundle.getString("ERR_no_target");
            wizardDescriptor.putProperty(WP_eM, (Object)message);
            return false;
        }
        if (!this.acceptableArchive(f.getAbsoluteFile().getAbsolutePath(), wizardDescriptor)) {
            String message = bundle.getString("ERR_unsupported_archive");
            wizardDescriptor.putProperty(WP_eM, (Object)message);
            return false;
        }
        wizardDescriptor.putProperty(WP_eM, (Object)"");
        return true;
    }

    boolean acceptableArchive(String aPath, WizardDescriptor d) {
        boolean retVal = false;
        if (aPath.endsWith("war")) {
            d.putProperty("type", (Object)"war");
            retVal = true;
        }
        if (aPath.endsWith("car")) {
            d.putProperty("type", (Object)"car");
            retVal = true;
        }
        if (aPath.endsWith("rar")) {
            d.putProperty("type", (Object)"rar");
            retVal = true;
        }
        if (aPath.endsWith("ear")) {
            d.putProperty("type", (Object)"ear");
            retVal = true;
        }
        if (aPath.endsWith("jar")) {
            d.putProperty("type", (Object)"unknown");
            retVal = true;
        }
        return retVal;
    }

    void store(WizardDescriptor d) {
        String name = this.projectNameTextField.getText().trim();
        String folder = this.createdFolderTextField.getText().trim();
        d.putProperty("projdir", (Object)new File(folder));
        d.putProperty("name", (Object)name);
        d.putProperty("targetServer", this.serverInstanceComboBox.getSelectedItem());
        d.putProperty("sourceArchive", (Object)new File(this.archiveFileField.getText().trim()));
    }

    void read(WizardDescriptor settings) {
        File projectLocation = (File)settings.getProperty("projdir");
        projectLocation = projectLocation == null || projectLocation.getParentFile() == null || !projectLocation.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : projectLocation.getParentFile();
        this.projectLocationTextField.setText(projectLocation.getAbsolutePath());
        String projectName = (String)settings.getProperty("name");
        if (projectName == null) {
            int baseCount = 0;
            String formater = bundle.getString("TXT_DefaultProjectName");
            while ((projectName = this.validFreeProjectName(projectLocation, formater, baseCount)) == null) {
                ++baseCount;
            }
        }
        this.projectNameTextField.setText(projectName);
        this.projectNameTextField.selectAll();
    }

    void validate(WizardDescriptor d) throws WizardValidationException {
    }

    public void changedUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange("name", null, this.projectNameTextField.getText());
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange("name", null, this.projectNameTextField.getText());
        }
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange("name", null, this.projectNameTextField.getText());
        }
    }

    private void updateTexts(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.projectNameTextField.getDocument() || doc == this.projectLocationTextField.getDocument()) {
            String projectName = this.projectNameTextField.getText();
            String projectFolder = this.projectLocationTextField.getText();
            this.createdFolderTextField.setText(projectFolder + File.separatorChar + projectName);
        }
        this.panel.fireChangeEvent();
    }

    public void actionPerformed(ActionEvent e) {
        this.panel.fireChangeEvent();
    }

    private boolean acceptableArchive(String aPath) {
        boolean retVal = false;
        if (aPath.endsWith("war")) {
            retVal = true;
        }
        if (aPath.endsWith("car")) {
            retVal = true;
        }
        if (aPath.endsWith("ear")) {
            retVal = true;
        }
        if (aPath.endsWith("jar")) {
            retVal = true;
        }
        if (aPath.endsWith("rar")) {
            retVal = true;
        }
        return retVal;
    }
}

