/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.services;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.services.NbDialog;
import org.netbeans.core.windows.services.NbPresenter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Mutex;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DialogDisplayerImpl
extends DialogDisplayer {
    private Object testResult;

    public DialogDisplayerImpl() {
        this(null);
    }

    DialogDisplayerImpl(Object testResult) {
        this.testResult = testResult;
    }

    public Dialog createDialog(final DialogDescriptor d) {
        return (Dialog)Mutex.EVENT.readAccess(new Mutex.Action(){

            public Object run() {
                if (NbPresenter.currentModalDialog != null) {
                    if (NbPresenter.currentModalDialog.isLeaf()) {
                        return new NbDialog(d, WindowManager.getDefault().getMainWindow());
                    }
                    return new NbDialog(d, NbPresenter.currentModalDialog);
                }
                Window w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                if (!(w instanceof NbPresenter)) {
                    w = WindowManager.getDefault().getMainWindow();
                } else if (w instanceof NbPresenter && ((NbPresenter)w).isLeaf()) {
                    w = WindowManager.getDefault().getMainWindow();
                }
                if (w instanceof Dialog) {
                    NbDialog dlg = new NbDialog(d, (Dialog)w);
                    dlg.requestFocusInWindow();
                    return dlg;
                }
                Frame f = w instanceof Frame ? (Frame)w : WindowManager.getDefault().getMainWindow();
                NbDialog dlg = new NbDialog(d, f);
                dlg.requestFocusInWindow();
                return dlg;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object notify(NotifyDescriptor descriptor) {
        class AWTQuery
        implements Runnable {
            public Object result;
            public boolean running;
            private final /* synthetic */ NotifyDescriptor val$descriptor;

            AWTQuery(NotifyDescriptor notifyDescriptor) {
                this.val$descriptor = notifyDescriptor;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AWTQuery aWTQuery = this;
                synchronized (aWTQuery) {
                    this.notify();
                    this.running = true;
                }
                this.showDialog();
                aWTQuery = this;
                synchronized (aWTQuery) {
                    this.result = this.val$descriptor.getValue();
                    this.notifyAll();
                }
            }

            public void showDialog() {
                Object win;
                if (DialogDisplayerImpl.this.testResult != null) {
                    this.val$descriptor.setValue(DialogDisplayerImpl.this.testResult);
                    return;
                }
                Component focusOwner = null;
                TopComponent comp = TopComponent.getRegistry().getActivated();
                for (win = comp; win != null && !(win instanceof Window); win = ((Component)win).getParent()) {
                }
                if (win != null) {
                    focusOwner = ((Window)win).getFocusOwner();
                }
                NbPresenter presenter = null;
                if (this.val$descriptor instanceof DialogDescriptor) {
                    if (NbPresenter.currentModalDialog != null) {
                        presenter = NbPresenter.currentModalDialog.isLeaf() ? new NbDialog((DialogDescriptor)this.val$descriptor, WindowManager.getDefault().getMainWindow()) : new NbDialog((DialogDescriptor)this.val$descriptor, NbPresenter.currentModalDialog);
                    } else {
                        Window w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                        if (w instanceof NbPresenter && ((NbPresenter)w).isLeaf()) {
                            w = WindowManager.getDefault().getMainWindow();
                        }
                        Frame f = w instanceof Frame ? (Frame)w : WindowManager.getDefault().getMainWindow();
                        presenter = new NbDialog((DialogDescriptor)this.val$descriptor, f);
                    }
                } else if (NbPresenter.currentModalDialog != null) {
                    presenter = new NbPresenter(this.val$descriptor, NbPresenter.currentModalDialog, true);
                } else {
                    Frame f = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() instanceof Frame ? (Frame)KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() : WindowManager.getDefault().getMainWindow();
                    presenter = new NbPresenter(this.val$descriptor, f, true);
                }
                if ("true".equals(System.getProperty("javahelp.ignore.modality"))) {
                    presenter.getRootPane().putClientProperty("javahelp.ignore.modality", "true");
                    System.setProperty("javahelp.ignore.modality", "false");
                }
                presenter.getRootPane().requestDefaultFocus();
                presenter.setVisible(true);
                if (focusOwner != null) {
                    ((Component)win).requestFocus();
                    comp.requestFocus();
                    focusOwner.requestFocus();
                }
            }
        }
        AWTQuery query = new AWTQuery(descriptor);
        if (SwingUtilities.isEventDispatchThread()) {
            query.showDialog();
            return descriptor.getValue();
        }
        AWTQuery aWTQuery = query;
        synchronized (aWTQuery) {
            SwingUtilities.invokeLater(query);
            try {
                query.wait(10000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (query.running) {
                while (query.result == null) {
                    try {
                        query.wait();
                    }
                    catch (InterruptedException ex) {}
                }
                return query.result;
            }
            return NotifyDescriptor.CLOSED_OPTION;
        }
    }
}

