/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.slides;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.core.windows.view.ui.slides.ResizeGestureRecognizer;
import org.netbeans.core.windows.view.ui.slides.SlideBar;
import org.netbeans.core.windows.view.ui.slides.SlideBarActionEvent;
import org.netbeans.core.windows.view.ui.slides.SlideOperation;
import org.netbeans.core.windows.view.ui.slides.SlideOperationFactory;
import org.netbeans.core.windows.view.ui.slides.TabbedSlideAdapter;
import org.netbeans.swing.tabcontrol.DefaultTabDataModel;
import org.netbeans.swing.tabcontrol.LocationInformer;
import org.netbeans.swing.tabcontrol.SlideBarDataModel;
import org.netbeans.swing.tabcontrol.SlidingButton;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabbedContainer;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

final class CommandManager
implements ActionListener {
    private final SlideBar slideBar;
    private TabbedContainer slidedTabContainer;
    private Component curSlidedComp;
    private SlidingButton curSlideButton;
    private int curSlideOrientation;
    private int curSlidedIndex;
    private ResizeGestureRecognizer recog;
    private static final boolean NO_POPUP_PLACEMENT_HACK = Boolean.getBoolean("netbeans.popup.no_hack");
    private final Action escapeAction = new EscapeAction();

    public CommandManager(SlideBar slideBar) {
        this.slideBar = slideBar;
        this.recog = new ResizeGestureRecognizer(this);
    }

    ResizeGestureRecognizer getResizer() {
        return this.recog;
    }

    public void slideResize(int delta) {
        if (!this.isCompSlided()) {
            return;
        }
        SlideOperation op = SlideOperationFactory.createSlideResize((Component)this.getSlidedTabContainer(), this.curSlideOrientation);
        Rectangle finish = this.getSlidedTabContainer().getBounds(null);
        String side = CommandManager.orientation2Side(this.curSlideOrientation);
        if ("bottom".equals(side)) {
            finish.height -= delta;
            finish.y += delta;
        }
        if ("right".equals(side)) {
            finish.width -= delta;
            finish.x += delta;
        }
        if ("left".equals(side)) {
            finish.width += delta;
        }
        op.setFinishBounds(finish);
        this.postEvent(new SlideBarActionEvent((Object)this.slideBar, "slideResize", op));
    }

    public void slideIn(int tabIndex) {
        SlideBarDataModel model = this.slideBar.getModel();
        if (this.isCompSlided() && this.curSlidedComp != model.getTab(tabIndex).getComponent()) {
            this.slideOut(false, false);
        }
        this.curSlidedIndex = tabIndex;
        this.curSlidedComp = model.getTab(tabIndex).getComponent();
        this.curSlideOrientation = model.getOrientation();
        this.curSlideButton = this.slideBar.getButton(tabIndex);
        TabbedContainer cont = this.updateSlidedTabContainer(tabIndex);
        SlideOperation operation = SlideOperationFactory.createSlideIn((Component)cont, this.curSlideOrientation, true, true);
        this.curSlideButton.setSelected(true);
        this.postEvent(new SlideBarActionEvent((Object)this.slideBar, "slideIn", operation));
        this.recog.attachResizeRecognizer(CommandManager.orientation2Side(this.curSlideOrientation), (Component)cont);
    }

    public void slideOut(boolean requestsActivation, boolean useEffect) {
        if (!this.isCompSlided()) {
            return;
        }
        SlideOperation operation = SlideOperationFactory.createSlideOut((Component)this.getSlidedTabContainer(), this.curSlideOrientation, useEffect, requestsActivation);
        this.curSlideButton.setSelected(false);
        this.recog.detachResizeRecognizer(CommandManager.orientation2Side(this.curSlideOrientation), (Component)this.getSlidedTabContainer());
        this.curSlidedComp = null;
        this.curSlideButton = null;
        this.curSlideOrientation = -1;
        this.curSlidedIndex = -1;
        this.postEvent(new SlideBarActionEvent((Object)this.slideBar, "slideOut", operation));
    }

    public void slideIntoDesktop(int tabIndex, boolean useEffect) {
        SlideOperation operation = null;
        if (this.isCompSlided()) {
            operation = SlideOperationFactory.createSlideIntoDesktop((Component)this.getSlidedTabContainer(), this.curSlideOrientation, useEffect);
        }
        this.recog.detachResizeRecognizer(CommandManager.orientation2Side(this.curSlideOrientation), (Component)this.getSlidedTabContainer());
        this.postEvent(new SlideBarActionEvent((Object)this.slideBar, "disableAutoHide", operation, null, tabIndex));
    }

    public void showPopup(MouseEvent mouseEvent, int tabIndex) {
        this.postEvent(new SlideBarActionEvent((Object)this.slideBar, "popup", mouseEvent, tabIndex));
    }

    protected static String orientation2Side(int orientation) {
        String side = "left";
        if (orientation == 2) {
            side = "left";
        } else if (orientation == 1) {
            side = "right";
        } else if (orientation == 3) {
            side = "bottom";
        }
        return side;
    }

    public void setActive(boolean active) {
        this.getSlidedTabContainer().setActive(active);
    }

    public void actionPerformed(ActionEvent e) {
        if ("popup".equals(e.getActionCommand())) {
            TabActionEvent tae = (TabActionEvent)e;
            if (this.curSlidedComp != null && this.curSlidedComp instanceof TopComponent) {
                TopComponent tc = (TopComponent)this.curSlidedComp;
                Action[] actions = this.slideBar.getTabbed().getPopupActions(tc.getActions(), this.curSlidedIndex);
                if (actions == null) {
                    actions = tc.getActions();
                }
                CommandManager.showPopupMenu(Utilities.actionsToPopup((Action[])actions, (Lookup)tc.getLookup()), tae.getMouseEvent().getPoint(), tae.getMouseEvent().getComponent());
            }
        } else if ("disableAutoHide".equals(e.getActionCommand())) {
            this.slideIntoDesktop(this.curSlidedIndex, true);
        } else {
            TabActionEvent tae = (TabActionEvent)e;
            TabActionEvent newEvt = new TabActionEvent(tae.getSource(), tae.getActionCommand(), this.curSlidedIndex, tae.getMouseEvent());
            this.postEvent((ActionEvent)newEvt);
        }
    }

    private Rectangle getScreenCompRect(Component comp) {
        Rectangle result = new Rectangle(comp.getLocationOnScreen(), comp.getSize());
        return result;
    }

    private static void showPopupMenu(JPopupMenu popup, Point p, Component comp) {
        if (NO_POPUP_PLACEMENT_HACK) {
            popup.show(comp, p.x, p.y);
            return;
        }
        SwingUtilities.convertPointToScreen(p, comp);
        Dimension popupSize = popup.getPreferredSize();
        Rectangle screenBounds = Utilities.getUsableScreenBounds((GraphicsConfiguration)comp.getGraphicsConfiguration());
        if (p.x + popupSize.width > screenBounds.x + screenBounds.width) {
            p.x = screenBounds.x + screenBounds.width - popupSize.width;
        }
        if (p.y + popupSize.height > screenBounds.y + screenBounds.height) {
            p.y = screenBounds.y + screenBounds.height - popupSize.height;
        }
        SwingUtilities.convertPointFromScreen(p, comp);
        popup.show(comp, p.x, p.y);
    }

    private TabbedContainer getSlidedTabContainer() {
        if (this.slidedTabContainer == null) {
            DefaultTabDataModel slidedCompModel = new DefaultTabDataModel();
            this.slidedTabContainer = new TabbedContainer((TabDataModel)slidedCompModel, 0, (LocationInformer)this.slideBar);
            this.slidedTabContainer.addActionListener((ActionListener)this);
            Border b = (Border)UIManager.get("floatingBorder");
            if (b != null) {
                this.slidedTabContainer.setBorder(b);
            }
            this.registerEscHandler((JComponent)this.slidedTabContainer);
        }
        return this.slidedTabContainer;
    }

    private TabbedContainer updateSlidedTabContainer(int tabIndex) {
        TabbedContainer container = this.getSlidedTabContainer();
        TabDataModel containerModel = container.getModel();
        SlideBarDataModel dataModel = this.slideBar.getModel();
        TabData origTab = dataModel.getTab(tabIndex);
        TabData newTab = new TabData(origTab.getUserObject(), origTab.getIcon(), new String(origTab.getText()), origTab.getTooltip());
        if (containerModel.size() == 0) {
            containerModel.addTab(0, newTab);
        } else {
            containerModel.setTab(0, newTab);
        }
        container.getSelectionModel().setSelectedIndex(0);
        return container;
    }

    private void registerEscHandler(JComponent comp) {
        comp.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "slideOut");
        comp.getActionMap().put("slideOut", this.escapeAction);
    }

    boolean isCompSlided() {
        return this.curSlidedComp != null;
    }

    Component getSlidedComp() {
        if (!this.isCompSlided()) {
            return null;
        }
        return this.slidedTabContainer;
    }

    void syncWithModel() {
        if (this.curSlidedComp == null) {
            return;
        }
        if (!this.slideBar.containsComp(this.curSlidedComp)) {
            this.slideOut(false, false);
        } else {
            SlideBarDataModel model = this.slideBar.getModel();
            if (this.curSlidedIndex < model.size()) {
                String freshText = model.getTab(this.curSlidedIndex).getText();
                TabDataModel slidedModel = this.getSlidedTabContainer().getModel();
                String slidedText = slidedModel.getTab(0).getText();
                if (slidedText == null || !slidedText.equals(freshText)) {
                    slidedModel.setText(0, freshText);
                    this.slideBar.repaint();
                }
            }
        }
    }

    private void postEvent(ActionEvent evt) {
        ((TabbedSlideAdapter)this.slideBar.getTabbed()).postActionEvent(evt);
    }

    private final class EscapeAction
    extends AbstractAction {
        private EscapeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            CommandManager.this.slideOut(true, true);
        }
    }
}

