/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.ext.html.HTMLSyntax;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.netbeans.modules.html.HtmlDataObject;
import org.netbeans.modules.html.palette.HTMLPaletteFactory;
import org.netbeans.spi.palette.PaletteController;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.CloneableOpenSupport;

public final class HtmlEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
PrintCookie {
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            HtmlEditorSupport.this.saveDocument();
            HtmlEditorSupport.this.getDataObject().setModified(false);
        }
    };

    HtmlEditorSupport(HtmlDataObject obj) {
        super((DataObject)obj, (CloneableEditorSupport.Env)new Environment(obj));
        this.setMIMEType("text/html");
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        this.addSaveCookie();
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.removeSaveCookie();
    }

    private void addSaveCookie() {
        HtmlDataObject obj = (HtmlDataObject)this.getDataObject();
        if (obj.getCookie(SaveCookie.class) == null) {
            obj.getCookieSet0().add((Node.Cookie)this.saveCookie);
            obj.setModified(true);
        }
    }

    private void removeSaveCookie() {
        HtmlDataObject obj = (HtmlDataObject)this.getDataObject();
        Node.Cookie cookie = obj.getCookie(SaveCookie.class);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            obj.getCookieSet0().remove((Node.Cookie)this.saveCookie);
            obj.setModified(false);
        }
    }

    protected void loadFromStreamToKit(StyledDocument doc, InputStream stream, EditorKit kit) throws IOException, BadLocationException {
        byte[] arr;
        int len = stream.read(arr = new byte[4096], 0, arr.length);
        String txt = new String(arr, 0, len >= 0 ? len : 0).toUpperCase();
        txt = HtmlEditorSupport.findEncoding(txt);
        stream = len < arr.length ? new ByteArrayInputStream(arr, 0, len) : new SequenceInputStream(new ByteArrayInputStream(arr), stream);
        if (txt != null) {
            try {
                InputStreamReader r = new InputStreamReader(stream, txt);
                kit.read(r, (Document)doc, 0);
                return;
            }
            catch (UnsupportedEncodingException ex) {
            }
            catch (Exception ex) {
                ErrorManager.getDefault().annotate((Throwable)ex, NbBundle.getMessage((Class)HtmlEditorSupport.class, (String)"MSG_errorInReadingWithEnc", (Object)this.getDataObject().getPrimaryFile().getPath(), (Object)txt));
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        kit.read(stream, (Document)doc, 0);
    }

    protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
        int len = doc.getLength();
        if (len > 4096) {
            len = 4096;
        }
        String txt = doc.getText(0, len).toUpperCase();
        if ((txt = HtmlEditorSupport.findEncoding(txt)) != null) {
            try {
                OutputStreamWriter w = new OutputStreamWriter(stream, txt);
                kit.write(w, (Document)doc, 0, doc.getLength());
                return;
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
        }
        super.saveFromKitToStream(doc, kit, stream);
    }

    private static String findEncoding(String txt) {
        String CHARSET_DECL = "CHARSET=";
        HTMLSyntax syntax = new HTMLSyntax();
        int headEndOffset = txt.indexOf("</HEAD>");
        if (headEndOffset == -1) {
            return null;
        }
        char[] buffer = txt.toCharArray();
        syntax.load(null, buffer, 0, headEndOffset, false, -1);
        TokenID tokenId = syntax.nextToken();
        while (tokenId != null) {
            if (tokenId == HTMLTokenContext.VALUE) {
                String tokenImage = txt.substring(syntax.getTokenOffset(), syntax.getTokenLength() + syntax.getTokenOffset());
                int charsetOffset = tokenImage.indexOf(CHARSET_DECL);
                int charsetEndOffset = charsetOffset + CHARSET_DECL.length();
                if (charsetOffset != -1) {
                    int endOffset = tokenImage.indexOf(34, charsetEndOffset);
                    if (endOffset == -1) {
                        endOffset = tokenImage.indexOf(39, charsetEndOffset);
                    }
                    if (endOffset == -1) {
                        endOffset = tokenImage.indexOf(59, charsetEndOffset);
                    }
                    if (endOffset == -1) {
                        return null;
                    }
                    String encoding = tokenImage.substring(charsetEndOffset, endOffset);
                    return encoding;
                }
            }
            tokenId = syntax.nextToken();
        }
        return null;
    }

    protected CloneableEditor createCloneableEditor() {
        return new HtmlEditor(this);
    }

    public static class HtmlEditor
    extends CloneableEditor {
        public HtmlEditor() {
        }

        void associatePalette(HtmlEditorSupport s) {
            DataObject dataObject = s.getDataObject();
            if (dataObject instanceof HtmlDataObject) {
                try {
                    PaletteController pc = HTMLPaletteFactory.getPalette();
                    Lookup pcl = Lookups.singleton((Object)pc);
                    Lookup anl = this.getActivatedNodes()[0].getLookup();
                    Lookup actionMap = Lookups.singleton((Object)this.getActionMap());
                    ProxyLookup l = new ProxyLookup(new Lookup[]{anl, actionMap, pcl});
                    this.associateLookup((Lookup)l);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }

        public HtmlEditor(HtmlEditorSupport s) {
            super((CloneableEditorSupport)s);
            this.initialize();
        }

        private void initialize() {
            Node[] nodes = new Node[]{((DataEditorSupport)this.cloneableEditorSupport()).getDataObject().getNodeDelegate()};
            this.setActivatedNodes(nodes);
            this.associatePalette((HtmlEditorSupport)this.cloneableEditorSupport());
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.initialize();
        }
    }

    private static class Environment
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 3035543168452715818L;

        public Environment(HtmlDataObject obj) {
            super((DataObject)obj);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((HtmlDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (HtmlEditorSupport)this.getDataObject().getCookie(class$org$netbeans$modules$html$HtmlEditorSupport == null ? (class$org$netbeans$modules$html$HtmlEditorSupport = HtmlEditorSupport.class$("org.netbeans.modules.html.HtmlEditorSupport")) : class$org$netbeans$modules$html$HtmlEditorSupport);
        }
    }
}

