/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.text.syntax;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.TokenCategory;
import org.netbeans.editor.TokenContext;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.modules.css.actions.CheckStyleAction;
import org.netbeans.modules.css.actions.CopyStyleAction;
import org.netbeans.modules.css.text.syntax.CSSTokenContext;
import org.openide.actions.ToolsAction;
import org.openide.windows.TopComponent;

public class CSSEditorSettings
extends Settings.AbstractInitializer {
    public static final String NAME = "css-settings-initializer";
    static final Font boldFont = SettingsDefaults.defaultFont.deriveFont(1);
    static final Font italicFont = SettingsDefaults.defaultFont.deriveFont(2);

    public CSSEditorSettings() {
        super(NAME);
    }

    public void updateSettingsMap(Class kitClass, Map settingsMap) {
        if (kitClass == null) {
            return;
        }
        if (kitClass == BaseKit.class) {
            new CSSTokenColoringInitializer().updateSettingsMap(kitClass, settingsMap);
        }
        if ("org.netbeans.modules.css.text.syntax.CSSEditorKit".equals(kitClass.getName())) {
            ArrayList<String> cssActionNames = new ArrayList<String>(Arrays.asList(CopyStyleAction.XML.class.getName(), CopyStyleAction.HTML.class.getName(), CheckStyleAction.class.getName(), null, TopComponent.class.getName(), null, "cut-to-clipboard", "copy-to-clipboard", "paste-from-clipboard", null, "remove-selection", null, ToolsAction.class.getName()));
            settingsMap.put("popup-menu-action-name-list", cssActionNames);
            settingsMap.put("abbrev-map", this.getCSSAbbrevMap());
            SettingsUtil.updateListSetting((Map)settingsMap, (String)"token-context-list", (Object[])new TokenContext[]{CSSTokenContext.context});
        }
    }

    private Map getCSSAbbrevMap() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("bg", "background: ");
        map.put("di", "display: ");
        map.put("fs", "font-size: ");
        return map;
    }

    static class CSSTokenColoringInitializer
    extends SettingsUtil.TokenColoringInitializer {
        public CSSTokenColoringInitializer() {
            super((TokenContext)CSSTokenContext.context);
        }

        public Object getTokenColoring(TokenContextPath tokenContextPath, TokenCategory tokenIDOrCategory, boolean printingSet) {
            return new Coloring(null, Color.black, null);
        }
    }
}

