/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnectionConvertor;
import org.netbeans.modules.db.explorer.nodes.RootNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class ConnectionList {
    private static ConnectionList DEFAULT;
    private Lookup.Result result = this.getLookupResult();
    private List listeners = new ArrayList(1);

    public static synchronized ConnectionList getDefault() {
        if (DEFAULT == null) {
            DatabaseConnectionConvertor.importOldConnections();
            RootNode.getOption().save();
            DEFAULT = new ConnectionList();
        }
        return DEFAULT;
    }

    private ConnectionList() {
        this.result.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent e) {
                ConnectionList.this.fireListeners();
            }
        });
    }

    public DatabaseConnection[] getConnections() {
        Collection dbconns = this.result.allInstances();
        return dbconns.toArray(new DatabaseConnection[dbconns.size()]);
    }

    public DatabaseConnection getConnection(DatabaseConnection impl) {
        if (impl == null) {
            throw new NullPointerException();
        }
        DatabaseConnection[] dbconns = this.getConnections();
        for (int i = 0; i < dbconns.length; ++i) {
            if (!impl.equals(dbconns[i])) continue;
            return dbconns[i];
        }
        return null;
    }

    public void add(DatabaseConnection dbconn) throws DatabaseException {
        if (dbconn == null) {
            throw new NullPointerException();
        }
        try {
            DatabaseConnectionConvertor.create(dbconn);
        }
        catch (IOException e) {
            throw new DatabaseException(e);
        }
    }

    public boolean contains(DatabaseConnection dbconn) {
        return this.getConnection(dbconn) != null;
    }

    public void remove(DatabaseConnection dbconn) throws DatabaseException {
        if (dbconn == null) {
            throw new NullPointerException();
        }
        try {
            DatabaseConnectionConvertor.remove(dbconn);
        }
        catch (IOException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireListeners() {
        ArrayList listenersCopy;
        List list = this.listeners;
        synchronized (list) {
            listenersCopy = new ArrayList(this.listeners);
        }
        Iterator i = listenersCopy.iterator();
        while (i.hasNext()) {
            ConnectionListener l = (ConnectionListener)i.next();
            l.connectionsChanged();
        }
    }

    private synchronized Lookup.Result getLookupResult() {
        if (this.result == null) {
            FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("Databases/Connections");
            DataFolder folder = DataFolder.findFolder((FileObject)fo);
            this.result = new FolderLookup((DataObject.Container)folder).getLookup().lookup(new Lookup.Template(DatabaseConnection.class));
        }
        return this.result;
    }
}

