/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.clazz;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.netbeans.modules.clazz.ClassDataObject;
import org.netbeans.modules.clazz.LazySourceChildren;
import org.netbeans.modules.clazz.Util;
import org.openide.ErrorManager;
import org.openide.cookies.SourceCookie;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.src.nodes.SourceChildren;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

abstract class ClassDataNode
extends DataNode
implements Runnable,
PropertyChangeListener {
    static final long serialVersionUID = -1543899241509520203L;
    private static final String PROP_CLASS_NAME = "className";
    private static final String PROP_IS_JAVA_BEAN = "isJavaBean";
    private static final String PROP_IS_APPLET = "isApplet";
    private boolean showDeclaredOnly = true;
    transient boolean iconResolved = false;
    transient String errorMsg;
    transient boolean initialized;
    private static final RequestProcessor iconResolver = new RequestProcessor("clazz icon resolver", 1);

    ClassDataNode(ClassDataObject obj) {
        this(obj, (Children)new LazySourceChildren((DataObject)obj, ClassDataObject.getExplorerFactory()));
    }

    protected ClassDataNode(ClassDataObject obj, Children ch) {
        super((DataObject)obj, ch);
        this.initialize();
    }

    protected SourceChildren getSourceChildren() {
        return (SourceChildren)this.getChildren();
    }

    protected abstract String initialIconBase();

    protected abstract void resolveIcons();

    protected abstract void requestResolveIcon();

    private void initialize() {
        this.setIconBase(this.initialIconBase());
    }

    public Image getIcon(int type) {
        this.ensureIconResolved();
        return super.getIcon(type);
    }

    public Image getOpenedIcon(int type) {
        this.ensureIconResolved();
        return super.getOpenedIcon(type);
    }

    private void ensureIconResolved() {
        if (this.iconResolved) {
            return;
        }
        iconResolver.post(new Runnable(){

            public void run() {
                ClassDataNode.this.requestResolveIcon();
            }
        });
    }

    protected Sheet createSheet() {
        Sheet s = super.createSheet();
        ResourceBundle bundle = NbBundle.getBundle((Class)ClassDataNode.class);
        final ClassDataObject obj = (ClassDataObject)this.getDataObject();
        Sheet.Set ps = s.get("properties");
        ps.put((Node.Property)new PropertySupport.ReadOnly(PROP_CLASS_NAME, String.class, bundle.getString("PROP_className"), bundle.getString("HINT_className")){

            public Object getValue() throws InvocationTargetException {
                return obj.getClassName();
            }
        });
        ps.put((Node.Property)new PropertySupport.ReadOnly("modifiers", String.class, bundle.getString("PROP_modifiers"), bundle.getString("HINT_modifiers")){

            public Object getValue() throws InvocationTargetException {
                String result = null;
                try {
                    result = obj.getModifiers();
                }
                catch (IOException ex) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return result;
            }
        });
        ps.put((Node.Property)new PropertySupport.ReadOnly("superclass", String.class, bundle.getString("PROP_superclass"), bundle.getString("HINT_superclass")){

            public Object getValue() throws InvocationTargetException {
                return obj.getSuperclass();
            }
        });
        ps.put((Node.Property)new PropertySupport.ReadOnly("classOrInterface", Boolean.TYPE, bundle.getString("PROP_isInterface"), bundle.getString("HINT_isInterface")){

            public Object getValue() throws InvocationTargetException {
                return obj.isInterface() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        ps.put((Node.Property)new PropertySupport.ReadOnly(PROP_IS_APPLET, Boolean.TYPE, bundle.getString("PROP_isApplet"), bundle.getString("HINT_isApplet")){

            public Object getValue() throws InvocationTargetException {
                return obj.isApplet() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        ps.put((Node.Property)new PropertySupport.ReadOnly(PROP_IS_JAVA_BEAN, Boolean.TYPE, bundle.getString("PROP_isJavaBean"), bundle.getString("HINT_isJavaBean")){

            public Object getValue() throws InvocationTargetException {
                return obj.isJavaBean() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return s;
    }

    public void run() {
        SourceCookie sc = (SourceCookie)this.getDataObject().getCookie(SourceCookie.class);
        if (sc != null) {
            if (!this.initialized) {
                sc.getSource().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)sc.getSource()));
            }
            this.initialized = true;
        }
        this.resolveIcons();
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if ("status".equals(ev.getPropertyName())) {
            Util.getClassProcessor().post((Runnable)this, 200);
        }
    }

    protected void setErrorToolTip(Exception exc) {
        String errMsg = this.findErrorMessage(exc);
        this.errorMsg = NbBundle.getMessage((Class)ClassDataNode.class, (String)"FMT_ErrorHint", (Object)errMsg);
        this.setShortDescription(this.errorMsg);
    }

    private String findErrorMessage(Throwable t) {
        if (t == null) {
            return null;
        }
        ErrorManager.Annotation[] ann = ErrorManager.getDefault().findAnnotations(t);
        if (ann == null) {
            return t.getLocalizedMessage();
        }
        for (int i = 0; i < ann.length; ++i) {
            String normal = ann[i].getMessage();
            String localized = ann[i].getLocalizedMessage();
            if (localized != null) {
                return localized;
            }
            Throwable t2 = ann[i].getStackTrace();
            if (t2 == null || (localized = t2.getLocalizedMessage()) == null || localized.equals(normal)) continue;
            return localized;
        }
        return t.getLocalizedMessage();
    }
}

