/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.clazz;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import javax.jmi.reflect.InvalidObjectException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.clazz.ClassDataLoader;
import org.netbeans.modules.clazz.ClassElementNodeFactory;
import org.netbeans.modules.clazz.CompiledDataObject;
import org.netbeans.modules.clazz.NodeFactoryPool;
import org.netbeans.modules.clazz.SerDataObject;
import org.netbeans.modules.clazz.SourceElementImpl;
import org.netbeans.modules.clazz.Util;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.InstanceSupport;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Identifier;
import org.openide.src.SourceElement;
import org.openide.src.Type;
import org.openide.src.nodes.ElementNodeFactory;
import org.openide.src.nodes.FilterFactory;
import org.openide.util.NbBundle;

public class ClassDataObject
extends MultiDataObject
implements CookieSet.Factory,
SourceCookie {
    public static final String PROP_CLASS_LOADING_ERROR = "classLoadingError";
    private Throwable classLoadingError;
    protected static final int UNDECIDED = 0;
    protected static final int APPLET = 1;
    protected static final int APPLICATION = 2;
    static final long serialVersionUID = -1L;
    private transient InstanceSupport instanceSupport;
    private transient boolean sourceCreated;
    transient PropL propL;
    transient Reference srcEl = new WeakReference<Object>(null);
    private transient ClassFile mainClass;
    private static NodeFactoryPool explorerFactories;
    private static NodeFactoryPool browserFactories;
    private static ElementNodeFactory basicBrowser;
    private static ElementNodeFactory basicExplorer;
    static /* synthetic */ Class class$org$netbeans$modules$clazz$ClassDataObject;

    public ClassDataObject(FileObject fo, MultiFileLoader loader) throws DataObjectExistsException {
        super(fo, loader);
    }

    static ClassDataObject createSerDataObject(FileObject fo, ClassDataLoader dl) throws DataObjectExistsException, IOException {
        return new SerDataObject(fo, dl);
    }

    static ClassDataObject createCompiledDataObject(FileObject fo, ClassDataLoader dl) throws DataObjectExistsException, IOException {
        return new CompiledDataObject(fo, dl);
    }

    protected void initCookies() {
        CookieSet cs = this.getCookieSet();
        cs.add(new Class[]{SourceCookie.class}, (CookieSet.Factory)this);
        cs.add(OpenCookie.class, (CookieSet.Factory)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InstanceSupport createInstanceSupport() {
        if (this.instanceSupport != null) {
            return this.instanceSupport;
        }
        ClassDataObject classDataObject = this;
        synchronized (classDataObject) {
            if (this.instanceSupport == null) {
                this.instanceSupport = new ClazzInstanceSupport(this.getPrimaryEntry());
                if (this.propL == null) {
                    this.propL = new PropL();
                    FileObject p = this.getPrimaryFile();
                    p.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.propL, (Object)p));
                }
            }
        }
        return this.instanceSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceElement getSource() {
        SourceElement s = (SourceElement)this.srcEl.get();
        if (s != null) {
            return s;
        }
        ClassDataObject classDataObject = this;
        synchronized (classDataObject) {
            s = (SourceElement)this.srcEl.get();
            if (s != null) {
                return s;
            }
            this.sourceCreated = true;
            s = new SourceElement((SourceElement.Impl)new SourceElementImpl(this));
            this.srcEl = new WeakReference<SourceElement>(s);
        }
        return s;
    }

    public Node.Cookie createCookie(Class desired) {
        if (desired == InstanceCookie.class) {
            return this.createInstanceSupport();
        }
        if (OpenCookie.class.isAssignableFrom(desired)) {
            return new OpenSourceCookie();
        }
        return null;
    }

    protected Throwable getClassLoadingError() {
        this.getClassFile();
        return this.classLoadingError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forceReload() {
        SourceCookie sc;
        SourceElementImpl impl;
        CookieSet s = this.getCookieSet();
        InstanceSupport prevCookie = this.instanceSupport;
        ClassDataObject classDataObject = this;
        synchronized (classDataObject) {
            this.instanceSupport = null;
            this.mainClass = null;
        }
        if (prevCookie != null) {
            s.remove((Node.Cookie)prevCookie);
            s.add(new Class[]{InstanceCookie.class}, (CookieSet.Factory)this);
        }
        if (this.sourceCreated && (impl = (SourceElementImpl)(sc = (SourceCookie)this.getCookie(SourceCookie.class)).getSource().getCookie(SourceElement.Impl.class)) != null) {
            impl.setResource(null);
        }
    }

    protected ClassFile getClassFile() {
        if (this.mainClass == null) {
            Throwable t = this.classLoadingError;
            this.classLoadingError = null;
            try {
                this.mainClass = this.loadClassFile();
            }
            catch (RuntimeException ex) {
                this.classLoadingError = ex;
            }
            catch (IOException ex) {
                this.classLoadingError = ex;
            }
            catch (ClassNotFoundException ex) {
                this.classLoadingError = ex;
            }
            if (this.classLoadingError != null) {
                this.firePropertyChange(PROP_CLASS_LOADING_ERROR, t, this.classLoadingError);
            }
        }
        return this.mainClass;
    }

    protected ClassElement getMainClass() {
        ClassElement[] ce = this.getSource().getClasses();
        if (ce.length == 0) {
            return null;
        }
        return ce[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassFile loadClassFile() throws IOException, ClassNotFoundException {
        InputStream stream = this.getPrimaryEntry().getFile().getInputStream();
        if (stream == null) {
            return null;
        }
        try {
            ClassFile classFile = new ClassFile(stream, false);
            return classFile;
        }
        finally {
            stream.close();
        }
    }

    public boolean isCopyAllowed() {
        return true;
    }

    public boolean isMoveAllowed() {
        return this.getPrimaryFile().canWrite();
    }

    public boolean isRenameAllowed() {
        return this.getPrimaryFile().canWrite();
    }

    public boolean isJavaBean() {
        return this.createInstanceSupport().isJavaBean();
    }

    public boolean isApplet() {
        return this.createInstanceSupport().isApplet();
    }

    public boolean isInterface() {
        return this.createInstanceSupport().isInterface();
    }

    public String getSuperclass() {
        ClassElement ce = this.getMainClass();
        if (ce == null) {
            return "";
        }
        Identifier id = ce.getSuperclass();
        return id == null ? "" : id.getFullName();
    }

    public String getModifiers() throws IOException, ClassNotFoundException {
        ClassElement ce = this.getMainClass();
        if (ce == null) {
            throw new ClassNotFoundException();
        }
        return Modifier.toString(ce.getModifiers());
    }

    public String getClassName() {
        return this.createInstanceSupport().instanceName();
    }

    public Class getBeanClass() throws IOException, ClassNotFoundException {
        return this.createInstanceSupport().instanceClass();
    }

    static synchronized ElementNodeFactory createBasicExplorerFactory() {
        if (basicExplorer == null) {
            basicExplorer = new ClassElementNodeFactory();
        }
        return basicExplorer;
    }

    static synchronized ElementNodeFactory createBasicBrowserFactory() {
        if (basicBrowser == null) {
            basicBrowser = new ClassElementNodeFactory();
            ((ClassElementNodeFactory)basicBrowser).setGenerateForTree(true);
        }
        return basicBrowser;
    }

    public static ElementNodeFactory getExplorerFactory() {
        NodeFactoryPool pool = ClassDataObject.createExplorerFactory();
        ElementNodeFactory f = null;
        if (pool != null) {
            f = pool.getHead();
        }
        if (f == null) {
            f = ClassDataObject.createBasicExplorerFactory();
        }
        return f;
    }

    public static ElementNodeFactory getBrowserFactory() {
        NodeFactoryPool pool = ClassDataObject.createBrowserFactory();
        ElementNodeFactory f = null;
        if (pool != null) {
            f = pool.getHead();
        }
        if (f == null) {
            f = ClassDataObject.createBasicBrowserFactory();
        }
        return f;
    }

    static NodeFactoryPool createFactoryPool(String folderName, ElementNodeFactory def) {
        FileObject f = Repository.getDefault().getDefaultFileSystem().findResource(folderName);
        if (f == null) {
            return null;
        }
        try {
            DataFolder folder = (DataFolder)DataObject.find((FileObject)f).getCookie(DataFolder.class);
            return new NodeFactoryPool(folder, def);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
    }

    static synchronized NodeFactoryPool createBrowserFactory() {
        if (browserFactories != null) {
            return browserFactories;
        }
        browserFactories = ClassDataObject.createFactoryPool("/NodeFactories/clazz/objectbrowser", ClassDataObject.createBasicBrowserFactory());
        return browserFactories;
    }

    static synchronized NodeFactoryPool createExplorerFactory() {
        if (explorerFactories != null) {
            return explorerFactories;
        }
        explorerFactories = ClassDataObject.createFactoryPool("/NodeFactories/clazz/explorer", ClassDataObject.createBasicExplorerFactory());
        return explorerFactories;
    }

    public static void addExplorerFilterFactory(FilterFactory factory) {
        NodeFactoryPool p = ClassDataObject.createExplorerFactory();
        if (p != null) {
            p.addFactory(factory);
        }
    }

    public static void removeExplorerFilterFactory(FilterFactory factory) {
        NodeFactoryPool p = ClassDataObject.createExplorerFactory();
        if (p != null) {
            p.removeFactory(factory);
        }
    }

    public static void addBrowserFilterFactory(FilterFactory factory) {
        NodeFactoryPool p = ClassDataObject.createBrowserFactory();
        if (p != null) {
            p.addFactory(factory);
        }
    }

    public static void removeBrowserFilterFactory(FilterFactory factory) {
        NodeFactoryPool p = ClassDataObject.createBrowserFactory();
        if (p != null) {
            p.removeFactory(factory);
        }
    }

    private class OpenSourceCookie
    implements OpenCookie {
        private OpenSourceCookie() {
        }

        public void open() {
            try {
                FileObject fo = ClassDataObject.this.getPrimaryFile();
                FileObject binaryRoot = null;
                String resourceName = null;
                ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile");
                if (cp == null || (binaryRoot = cp.findOwnerRoot(fo)) == null) {
                    cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/execute");
                    if (cp != null) {
                        binaryRoot = cp.findOwnerRoot(fo);
                        resourceName = cp.getResourceName(fo, '/', false);
                    }
                } else if (binaryRoot != null) {
                    resourceName = cp.getResourceName(fo, '/', false);
                }
                FileObject[] sourceRoots = null;
                if (binaryRoot != null) {
                    sourceRoots = SourceForBinaryQuery.findSourceRoots((URL)binaryRoot.getURL()).getRoots();
                }
                FileObject resource = null;
                if (sourceRoots != null && sourceRoots.length > 0) {
                    cp = ClassPathSupport.createClassPath((FileObject[])sourceRoots);
                    resource = cp.findResource(resourceName + ".java");
                }
                if (resource != null) {
                    DataObject sourceFile = DataObject.find(resource);
                    OpenCookie oc = (OpenCookie)sourceFile.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = ClassDataObject.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
                    if (oc != null) {
                        oc.open();
                    } else {
                        ErrorManager.getDefault().log("SourceFile: " + resource.getPath() + " has no OpenCookie");
                    }
                } else {
                    if (resourceName == null) {
                        resourceName = fo.getName();
                    }
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$clazz$ClassDataObject == null ? (class$org$netbeans$modules$clazz$ClassDataObject = ClassDataObject.class$("org.netbeans.modules.clazz.ClassDataObject")) : class$org$netbeans$modules$clazz$ClassDataObject), (String)"TXT_NoSources", (Object)resourceName.replace('/', '.')));
                }
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            catch (DataObjectNotFoundException nf) {
                ErrorManager.getDefault().notify((Throwable)nf);
            }
        }
    }

    protected final class ClazzInstanceSupport
    extends InstanceSupport {
        private Boolean bean;
        private Boolean executable;

        ClazzInstanceSupport(MultiDataObject.Entry entry) {
            super(entry);
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            try {
                Class c = super.instanceClass();
                return c;
            }
            catch (RuntimeException ex) {
                ClassDataObject.this.classLoadingError = ex;
                throw new ClassNotFoundException(ex.getMessage());
            }
        }

        protected ClassLoader createClassLoader(FileObject ref) {
            HashSet<ClassPath> c = new HashSet<ClassPath>();
            ClassPath cp = ClassPath.getClassPath((FileObject)ref, (String)"classpath/compile");
            if (cp != null) {
                c.add(cp);
            }
            if ((cp = ClassPath.getClassPath((FileObject)ref, (String)"classpath/execute")) != null) {
                c.add(cp);
            }
            if (c.size() > 0) {
                cp = ClassPathSupport.createProxyClassPath((ClassPath[])c.toArray(new ClassPath[c.size()]));
                return cp.getClassLoader(true);
            }
            return null;
        }

        public boolean isJavaBean() {
            if (this.bean != null) {
                return this.bean;
            }
            if (this.isSerialized()) {
                this.bean = Boolean.TRUE;
                return true;
            }
            try {
                ClassElement clazz = ClassDataObject.this.getMainClass();
                if (clazz == null) {
                    return false;
                }
                int modif = clazz.getModifiers();
                if (!Modifier.isPublic(modif) || Modifier.isAbstract(modif)) {
                    this.bean = Boolean.FALSE;
                    return false;
                }
                ConstructorElement c = clazz.getConstructor(new Type[0]);
                if (c == null || !Modifier.isPublic(c.getModifiers())) {
                    this.bean = Boolean.FALSE;
                    return false;
                }
                for (ClassElement outer = clazz.getDeclaringClass(); outer != null; outer = outer.getDeclaringClass()) {
                    if (!Modifier.isStatic(modif)) {
                        this.bean = Boolean.FALSE;
                        return false;
                    }
                    modif = outer.getModifiers();
                    if (Modifier.isPublic(modif)) continue;
                    this.bean = Boolean.FALSE;
                    return false;
                }
            }
            catch (InvalidObjectException ioe) {
                this.bean = Boolean.FALSE;
                return false;
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (Throwable t) {
                this.bean = Boolean.FALSE;
                return false;
            }
            this.bean = Boolean.TRUE;
            return true;
        }

        public boolean isInterface() {
            ClassElement ce = ClassDataObject.this.getMainClass();
            return ce == null ? false : ce.isInterface();
        }

        public String instanceName() {
            ClassElement ce = ClassDataObject.this.getMainClass();
            if (ce == null) {
                return super.instanceName();
            }
            return ce.getName().getFullName();
        }

        public boolean instanceOf(Class type) {
            String className = type.getName();
            ClassElement ce = ClassDataObject.this.getMainClass();
            if (ce == null) {
                return false;
            }
            boolean isClassType = !type.isInterface();
            String typename = type.getName().replace('$', '.');
            LinkedList<Identifier> l = new LinkedList<Identifier>();
            do {
                if (ce.getName().getFullName().equals(typename)) {
                    return true;
                }
                Identifier id = ce.getSuperclass();
                Identifier[] itfs = ce.getInterfaces();
                for (int i = 0; i < itfs.length; ++i) {
                    l.addLast(itfs[i]);
                }
                if (id == null) {
                    if (l.isEmpty()) {
                        return false;
                    }
                    id = (Identifier)l.removeFirst();
                }
                ce = ClassElement.forName((String)id.getFullName(), (FileObject)ClassDataObject.this.getPrimaryFile());
                while (ce == null && !l.isEmpty()) {
                    ce = ClassElement.forName((String)((Identifier)l.removeFirst()).getFullName(), (FileObject)ClassDataObject.this.getPrimaryFile());
                }
            } while (ce != null);
            return false;
        }

        public boolean isExecutable() {
            try {
                if (this.executable == null) {
                    ClassElement ce = ClassDataObject.this.getMainClass();
                    this.executable = ce != null && ce.hasMainMethod() ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            catch (InvalidObjectException ioe) {
                this.executable = Boolean.FALSE;
            }
            return this.executable;
        }

        private boolean isSerialized() {
            return this.instanceOrigin().getExt().equals("ser");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object instanceCreate() throws IOException, ClassNotFoundException {
            try {
                if (this.isSerialized()) {
                    BufferedInputStream bis = new BufferedInputStream(this.instanceOrigin().getInputStream(), 1024);
                    ClassLoader classLoader = this.createClassLoader(this.instanceOrigin());
                    if (classLoader == null) {
                        throw new ClassNotFoundException();
                    }
                    CMObjectInputStream cis = new CMObjectInputStream(bis, classLoader);
                    Object o = null;
                    try {
                        o = cis.readObject();
                    }
                    finally {
                        cis.close();
                    }
                    return o;
                }
                return super.instanceCreate();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().annotate((Throwable)ex, this.instanceName());
                throw ex;
            }
            catch (ClassNotFoundException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new ClassNotFoundException(e.toString(), e);
            }
            catch (LinkageError e) {
                throw new ClassNotFoundException(e.toString(), e);
            }
        }

        private final class CMObjectInputStream
        extends ObjectInputStream {
            private ClassLoader loader;

            protected CMObjectInputStream(InputStream s, ClassLoader cl) throws IOException {
                super(s);
                this.loader = cl;
            }

            protected Class resolveClass(ObjectStreamClass s) throws IOException, ClassNotFoundException {
                return Class.forName(s.getName(), false, this.loader);
            }
        }
    }

    private class PropL
    extends FileChangeAdapter
    implements Runnable,
    PropertyChangeListener {
        private PropL() {
        }

        public void propertyChange(PropertyChangeEvent ev) {
            String prop = ev.getPropertyName();
            if ("primaryFile".equals(prop)) {
                FileObject p = ClassDataObject.this.getPrimaryFile();
                p.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)ClassDataObject.this.getPrimaryFile()));
                this.postReload();
            }
        }

        public void fileChanged(FileEvent ev) {
            this.postReload();
        }

        public void run() {
            ClassDataObject.this.forceReload();
        }

        private void postReload() {
            Util.getClassProcessor().post((Runnable)this, 100);
        }
    }
}

