/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.clazz;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.modules.clazz.ClassDataLoader;
import org.netbeans.modules.clazz.ClassDataObject;
import org.netbeans.modules.clazz.CompiledDataNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObjectExistsException;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;

public class CompiledDataObject
extends ClassDataObject {
    static final long serialVersionUID = -7355104884002106137L;
    private static final String PROP_ARGV = "Arguments";
    private static final String PROP_EXECUTION = "Execution";

    public CompiledDataObject(FileObject fo, ClassDataLoader loader) throws DataObjectExistsException {
        super(fo, loader);
        this.initCookies();
    }

    protected void initCookies() {
        super.initCookies();
        CookieSet cs = this.getCookieSet();
        cs.add(InstanceCookie.class, (CookieSet.Factory)this);
    }

    protected Node.Cookie createBeanInstanceSupport() {
        if (this.isJavaBean()) {
            return this.createInstanceSupport();
        }
        return null;
    }

    public Node.Cookie createCookie(Class c) {
        if (InstanceCookie.class.isAssignableFrom(c)) {
            return this.createBeanInstanceSupport();
        }
        return super.createCookie(c);
    }

    protected Node createNodeDelegate() {
        return new CompiledDataNode(this);
    }

    boolean isExecutable() {
        return this.createInstanceSupport().isExecutable();
    }

    protected String existInFolder(DataFolder f) throws UserCancelException {
        FileObject fo = this.getPrimaryFile();
        String name = fo.getName();
        String ext = "ser";
        String destName = fo.getName();
        if (f.getPrimaryFile().getFileObject(name, ext) != null) {
            ResourceBundle bundle = NbBundle.getBundle((Class)ClassDataObject.class);
            String rewriteStr = bundle.getString("CTL_Rewrite");
            String renameStr = bundle.getString("CTL_Rename");
            String cancelStr = bundle.getString("CTL_Cancel");
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)new MessageFormat(bundle.getString("MSG_SerExists")).format(new Object[]{name, f.getName()}));
            nd.setOptions(new Object[]{rewriteStr, renameStr, cancelStr});
            String retStr = (String)DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (cancelStr.equals(retStr)) {
                throw new UserCancelException();
            }
            if (renameStr.equals(retStr)) {
                destName = FileUtil.findFreeFileName((FileObject)f.getPrimaryFile(), (String)destName, (String)ext);
            }
            if (rewriteStr.equals(retStr)) {
                try {
                    FileObject dest = f.getPrimaryFile().getFileObject(name, ext);
                    FileLock lock = dest.lock();
                    dest.delete(lock);
                    lock.releaseLock();
                }
                catch (IOException e) {
                    return null;
                }
            }
        }
        return destName;
    }
}

