/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.BreakpointRequest;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBasedBreakpoint;

public class MethodBreakpointImpl
extends ClassBasedBreakpoint {
    private static final boolean verbose = System.getProperty("netbeans.debugger.breakpoints") != null;
    private MethodBreakpoint breakpoint;

    public MethodBreakpointImpl(MethodBreakpoint breakpoint, JPDADebuggerImpl debugger, Session session) {
        super((JPDABreakpoint)breakpoint, debugger, session);
        this.breakpoint = breakpoint;
        this.set();
    }

    protected void setRequests() {
        this.setClassRequests(this.breakpoint.getClassFilters(), this.breakpoint.getClassExclusionFilters(), 1);
        this.checkLoadedClasses(this.breakpoint.getClassFilters()[0], false);
    }

    public boolean exec(Event event) {
        if (event instanceof BreakpointEvent) {
            return this.perform(this.breakpoint.getCondition(), ((BreakpointEvent)event).thread(), ((LocatableEvent)event).location().declaringType(), null);
        }
        return super.exec(event);
    }

    protected void classLoaded(ReferenceType referenceType) {
        if (verbose) {
            System.out.println("B class loaded: " + referenceType);
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        Iterator<Method> methods = referenceType.methods().iterator();
        while (methods.hasNext()) {
            Method method = methods.next();
            if (!MethodBreakpointImpl.match(method.name(), this.breakpoint.getMethodName()) && !this.breakpoint.getMethodName().equals("") || method.location() == null) continue;
            locations.add(method.location());
        }
        Iterator it = locations.iterator();
        while (it.hasNext()) {
            Location location = (Location)it.next();
            try {
                BreakpointRequest br = this.getEventRequestManager().createBreakpointRequest(location);
                this.addEventRequest(br);
            }
            catch (VMDisconnectedException e) {}
        }
    }
}

