/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.Value;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Refreshable;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.Expression;
import org.netbeans.modules.debugger.jpda.expr.ParseException;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAObjectWatchImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAWatchImpl;
import org.netbeans.modules.debugger.jpda.models.LocalsTreeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class WatchesModel
implements TreeModel {
    private static boolean verbose = System.getProperty("netbeans.debugger.viewrefresh") != null && System.getProperty("netbeans.debugger.viewrefresh").indexOf(119) >= 0;
    private JPDADebuggerImpl debugger;
    private Listener listener;
    private Vector listeners = new Vector();
    private ContextProvider lookupProvider;
    private Map watchToValue = new WeakHashMap();
    private LocalsTreeModel localsTreeModel;

    public WatchesModel(ContextProvider lookupProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)lookupProvider.lookupFirst(null, JPDADebugger.class));
        this.lookupProvider = lookupProvider;
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            Watch[] ws = DebuggerManager.getDebuggerManager().getWatches();
            to = Math.min(ws.length, to);
            from = Math.min(ws.length, from);
            Watch[] fws = new Watch[to - from];
            System.arraycopy(ws, from, fws, 0, to - from);
            int k = fws.length;
            Object[] jws = new JPDAWatch[k];
            for (int i = 0; i < k; ++i) {
                JPDAWatch jw = (JPDAWatch)this.watchToValue.get(fws[i]);
                if (jw == null) {
                    jw = new JPDAWatchEvaluating(this, fws[i], this.debugger);
                }
                jws[i] = jw;
                this.watchToValue.put(fws[i], jw);
            }
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
            return jws;
        }
        if (parent instanceof JPDAWatchImpl) {
            return this.getLocalsTreeModel().getChildren(parent, from, to);
        }
        return this.getLocalsTreeModel().getChildren(parent, from, to);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
            return DebuggerManager.getDebuggerManager().getWatches().length;
        }
        if (node instanceof JPDAWatchImpl) {
            return this.getLocalsTreeModel().getChildrenCount(node);
        }
        return this.getLocalsTreeModel().getChildrenCount(node);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        JPDAWatchEvaluating jwe;
        JPDAWatch jw;
        if (node == "Root") {
            return false;
        }
        if (node instanceof JPDAWatchEvaluating && (jw = (jwe = (JPDAWatchEvaluating)node).getEvaluatedWatch()) instanceof JPDAWatchImpl) {
            return ((JPDAWatchImpl)jw).isPrimitive();
        }
        return this.getLocalsTreeModel().isLeaf(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTreeChanged() {
        Map map = this.watchToValue;
        synchronized (map) {
            this.watchToValue.clear();
        }
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        ModelEvent.TreeChanged event = new ModelEvent.TreeChanged((Object)this);
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)event);
        }
    }

    private void fireWatchesChanged() {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        ModelEvent.NodeChanged event = new ModelEvent.NodeChanged((Object)this, (Object)"Root", 8);
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireTableValueChangedChanged(Object node, String propertyName) {
        Map map = this.watchToValue;
        synchronized (map) {
            Iterator it = this.watchToValue.keySet().iterator();
            while (it.hasNext()) {
                Object w = it.next();
                if (!node.equals(this.watchToValue.get(w))) continue;
                this.watchToValue.remove(w);
                ((JPDAWatchEvaluating)node).setEvaluated(null);
                break;
            }
        }
        this.fireTableValueChangedComputed(node, propertyName);
    }

    void fireTableValueChangedComputed(Object node, String propertyName) {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.TableValueChanged((Object)this, node, propertyName));
        }
    }

    JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    LocalsTreeModel getLocalsTreeModel() {
        if (this.localsTreeModel == null) {
            this.localsTreeModel = (LocalsTreeModel)this.lookupProvider.lookupFirst("LocalsView", TreeModel.class);
        }
        return this.localsTreeModel;
    }

    private static class Listener
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private WeakReference model;
        private WeakReference debugger;
        private RequestProcessor.Task task;

        private Listener(WatchesModel tm, JPDADebuggerImpl debugger) {
            this.model = new WeakReference<WatchesModel>(tm);
            this.debugger = new WeakReference<JPDADebuggerImpl>(debugger);
            DebuggerManager.getDebuggerManager().addDebuggerListener("watches", (DebuggerManagerListener)this);
            debugger.addPropertyChangeListener(this);
            Watch[] ws = DebuggerManager.getDebuggerManager().getWatches();
            int k = ws.length;
            for (int i = 0; i < k; ++i) {
                ws[i].addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private WatchesModel getModel() {
            WatchesModel m = (WatchesModel)this.model.get();
            if (m == null) {
                this.destroy();
            }
            return m;
        }

        public void watchAdded(Watch watch) {
            WatchesModel m = this.getModel();
            if (m == null) {
                return;
            }
            watch.addPropertyChangeListener((PropertyChangeListener)this);
            m.fireWatchesChanged();
        }

        public void watchRemoved(Watch watch) {
            WatchesModel m = this.getModel();
            if (m == null) {
                return;
            }
            watch.removePropertyChangeListener((PropertyChangeListener)this);
            m.fireWatchesChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("watches".equals(propName)) {
                return;
            }
            final WatchesModel m = this.getModel();
            if (m == null) {
                return;
            }
            if (m.debugger.getState() == 4) {
                this.destroy();
                return;
            }
            if (m.debugger.getState() == 2) {
                return;
            }
            if (evt.getSource() instanceof Watch) {
                Object node;
                Map map = m.watchToValue;
                synchronized (map) {
                    node = m.watchToValue.get(evt.getSource());
                }
                if (node != null) {
                    m.fireTableValueChangedChanged(node, null);
                    return;
                }
            }
            if (this.task == null) {
                this.task = RequestProcessor.getDefault().create(new Runnable(){

                    public void run() {
                        if (verbose) {
                            System.out.println("WM do task " + Listener.this.task);
                        }
                        m.fireTreeChanged();
                    }
                });
            }
            this.task.schedule(100);
            if (verbose) {
                System.out.println("WM  create task " + this.task);
            }
        }

        private void destroy() {
            DebuggerManager.getDebuggerManager().removeDebuggerListener("watches", (DebuggerManagerListener)this);
            JPDADebugger d = (JPDADebugger)this.debugger.get();
            if (d != null) {
                d.removePropertyChangeListener((PropertyChangeListener)this);
            }
            Watch[] ws = DebuggerManager.getDebuggerManager().getWatches();
            int k = ws.length;
            for (int i = 0; i < k; ++i) {
                ws[i].removePropertyChangeListener((PropertyChangeListener)this);
            }
            if (this.task != null) {
                this.task.cancel();
                if (verbose) {
                    System.out.println("WM cancel old task " + this.task);
                }
                this.task = null;
            }
        }
    }

    private static class JPDAWatchEvaluating
    extends AbstractVariable
    implements JPDAWatch,
    Variable,
    Refreshable,
    PropertyChangeListener {
        private WatchesModel model;
        private Watch w;
        private JPDADebuggerImpl debugger;
        private JPDAWatch evaluatedWatch;
        private Expression expression;
        private boolean[] evaluating = new boolean[]{false};
        private PropertyChangeSupport propSupp = new PropertyChangeSupport(this);

        public JPDAWatchEvaluating(WatchesModel model, Watch w, JPDADebuggerImpl debugger) {
            super(debugger, null, "" + w);
            this.model = model;
            this.w = w;
            this.debugger = debugger;
            this.parseExpression(w.getExpression());
        }

        private void parseExpression(String exprStr) {
            try {
                this.expression = Expression.parse(exprStr, "1.5.0");
            }
            catch (ParseException e) {
                this.setEvaluated(new JPDAWatchImpl(this.debugger, this.w, e, (Object)this));
            }
        }

        Expression getParsedExpression() {
            return this.expression;
        }

        public void setEvaluated(JPDAWatch evaluatedWatch) {
            this.evaluatedWatch = evaluatedWatch;
            if (evaluatedWatch != null) {
                if (evaluatedWatch instanceof JPDAWatchImpl) {
                    this.setInnerValue(((JPDAWatchImpl)evaluatedWatch).getInnerValue());
                } else if (evaluatedWatch instanceof JPDAObjectWatchImpl) {
                    this.setInnerValue(((JPDAObjectWatchImpl)evaluatedWatch).getInnerValue());
                }
            } else {
                this.setInnerValue(null);
            }
        }

        JPDAWatch getEvaluatedWatch() {
            return this.evaluatedWatch;
        }

        public void expressionChanged() {
            this.setEvaluated(null);
            this.parseExpression(this.w.getExpression());
        }

        public String getExceptionDescription() {
            if (this.evaluatedWatch != null) {
                return this.evaluatedWatch.getExceptionDescription();
            }
            return null;
        }

        public String getExpression() {
            if (this.evaluatedWatch != null) {
                return this.evaluatedWatch.getExpression();
            }
            return this.w.getExpression();
        }

        public String getToStringValue() throws InvalidExpressionException {
            if (this.evaluatedWatch == null) {
                this.getValue();
            }
            return this.evaluatedWatch.getToStringValue();
        }

        public String getType() {
            if (this.evaluatedWatch == null) {
                this.getValue();
            }
            return this.evaluatedWatch.getType();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String getValue() {
            boolean[] blArray = this.evaluating;
            synchronized (this.evaluating) {
                Object expr;
                if (this.evaluating[0]) {
                    try {
                        this.evaluating.wait();
                    }
                    catch (InterruptedException iex) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return null;
                    }
                }
                if (this.evaluatedWatch != null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return this.evaluatedWatch.getValue();
                }
                this.evaluating[0] = true;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                JPDAWatchImpl jw = null;
                try {
                    expr = this.getParsedExpression();
                    Value v = this.debugger.evaluateIn((Expression)expr);
                    JPDAWatchImpl jwi = new JPDAWatchImpl(this.debugger, this.w, v, (Object)this);
                    jwi.addPropertyChangeListener(this);
                    jw = jwi;
                    this.setEvaluated(jw);
                }
                catch (InvalidExpressionException e) {
                    try {
                        JPDAWatchImpl jwi = new JPDAWatchImpl(this.debugger, this.w, (Exception)((Object)e), (Object)this);
                        jwi.addPropertyChangeListener(this);
                        jw = jwi;
                        this.setEvaluated(jw);
                        boolean[] blArray2 = this.evaluating;
                    }
                    catch (Throwable throwable) {
                        this.setEvaluated(jw);
                        boolean[] blArray3 = this.evaluating;
                        synchronized (this.evaluating) {
                            this.evaluating[0] = false;
                            this.evaluating.notifyAll();
                            // ** MonitorExit[var8_13] (shouldn't be in output)
                            throw throwable;
                        }
                    }
                    synchronized (this.evaluating) {
                        this.evaluating[0] = false;
                        this.evaluating.notifyAll();
                        // ** MonitorExit[var2_5] (shouldn't be in output)
                        return jw.getValue();
                    }
                }
                expr = this.evaluating;
                synchronized (this.evaluating) {
                    this.evaluating[0] = false;
                    this.evaluating.notifyAll();
                    // ** MonitorExit[expr] (shouldn't be in output)
                    return jw.getValue();
                }
            }
        }

        public void remove() {
            if (this.evaluatedWatch != null) {
                this.evaluatedWatch.remove();
            } else {
                this.w.remove();
            }
        }

        public void setExpression(String expression) {
            this.w.setExpression(expression);
            this.expressionChanged();
        }

        public void setValue(String value) throws InvalidExpressionException {
            if (this.evaluatedWatch == null) {
                throw new InvalidExpressionException("Can not set value while evaluating.");
            }
            this.evaluatedWatch.setValue(value);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.propSupp.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.propSupp.removePropertyChangeListener(l);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.model.fireTableValueChangedChanged(this, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh() throws RefreshFailedException {
            boolean[] blArray = this.evaluating;
            synchronized (this.evaluating) {
                if (this.evaluating[0]) {
                    try {
                        this.evaluating.wait();
                    }
                    catch (InterruptedException iex) {
                        throw new RefreshFailedException(iex.getLocalizedMessage());
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public boolean isCurrent() {
            return this.evaluatedWatch != null;
        }
    }
}

