/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.client.nodes;

import java.awt.Image;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.websvc.core.client.nodes.ClientViewChildren;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public final class ClientRootNode
extends AbstractNode {
    private static final Image WEB_SERVICES_BADGE = Utilities.loadImage((String)"org/netbeans/modules/websvc/core/client/resources/webServiceBadge.gif");
    private static Icon folderIconCache;
    private static Icon openedFolderIconCache;
    private FileObject wsdlFolder;

    public ClientRootNode(FileObject wsdlFolder) throws DataObjectNotFoundException {
        super((Children)(wsdlFolder != null ? new ClientViewChildren(wsdlFolder) : Children.LEAF), ClientRootNode.createLookup(wsdlFolder));
        this.wsdlFolder = wsdlFolder;
        this.initialize();
    }

    private void initialize() {
        this.setName("WebServiceReferences");
        this.setDisplayName(NbBundle.getBundle(ClientRootNode.class).getString("LBL_WebServiceReferences"));
    }

    public Image getIcon(int type) {
        return this.computeIcon(false, type);
    }

    public Image getOpenedIcon(int type) {
        return this.computeIcon(true, type);
    }

    public Action[] getActions(boolean context) {
        return new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(FindAction.class), null, SystemAction.get(PasteAction.class), null, SystemAction.get(ToolsAction.class)};
    }

    static synchronized Icon getFolderIcon(boolean opened) {
        if (openedFolderIconCache == null) {
            Node n = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
            openedFolderIconCache = new ImageIcon(n.getOpenedIcon(1));
            folderIconCache = new ImageIcon(n.getIcon(1));
        }
        if (opened) {
            return openedFolderIconCache;
        }
        return folderIconCache;
    }

    private Image computeIcon(boolean opened, int type) {
        Icon icon = ClientRootNode.getFolderIcon(opened);
        Image image = ((ImageIcon)icon).getImage();
        image = Utilities.mergeImages((Image)image, (Image)WEB_SERVICES_BADGE, (int)7, (int)7);
        return image;
    }

    private static Lookup createLookup(FileObject wsdlFolder) {
        if (wsdlFolder != null) {
            DataFolder dataFolder = DataFolder.findFolder((FileObject)wsdlFolder);
            return Lookups.fixed((Object[])new Object[]{dataFolder});
        }
        return Lookups.fixed((Object[])new Object[0]);
    }
}

