/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jmi.reflect.JmiException;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.ui.nodes.ComponentMethodViewStrategy;
import org.netbeans.modules.j2ee.common.ui.nodes.MethodNode;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.Binding;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelerFactory;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.core.jaxws.JaxWsUtils;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsClientChildren;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsNode;
import org.netbeans.modules.websvc.core.jaxws.nodes.OperationNode;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.api.WsdlWrapperGenerator;
import org.netbeans.modules.websvc.jaxws.api.WsdlWrapperHandler;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.xml.sax.SAXException;

public class JaxWsChildren
extends Children.Keys
implements MDRChangeListener {
    private JavaClass implClass;
    private Service service;
    private FileObject srcRoot;
    private WsdlModel wsdlModel;
    private WsdlModeler wsdlModeler;
    private boolean modelGenerationFinished;
    private Method[] methods;

    public JaxWsChildren(Service service, FileObject srcRoot) {
        this.service = service;
        this.srcRoot = srcRoot;
    }

    public ComponentMethodViewStrategy createViewStrategy() {
        WSComponentMethodViewStrategy strategy = WSComponentMethodViewStrategy.instance();
        return strategy;
    }

    private JavaClass getImplementationClass() {
        String implBean = this.service.getImplementationClass();
        if (implBean != null) {
            return JMIUtils.findClass((String)implBean, (FileObject)this.srcRoot);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method[] getMethods() {
        MDRepository repo = JavaMetamodel.getDefaultRepository();
        repo.beginTrans(false);
        try {
            if (this.implClass != null && this.implClass.isValid()) {
                Method[] methodArray = JMIUtils.getMethods((JavaClass)this.implClass);
                return methodArray;
            }
        }
        finally {
            repo.endTrans();
        }
        return null;
    }

    protected void addNotify() {
        super.addNotify();
        if (this.isFromWsdl()) {
            try {
                FileObject localWsdlFolder = this.getJAXWSSupport().getLocalWsdlFolderForService(this.service.getName(), false);
                assert (localWsdlFolder != null) : "Cannot find folder for local wsdl file";
                FileObject wsdlFo = localWsdlFolder.getFileObject(this.service.getLocalWsdlFile());
                if (wsdlFo == null) {
                    return;
                }
                this.wsdlModeler = WsdlModelerFactory.getDefault().getWsdlModeler(wsdlFo.getURL());
                String packageName = this.service.getPackageName();
                if (packageName != null && this.service.isPackageNameForceReplace()) {
                    this.wsdlModeler.setPackageName(packageName);
                } else {
                    this.wsdlModeler.setPackageName(null);
                }
                JAXWSSupport support = this.getJAXWSSupport();
                this.wsdlModeler.setCatalog(support.getCatalog());
                this.setBindings(support, this.wsdlModeler, this.service);
                this.modelGenerationFinished = false;
                ((JaxWsNode)this.getNode()).changeIcon();
                this.wsdlModeler.generateWsdlModel(new WsdlModelListener(){

                    public void modelCreated(WsdlModel model) {
                        JaxWsChildren.this.wsdlModel = model;
                        JaxWsChildren.this.modelGenerationFinished = true;
                        ((JaxWsNode)JaxWsChildren.this.getNode()).changeIcon();
                        if (model == null) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new JaxWsUtils.WsImportServiceFailedMessage(JaxWsChildren.this.wsdlModeler.getCreationException()));
                        }
                        JaxWsChildren.this.updateKeys();
                    }
                });
            }
            catch (FileStateInvalidException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
                this.updateKeys();
            }
        } else {
            if (this.implClass == null) {
                this.implClass = this.getImplementationClass();
            }
            assert (this.implClass != null);
            this.registerListener();
            this.methods = this.getMethods();
            this.registerMethodListeners();
            this.updateKeys();
        }
    }

    private void registerListener() {
        if (this.implClass != null) {
            ((MDRChangeSource)this.implClass).addListener((MDRChangeListener)this);
        }
    }

    private void registerMethodListeners() {
        if (this.methods != null) {
            for (int i = 0; i < this.methods.length; ++i) {
                ((MDRChangeSource)this.methods[i]).addListener((MDRChangeListener)this);
            }
        }
    }

    private void removeListener() {
        if (this.implClass != null) {
            ((MDRChangeSource)this.implClass).removeListener((MDRChangeListener)this);
        }
    }

    private void removeMethodListeners() {
        if (this.methods != null) {
            for (int i = 0; i < this.methods.length; ++i) {
                ((MDRChangeSource)this.methods[i]).removeListener((MDRChangeListener)this);
            }
        }
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        if (!this.isFromWsdl()) {
            this.removeListener();
            this.removeMethodListeners();
            this.methods = null;
        }
        super.removeNotify();
    }

    private void updateKeys() {
        if (this.isFromWsdl()) {
            WsdlPort wsdlPort;
            WsdlService wsdlService;
            List keys = new ArrayList();
            if (this.wsdlModel != null && (wsdlService = this.wsdlModel.getServiceByName(this.service.getServiceName())) != null && (wsdlPort = wsdlService.getPortByName(this.service.getPortName())) != null) {
                keys = wsdlPort.getOperations();
            }
            this.setKeys(keys);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ArrayList<Method> keys = new ArrayList<Method>();
                    if (JaxWsChildren.this.implClass != null) {
                        if (JaxWsChildren.this.methods == null) {
                            JaxWsChildren.access$602(JaxWsChildren.this, JaxWsChildren.this.getMethods());
                            JaxWsChildren.this.registerMethodListeners();
                        }
                        boolean foundWebMethodAnnotation = false;
                        if (JaxWsChildren.this.methods != null) {
                            for (int i = 0; i < JaxWsChildren.this.methods.length; ++i) {
                                if (!JaxWsChildren.this.methods[i].isValid()) continue;
                                List annotations = JaxWsChildren.this.methods[i].getAnnotations();
                                boolean hasWebMethodAnnotation = false;
                                for (int j = 0; j < annotations.size(); ++j) {
                                    Annotation anot = (Annotation)annotations.get(j);
                                    if (!"javax.jws.WebMethod".equals(anot.getType().getName())) continue;
                                    hasWebMethodAnnotation = true;
                                    break;
                                }
                                if (hasWebMethodAnnotation) {
                                    if (!foundWebMethodAnnotation) {
                                        foundWebMethodAnnotation = true;
                                        if (keys.size() > 0) {
                                            keys.clear();
                                        }
                                    }
                                    if (!JaxWsChildren.this.isPublic(JaxWsChildren.this.methods[i])) continue;
                                    keys.add(JaxWsChildren.this.methods[i]);
                                    continue;
                                }
                                if (foundWebMethodAnnotation || !JaxWsChildren.this.isPublic(JaxWsChildren.this.methods[i])) continue;
                                keys.add(JaxWsChildren.this.methods[i]);
                            }
                        }
                    }
                    JaxWsChildren.this.setKeys(keys);
                }
            });
        }
    }

    private boolean isPublic(Method m) {
        return (m.getModifiers() & 1) != 0;
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof WsdlOperation) {
            return new Node[]{new OperationNode((WsdlOperation)key)};
        }
        if (key instanceof Method) {
            Method method = (Method)key;
            ComponentMethodViewStrategy cmvs = this.createViewStrategy();
            return new Node[]{new MethodNode(method, this.implClass, new ArrayList(), cmvs)};
        }
        return new Node[0];
    }

    private boolean isFromWsdl() {
        return this.service.getWsdlUrl() != null;
    }

    private JAXWSSupport getJAXWSSupport() {
        return JAXWSSupport.getJAXWSSupport((FileObject)this.srcRoot);
    }

    private void setBindings(JAXWSSupport support, WsdlModeler wsdlModeler, Service service) {
        Binding[] extbindings = service.getBindings();
        if (extbindings == null || extbindings.length == 0) {
            wsdlModeler.setJAXBBindings(null);
            return;
        }
        String[] bindingFiles = new String[extbindings.length];
        for (int i = 0; i < extbindings.length; ++i) {
            bindingFiles[i] = extbindings[i].getFileName();
        }
        FileObject bindingsFolder = support.getBindingsFolderForService(this.getNode().getName(), true);
        ArrayList<URL> list = new ArrayList<URL>();
        for (int i = 0; i < bindingFiles.length; ++i) {
            FileObject fo = bindingsFolder.getFileObject(bindingFiles[i]);
            try {
                list.add(fo.getURL());
                continue;
            }
            catch (FileStateInvalidException ex) {
                // empty catch block
            }
        }
        URL[] bindings = new URL[list.size()];
        list.toArray(bindings);
        wsdlModeler.setJAXBBindings(bindings);
    }

    void refreshKeys(boolean downloadWsdl, final boolean refreshImplClass) {
        if (!this.isFromWsdl()) {
            return;
        }
        super.addNotify();
        Object keys = null;
        try {
            JAXWSSupport support = this.getJAXWSSupport();
            if (downloadWsdl) {
                String serviceName = this.getNode().getName();
                FileObject xmlResorcesFo = support.getLocalWsdlFolderForService(serviceName, true);
                FileObject localWsdl = null;
                try {
                    localWsdl = WSUtils.retrieveResource((FileObject)xmlResorcesFo, (URI)new URI(this.service.getWsdlUrl()));
                    FileObject wsdlFolder = this.getWsdlFolderForService(support, serviceName);
                    WSUtils.copyFiles((FileObject)xmlResorcesFo, (FileObject)wsdlFolder);
                }
                catch (URISyntaxException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                catch (UnknownHostException ex) {
                    ErrorManager.getDefault().annotate((Throwable)ex, NbBundle.getMessage(JaxWsClientChildren.class, (String)"MSG_ConnectionProblem"));
                    return;
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().annotate((Throwable)ex, NbBundle.getMessage(JaxWsClientChildren.class, (String)"MSG_ConnectionProblem"));
                    return;
                }
                if (localWsdl != null) {
                    WsdlWrapperHandler handler = null;
                    try {
                        handler = WsdlWrapperGenerator.parse((String)localWsdl.getURL().toExternalForm());
                    }
                    catch (ParserConfigurationException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                    catch (SAXException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                    if (!handler.isServiceElement()) {
                        StreamSource source = new StreamSource(localWsdl.getURL().toExternalForm());
                        try {
                            File wrapperWsdlFile = new File(FileUtil.toFile((FileObject)localWsdl.getParent()), WsdlWrapperGenerator.getWrapperName((URL)localWsdl.getURL()));
                            if (!wrapperWsdlFile.exists()) {
                                try {
                                    wrapperWsdlFile.createNewFile();
                                }
                                catch (IOException ex) {
                                    ErrorManager.getDefault().notify(4096, (Throwable)ex);
                                }
                            }
                            if (wrapperWsdlFile.exists()) {
                                WsdlWrapperGenerator.generateWrapperWSDLContent((File)wrapperWsdlFile, (StreamSource)source, (String)handler.getTargetNsPrefix(), (String)localWsdl.getNameExt());
                            }
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                    }
                }
            }
            FileObject wsdlFo = this.getJAXWSSupport().getLocalWsdlFolderForService(this.service.getName(), false).getFileObject(this.service.getLocalWsdlFile());
            this.wsdlModeler = WsdlModelerFactory.getDefault().getWsdlModeler(wsdlFo.getURL());
            String packageName = this.service.getPackageName();
            if (packageName != null && this.service.isPackageNameForceReplace()) {
                this.wsdlModeler.setPackageName(packageName);
            } else {
                this.wsdlModeler.setPackageName(null);
            }
            this.wsdlModeler.setCatalog(support.getCatalog());
            this.setBindings(support, this.wsdlModeler, this.service);
            this.regenerateJavaArtifacts();
            this.modelGenerationFinished = false;
            ((JaxWsNode)this.getNode()).changeIcon();
            this.wsdlModeler.generateWsdlModel(new WsdlModelListener(){

                public void modelCreated(WsdlModel model) {
                    JaxWsChildren.this.wsdlModel = model;
                    JaxWsChildren.this.modelGenerationFinished = true;
                    ((JaxWsNode)JaxWsChildren.this.getNode()).changeIcon();
                    if (model == null) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new JaxWsUtils.WsImportServiceFailedMessage(JaxWsChildren.this.wsdlModeler.getCreationException()));
                    }
                    JaxWsChildren.this.updateKeys();
                    if (model != null) {
                        try {
                            JaxWsModel jaxWsModel;
                            Project project;
                            String newPkgName;
                            String javaName;
                            int dotPosition;
                            WsdlPort wsdlPort;
                            String serviceName = JaxWsChildren.this.service.getServiceName();
                            String portName = JaxWsChildren.this.service.getPortName();
                            WsdlService wsdlService = model.getServiceByName(serviceName);
                            boolean jaxWsModelChanged = false;
                            if (wsdlService == null) {
                                wsdlService = (WsdlService)model.getServices().get(0);
                                JaxWsChildren.this.service.setServiceName(wsdlService.getName());
                                jaxWsModelChanged = true;
                            }
                            if ((wsdlPort = wsdlService.getPortByName(portName)) == null) {
                                wsdlPort = (WsdlPort)wsdlService.getPorts().get(0);
                                JaxWsChildren.this.service.setPortName(wsdlPort.getName());
                                jaxWsModelChanged = true;
                            }
                            String oldPkgName = JaxWsChildren.this.service.getPackageName();
                            if (wsdlService != null && oldPkgName != null && !JaxWsChildren.this.service.isPackageNameForceReplace() && (dotPosition = (javaName = wsdlService.getJavaName()).lastIndexOf(".")) >= 0 && !oldPkgName.equals(newPkgName = javaName.substring(0, dotPosition))) {
                                JaxWsChildren.this.service.setPackageName(newPkgName);
                                jaxWsModelChanged = true;
                            }
                            if (jaxWsModelChanged && (project = FileOwnerQuery.getOwner((FileObject)JaxWsChildren.this.srcRoot)) != null && (jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class)) != null) {
                                jaxWsModel.write();
                            }
                            if (refreshImplClass) {
                                FileObject folder;
                                String implClass = JaxWsChildren.this.service.getImplementationClass();
                                FileObject oldImplClass = JaxWsChildren.this.srcRoot.getFileObject(implClass.replace('.', '/') + ".java");
                                FileObject oldCopy = JaxWsChildren.this.srcRoot.getFileObject(implClass.replace('.', '/') + ".java.old");
                                int index = implClass.lastIndexOf(".");
                                FileObject fileObject = folder = index > 0 ? JaxWsChildren.this.srcRoot.getFileObject(implClass.substring(0, index).replace('.', '/')) : JaxWsChildren.this.srcRoot;
                                if (folder != null) {
                                    String name;
                                    String string = name = index >= 0 ? implClass.substring(index + 1) : implClass;
                                    if (oldImplClass != null) {
                                        if (oldCopy != null) {
                                            oldCopy.delete();
                                        }
                                        FileUtil.copyFile((FileObject)oldImplClass, (FileObject)folder, (String)(name + ".java"), (String)"old");
                                        oldImplClass.delete();
                                    }
                                    JaxWsUtils.generateJaxWsImplementationClass(FileOwnerQuery.getOwner((FileObject)JaxWsChildren.this.srcRoot), folder, name, model, JaxWsChildren.this.service);
                                    JaxWsNode parent = (JaxWsNode)JaxWsChildren.this.getNode();
                                    parent.refreshImplClass();
                                }
                            }
                        }
                        catch (Exception ex) {
                            ErrorManager.getDefault().notify(65536, (Throwable)ex);
                        }
                    }
                }
            });
        }
        catch (FileStateInvalidException ex) {
            ErrorManager.getDefault().log(ex.getLocalizedMessage());
        }
    }

    private void regenerateJavaArtifacts() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.srcRoot);
        if (project != null) {
            FileObject buildImplFo = project.getProjectDirectory().getFileObject("nbproject/build-impl.xml");
            try {
                String name = this.service.getName();
                ExecutorTask wsimportTask = ActionUtils.runTarget((FileObject)buildImplFo, (String[])new String[]{"wsimport-service-clean-" + name, "wsimport-service-" + name}, null);
                wsimportTask.waitFinished();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
            catch (IllegalArgumentException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
        }
    }

    public void change(MDRChangeEvent evt) {
        if (evt.getSource() instanceof JavaClass) {
            this.removeMethodListeners();
            this.methods = null;
            this.updateKeys();
        } else if (evt.getSource() instanceof Method && evt instanceof AttributeEvent) {
            AttributeEvent attrEvt = (AttributeEvent)evt;
            int type = attrEvt.getType();
            if (type == 0x1010002) {
                Object newElement = attrEvt.getNewElement();
                if (newElement instanceof Annotation && "javax.jws.WebMethod".equals(((Annotation)newElement).getType().getName())) {
                    this.updateKeys();
                }
            } else if (type == 0x1010004 && "annotations".equals(attrEvt.getAttributeName())) {
                this.updateKeys();
            } else if (type == 0x1010001 && "modifiers".equals(attrEvt.getAttributeName())) {
                this.updateKeys();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject getWsdlFolderForService(JAXWSSupport support, String name) throws IOException {
        FileObject globalWsdlFolder = support.getWsdlFolder(true);
        FileObject oldWsdlFolder = globalWsdlFolder.getFileObject(name);
        if (oldWsdlFolder != null) {
            FileLock lock = oldWsdlFolder.lock();
            try {
                oldWsdlFolder.delete(lock);
            }
            finally {
                lock.releaseLock();
            }
        }
        return globalWsdlFolder.createFolder(name);
    }

    WsdlModeler getWsdlModeler() {
        return this.wsdlModeler;
    }

    boolean isModelGenerationFinished() {
        return this.modelGenerationFinished;
    }

    static /* synthetic */ Method[] access$602(JaxWsChildren x0, Method[] x1) {
        x0.methods = x1;
        return x1;
    }

    public static class WSComponentMethodViewStrategy
    implements ComponentMethodViewStrategy {
        private static WSComponentMethodViewStrategy wsmvStrategy;

        private WSComponentMethodViewStrategy() {
        }

        public static WSComponentMethodViewStrategy instance() {
            if (wsmvStrategy == null) {
                wsmvStrategy = new WSComponentMethodViewStrategy();
            }
            return wsmvStrategy;
        }

        public Image getBadge(Method method, Collection interfaces) {
            return null;
        }

        public void deleteImplMethod(Method m, JavaClass implClass, Collection interfaces) throws IOException {
            for (JavaClass intf : interfaces) {
                try {
                    intf.getContents().remove(m);
                }
                catch (JmiException e) {
                    throw new IOException(e.getMessage());
                }
            }
            Method[] methods = JMIUtils.getMethods((JavaClass)implClass);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!JMIUtils.equalMethods((Method)m, (Method)method)) continue;
                try {
                    implClass.getContents().remove(method);
                    break;
                }
                catch (JmiException e) {
                    throw new IOException(e.getMessage());
                }
            }
        }

        public OpenCookie getOpenCookie(Method m, JavaClass implClass, Collection interfaces) {
            Method[] methods = JMIUtils.getMethods((JavaClass)implClass);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!JMIUtils.equalMethods((Method)m, (Method)method)) continue;
                return (OpenCookie)JMIUtils.getCookie((Feature)method, OpenCookie.class);
            }
            return null;
        }

        public Image getIcon(Method me, Collection interfaces) {
            return Utilities.loadImage((String)"org/openide/src/resources/methodPublic.gif");
        }
    }
}

