/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsdl.validator;

import java.io.IOException;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationOutputWindow {
    OutputWriter normalWriter;
    OutputWriter errorWriter;

    public ValidationOutputWindow() {
        this.initialize();
    }

    public void displayValidationInformation(List<Validator.ResultItem> validationInformation) {
        for (Validator.ResultItem resultItem : validationInformation) {
            Validator.ResultType resultType = resultItem.getType();
            Component component = resultItem.getComponents();
            try {
                if (resultType.equals((Object)Validator.ResultType.ERROR)) {
                    this.showError(resultItem);
                } else if (resultType.equals((Object)Validator.ResultType.WARNING)) {
                    this.showWarning(resultItem);
                } else if (resultType.equals((Object)Validator.ResultType.ADVICE)) {
                    this.showAdvice(resultItem);
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            this.normalWriter.println("");
        }
        this.printCountSummary(validationInformation);
    }

    private void initialize() {
        InputOutput io = IOProvider.getDefault().getIO(NbBundle.getMessage(ValidationOutputWindow.class, (String)"TITLE_XML_check_window"), false);
        this.normalWriter = io.getOut();
        this.errorWriter = io.getErr();
    }

    private void showError(Validator.ResultItem resultItem) throws IOException {
        ValidationOutputListener listener = new ValidationOutputListener(resultItem);
        this.errorWriter.println(this.getFileName(resultItem) + ":" + this.getLineNumber(resultItem) + "," + this.getColumnNumber(resultItem), (OutputListener)listener, true);
        this.errorWriter.println(resultItem.getDescription());
    }

    private void showWarning(Validator.ResultItem resultItem) throws IOException {
        ValidationOutputListener listener = new ValidationOutputListener(resultItem);
        this.errorWriter.println(this.getFileName(resultItem) + ":" + this.getLineNumber(resultItem) + "," + this.getColumnNumber(resultItem), (OutputListener)listener, false);
        this.errorWriter.println(resultItem.getDescription());
    }

    private void showAdvice(Validator.ResultItem resultItem) throws IOException {
        this.normalWriter.println(this.getFileName(resultItem) + " :" + this.getLineNumber(resultItem) + "," + this.getColumnNumber(resultItem));
        this.normalWriter.println(resultItem.getDescription());
    }

    private String getFileName(Validator.ResultItem resultItem) {
        assert (resultItem.getModel() != null) : "Model associated with ResultItem is null";
        String fileName = ((FileObject)resultItem.getModel().getModelSource().getLookup().lookup(FileObject.class)).getPath();
        return fileName;
    }

    private StyledDocument getStyledDocument(Component component) {
        boolean position = false;
        DataObject dobj = null;
        try {
            dobj = DataObject.find((FileObject)((FileObject)component.getModel().getModelSource().getLookup().lookup(FileObject.class)));
        }
        catch (DataObjectNotFoundException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        CloneableEditorSupport editor = (CloneableEditorSupport)dobj.getCookie(EditorCookie.class);
        StyledDocument doc = editor.getDocument();
        return doc;
    }

    private int getLineNumber(Validator.ResultItem resultItem) {
        int lineNumber;
        if (resultItem.getComponents() != null) {
            StyledDocument doc = this.getStyledDocument(resultItem.getComponents());
            int position = this.getPosition(resultItem.getComponents());
            lineNumber = NbDocument.findLineNumber((StyledDocument)doc, (int)position) + 1;
        } else {
            lineNumber = resultItem.getLineNumber();
        }
        return lineNumber;
    }

    private int getColumnNumber(Validator.ResultItem resultItem) {
        int columnNumber;
        if (resultItem.getComponents() != null) {
            StyledDocument doc = this.getStyledDocument(resultItem.getComponents());
            int position = this.getPosition(resultItem.getComponents());
            columnNumber = NbDocument.findLineColumn((StyledDocument)doc, (int)position);
        } else {
            columnNumber = resultItem.getColumnNumber();
        }
        return columnNumber;
    }

    private int getPosition(Component component) {
        int position = 0;
        if (component instanceof DocumentComponent) {
            position = ((DocumentComponent)component).findPosition();
        }
        return position;
    }

    private void printCountSummary(List<Validator.ResultItem> validationInformation) {
        int warnings = 0;
        int errors = 0;
        for (Validator.ResultItem resultItem : validationInformation) {
            if (resultItem.getType().equals((Object)Validator.ResultType.ERROR)) {
                ++errors;
                continue;
            }
            if (!resultItem.getType().equals((Object)Validator.ResultType.WARNING)) continue;
            ++warnings;
        }
        this.normalWriter.println(errors + " Error(s),  " + warnings + " Warning(s).");
    }

    private final class ValidationOutputListener
    implements OutputListener {
        FileObject fileObject;
        Validator.ResultItem resultItem;

        public ValidationOutputListener(Validator.ResultItem resultItem) {
            this.fileObject = (FileObject)resultItem.getModel().getModelSource().getLookup().lookup(FileObject.class);
            this.resultItem = resultItem;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            try {
                DataObject dataObject = DataObject.find((FileObject)this.fileObject);
                if (dataObject == null) {
                    return;
                }
                CloneableEditorSupport editor = (CloneableEditorSupport)dataObject.getCookie(EditorCookie.class);
                JEditorPane[] panes = editor.getOpenedPanes();
                boolean focusFound = false;
                if (panes.length > 0) {
                    for (int i = 0; i < panes.length; ++i) {
                        JEditorPane pane = panes[i];
                        if (!pane.hasFocus()) continue;
                        this.setCaretPosition(pane);
                        focusFound = true;
                        break;
                    }
                    if (!focusFound) {
                        JEditorPane pane = panes[0];
                        pane.requestFocusInWindow();
                        this.setCaretPosition(pane);
                    }
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }

        private void setCaretPosition(JEditorPane pane) {
            Component component = this.resultItem.getComponents();
            if (component instanceof WSDLComponent) {
                int position = ((WSDLComponent)component).findPosition();
                pane.setCaretPosition(position);
            } else {
                int line = this.resultItem.getLineNumber();
                try {
                    int position = NbDocument.findLineOffset((StyledDocument)((StyledDocument)pane.getDocument()), (int)line);
                    pane.setCaretPosition(position);
                }
                catch (IndexOutOfBoundsException iob) {
                    // empty catch block
                }
            }
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }
}

