/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.VMDisconnectedException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.NodeModelFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MonitorModel
implements TreeModelFilter,
NodeModelFilter,
NodeActionsProviderFilter,
TableModel,
Constants {
    public static final String CONTENDED_MONITOR = "org/netbeans/modules/debugger/resources/allInOneView/ContendedMonitor";
    public static final String OWNED_MONITORS = "org/netbeans/modules/debugger/resources/allInOneView/OwnedMonitors";
    public static final String MONITOR = "org/netbeans/modules/debugger/resources/allInOneView/Monitor";
    private RequestProcessor evaluationRP = new RequestProcessor();
    private final Collection modelListeners = new HashSet();
    private Map shortDescriptionMap = new HashMap();

    public Object getRoot(TreeModel model) {
        return model.getRoot();
    }

    public Object[] getChildren(TreeModel model, Object o, int from, int to) throws UnknownTypeException {
        if (o instanceof ThreadWithBordel) {
            try {
                JPDAThread t = ((ThreadWithBordel)o).originalThread;
                ObjectVariable contended = t.getContendedMonitor();
                ObjectVariable[] owned = t.getOwnedMonitors();
                int i = 0;
                Object[] os = new Object[to - from];
                if (contended != null && from == 0 && to > 0) {
                    os[i++] = new ContendedMonitor(contended);
                }
                if (owned.length > 0 && (contended != null && from < 2 && to > 1 || contended == null && from == 0 && to > 0)) {
                    os[i++] = new OwnedMonitors(owned);
                }
                return os;
            }
            catch (ObjectCollectedException e) {
            }
            catch (VMDisconnectedException e) {
                // empty catch block
            }
            return new Object[0];
        }
        if (o instanceof JPDAThreadGroup) {
            JPDAThreadGroup tg = (JPDAThreadGroup)o;
            Object[] ch = model.getChildren(o, from, to);
            int k = ch.length;
            for (int i = 0; i < k; ++i) {
                if (!(ch[i] instanceof JPDAThread)) continue;
                try {
                    JPDAThread t = (JPDAThread)ch[i];
                    if (t.getContendedMonitor() == null && t.getOwnedMonitors().length == 0) continue;
                    ThreadWithBordel twb = new ThreadWithBordel();
                    twb.originalThread = t;
                    ch[i] = twb;
                    continue;
                }
                catch (ObjectCollectedException e) {
                    continue;
                }
                catch (VMDisconnectedException e) {
                    // empty catch block
                }
            }
            return ch;
        }
        if (o instanceof OwnedMonitors) {
            OwnedMonitors om = (OwnedMonitors)o;
            Object[] fo = new Object[to - from];
            System.arraycopy(om.variables, from, fo, 0, to - from);
            return fo;
        }
        return model.getChildren(o, from, to);
    }

    public int getChildrenCount(TreeModel model, Object o) throws UnknownTypeException {
        if (o instanceof ThreadWithBordel) {
            try {
                JPDAThread t = ((ThreadWithBordel)o).originalThread;
                ObjectVariable contended = t.getContendedMonitor();
                ObjectVariable[] owned = t.getOwnedMonitors();
                int i = 0;
                if (contended != null) {
                    ++i;
                }
                if (owned.length > 0) {
                    ++i;
                }
                return i;
            }
            catch (ObjectCollectedException e) {
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
            return 0;
        }
        if (o instanceof ThreadWithBordel) {
            return model.getChildrenCount((Object)((ThreadWithBordel)o).originalThread);
        }
        if (o instanceof OwnedMonitors) {
            return ((OwnedMonitors)o).variables.length;
        }
        return model.getChildrenCount(o);
    }

    public boolean isLeaf(TreeModel model, Object o) throws UnknownTypeException {
        if (o instanceof ThreadWithBordel) {
            return false;
        }
        if (o instanceof OwnedMonitors) {
            return false;
        }
        if (o instanceof ContendedMonitor) {
            return true;
        }
        if (o instanceof ObjectVariable) {
            return true;
        }
        return model.isLeaf(o);
    }

    public String getDisplayName(NodeModel model, Object o) throws UnknownTypeException {
        if (o instanceof ContendedMonitor) {
            ObjectVariable v = ((ContendedMonitor)o).variable;
            return MessageFormat.format(NbBundle.getBundle((Class)MonitorModel.class).getString("CTL_MonitorModel_Column_ContendedMonitor"), v.getType(), v.getValue());
        }
        if (o instanceof ThreadWithBordel) {
            return model.getDisplayName((Object)((ThreadWithBordel)o).originalThread);
        }
        if (o instanceof OwnedMonitors) {
            return NbBundle.getBundle((Class)MonitorModel.class).getString("CTL_MonitorModel_Column_OwnedMonitors");
        }
        if (o instanceof ObjectVariable) {
            ObjectVariable v = (ObjectVariable)o;
            return MessageFormat.format(NbBundle.getBundle((Class)MonitorModel.class).getString("CTL_MonitorModel_Column_Monitor"), v.getType(), v.getValue());
        }
        return model.getDisplayName(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortDescription(final NodeModel model, final Object o) throws UnknownTypeException {
        Map map = this.shortDescriptionMap;
        synchronized (map) {
            Object shortDescription = this.shortDescriptionMap.remove(o);
            if (shortDescription instanceof String) {
                return (String)shortDescription;
            }
            if (shortDescription instanceof UnknownTypeException) {
                throw (UnknownTypeException)((Object)shortDescription);
            }
        }
        this.evaluationRP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object shortDescription;
                ObjectVariable v;
                if (o instanceof ContendedMonitor) {
                    v = ((ContendedMonitor)o).variable;
                    try {
                        shortDescription = "(" + v.getType() + ") " + v.getToStringValue();
                    }
                    catch (InvalidExpressionException ex) {
                        shortDescription = ex.getLocalizedMessage();
                    }
                } else if (o instanceof ThreadWithBordel) {
                    try {
                        shortDescription = model.getShortDescription((Object)((ThreadWithBordel)o).originalThread);
                    }
                    catch (UnknownTypeException utex) {
                        shortDescription = utex;
                    }
                } else if (o instanceof OwnedMonitors) {
                    shortDescription = "";
                } else if (o instanceof ObjectVariable) {
                    v = (ObjectVariable)o;
                    try {
                        shortDescription = "(" + v.getType() + ") " + v.getToStringValue();
                    }
                    catch (InvalidExpressionException ex) {
                        shortDescription = ex.getLocalizedMessage();
                    }
                } else {
                    try {
                        shortDescription = model.getShortDescription(o);
                    }
                    catch (UnknownTypeException utex) {
                        shortDescription = utex;
                    }
                }
                if (shortDescription != null && !"".equals(shortDescription)) {
                    Map map = MonitorModel.this.shortDescriptionMap;
                    synchronized (map) {
                        MonitorModel.this.shortDescriptionMap.put(o, shortDescription);
                    }
                    MonitorModel.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)MonitorModel.this, o, 4));
                }
            }
        });
        return "";
    }

    public String getIconBase(NodeModel model, Object o) throws UnknownTypeException {
        if (o instanceof ContendedMonitor) {
            return CONTENDED_MONITOR;
        }
        if (o instanceof ThreadWithBordel) {
            return model.getIconBase((Object)((ThreadWithBordel)o).originalThread);
        }
        if (o instanceof OwnedMonitors) {
            return OWNED_MONITORS;
        }
        if (o instanceof ObjectVariable) {
            return MONITOR;
        }
        return model.getIconBase(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelChange(ModelEvent me) {
        Object[] listeners;
        Collection collection = this.modelListeners;
        synchronized (collection) {
            listeners = this.modelListeners.toArray();
        }
        for (int i = 0; i < listeners.length; ++i) {
            ((ModelListener)listeners[i]).modelChanged(me);
        }
    }

    public Action[] getActions(NodeActionsProvider model, Object o) throws UnknownTypeException {
        if (o instanceof ContendedMonitor) {
            return new Action[0];
        }
        if (o instanceof OwnedMonitors) {
            return new Action[0];
        }
        if (o instanceof ThreadWithBordel) {
            return model.getActions((Object)((ThreadWithBordel)o).originalThread);
        }
        if (o instanceof ObjectVariable) {
            return new Action[0];
        }
        return model.getActions(o);
    }

    public void performDefaultAction(NodeActionsProvider model, Object o) throws UnknownTypeException {
        if (o instanceof ContendedMonitor) {
            return;
        }
        if (o instanceof OwnedMonitors) {
            return;
        }
        if (o instanceof ThreadWithBordel) {
            model.performDefaultAction((Object)((ThreadWithBordel)o).originalThread);
            return;
        }
        if (o instanceof ObjectVariable) {
            return;
        }
        model.performDefaultAction(o);
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node instanceof ThreadWithBordel) {
            if (columnID == "ThreadState") {
                return "";
            }
            if (columnID == "ThreadSuspended") {
                return null;
            }
        }
        if (node instanceof OwnedMonitors && columnID == "ThreadState") {
            return "";
        }
        if (columnID == "ThreadSuspended") {
            return null;
        }
        if (node instanceof ContendedMonitor && columnID == "ThreadState") {
            return "";
        }
        if (columnID == "ThreadSuspended") {
            return null;
        }
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if (columnID == "ThreadState" || columnID == "ThreadSuspended") {
            if (node instanceof ThreadWithBordel) {
                return true;
            }
            if (node instanceof OwnedMonitors) {
                return true;
            }
            if (node instanceof ContendedMonitor) {
                return true;
            }
        }
        throw new UnknownTypeException(node);
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
    }

    static class ThreadWithBordel {
        JPDAThread originalThread;

        ThreadWithBordel() {
        }
    }

    private static class ContendedMonitor {
        ObjectVariable variable;

        ContendedMonitor(ObjectVariable v) {
            this.variable = v;
        }
    }

    private static class OwnedMonitors {
        ObjectVariable[] variables;

        OwnedMonitors(ObjectVariable[] vs) {
            this.variables = vs;
        }
    }
}

