/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.awt.AWTTask;
import org.openide.awt.Actions;
import org.openide.awt.DynaMenuModel;
import org.openide.awt.ExecBridge;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.InstanceSupport;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

public class MenuBar
extends JMenuBar
implements Externalizable {
    private MenuBarFolder menuBarFolder;
    private static final Icon BLANK_ICON = new ImageIcon(Utilities.loadImage((String)"org/openide/loaders/empty.gif"));
    static final long serialVersionUID = -4721949937356581268L;
    static /* synthetic */ Class class$org$openide$awt$MenuBar;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$org$openide$util$actions$Presenter$Toolbar;
    static /* synthetic */ Class class$javax$swing$Action;
    static /* synthetic */ Class class$org$openide$awt$MenuBar$LazyMenu;
    static /* synthetic */ Class class$javax$swing$JMenu;
    static /* synthetic */ Class class$org$openide$util$actions$Presenter$Menu;
    static /* synthetic */ Class class$javax$swing$JMenuItem;
    static /* synthetic */ Class class$javax$swing$JSeparator;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public MenuBar() {
    }

    public MenuBar(DataFolder folder) {
        this();
        DataFolder theFolder;
        boolean GTK = "GTK".equals(UIManager.getLookAndFeel().getID());
        if (!GTK) {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
        if ((theFolder = folder) == null) {
            FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("Menu");
            if (fo == null) {
                throw new IllegalStateException("No Menu/");
            }
            theFolder = DataFolder.findFolder(fo);
        }
        this.startLoading(theFolder);
        if (folder != null) {
            this.getAccessibleContext().setAccessibleDescription(folder.getName());
        }
    }

    public void addImpl(Component c, Object constraint, int idx) {
        if (Utilities.getOperatingSystem() == 4096 && Boolean.getBoolean("apple.laf.useScreenMenuBar") && !(c instanceof JMenu)) {
            return;
        }
        super.addImpl(c, constraint, idx);
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (Utilities.getOperatingSystem() == 4096) {
            boolean isAlt;
            int mods = e.getModifiers();
            boolean isCtrl = (mods & 2) != 0;
            boolean bl = isAlt = (mods & 8) != 0;
            if (isAlt) {
                return false;
            }
            if (isAlt && !isCtrl) {
                mods &= 0xFFFFFFF7;
                mods &= 0xFFFFFDFF;
                mods |= 2;
                mods |= 0x80;
            } else if (!isAlt && isCtrl) {
                mods &= 0xFFFFFFFD;
                mods &= 0xFFFFFF7F;
                mods |= 8;
                mods |= 0x200;
            } else if (!isAlt && !isCtrl) {
                return super.processKeyBinding(ks, e, condition, pressed);
            }
            MarkedKeyEvent newEvent = new MarkedKeyEvent((Component)e.getSource(), e.getID(), e.getWhen(), mods, e.getKeyCode(), e.getKeyChar(), e.getKeyLocation());
            KeyStroke newStroke = e.getID() == 400 ? KeyStroke.getKeyStroke((int)ks.getKeyChar(), mods) : KeyStroke.getKeyStroke(ks.getKeyCode(), mods, !ks.isOnKeyRelease());
            boolean result = super.processKeyBinding(newStroke, newEvent, condition, pressed);
            if (newEvent.isConsumed()) {
                e.consume();
            }
            return result;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public void waitFinished() {
        this.menuBarFolder.instanceFinished();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.menuBarFolder.getFolder());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.startLoading((DataFolder)in.readObject());
    }

    void startLoading(DataFolder folder) {
        this.menuBarFolder = new MenuBarFolder(folder);
    }

    static void allInstances(InstanceCookie[] arr, List list) {
        ErrorManager err = ErrorManager.getDefault();
        Exception ex = null;
        for (int i = 0; i < arr.length; ++i) {
            Exception newEx = null;
            try {
                Object o = arr[i].instanceCreate();
                list.add(o);
            }
            catch (ClassNotFoundException e) {
                newEx = e;
            }
            catch (IOException e) {
                newEx = e;
            }
            if (newEx == null) continue;
            ErrorManager.Annotation[] anns = err.findAnnotations((Throwable)newEx);
            if (anns == null || anns.length == 0) {
                err.annotate((Throwable)newEx, 1, null, null, null, null);
            }
            err.copyAnnotation((Throwable)newEx, ex);
            ex = newEx;
        }
        if (ex != null) {
            err.notify(ex);
        }
    }

    private static class LazyMenu
    extends JMenu
    implements NodeListener,
    Runnable,
    ChangeListener {
        DataFolder master;
        boolean icon;
        MenuFolder slave;
        DynaMenuModel dynaModel;
        private boolean selected = false;

        public LazyMenu(DataFolder df, boolean icon) {
            this.master = df;
            this.icon = icon;
            this.dynaModel = new DynaMenuModel();
            this.slave = new MenuFolder();
            Node n = this.master.getNodeDelegate();
            n.addNodeListener(NodeOp.weakNodeListener((NodeListener)this, (Object)n));
            this.updateProps();
            this.getModel().addChangeListener(this);
        }

        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            if (Utilities.getOperatingSystem() == 4096) {
                boolean isAlt;
                int mods = e.getModifiers();
                boolean isCtrl = (mods & 2) != 0;
                boolean bl = isAlt = (mods & 8) != 0;
                if (isAlt && e instanceof MarkedKeyEvent) {
                    mods &= 0xFFFFFFFD;
                    mods &= 0xFFFFFF7F;
                    mods |= 8;
                    MarkedKeyEvent newEvent = new MarkedKeyEvent((Component)e.getSource(), e.getID(), e.getWhen(), mods |= 0x200, e.getKeyCode(), e.getKeyChar(), e.getKeyLocation());
                    KeyStroke newStroke = e.getID() == 400 ? KeyStroke.getKeyStroke((int)ks.getKeyChar(), mods) : KeyStroke.getKeyStroke(ks.getKeyCode(), mods, !ks.isOnKeyRelease());
                    boolean result = super.processKeyBinding(newStroke, newEvent, condition, pressed);
                    if (newEvent.isConsumed()) {
                        e.consume();
                    }
                    return result;
                }
                if (!isAlt) {
                    return super.processKeyBinding(ks, e, condition, pressed);
                }
                return false;
            }
            return super.processKeyBinding(ks, e, condition, pressed);
        }

        private void updateProps() {
            if (this.master.isValid()) {
                Node n = this.master.getNodeDelegate();
                Actions.setMenuText((AbstractButton)this, (String)n.getDisplayName(), (boolean)true);
                if (this.icon) {
                    this.setIcon(new ImageIcon(n.getIcon(1)));
                }
            } else {
                this.setText(this.master.getName());
                this.setIcon(null);
            }
        }

        public void run() {
            this.updateProps();
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if ("displayName".equals(ev.getPropertyName()) || "name".equals(ev.getPropertyName()) || "icon".equals(ev.getPropertyName())) {
                if (EventQueue.isDispatchThread()) {
                    this.updateProps();
                } else {
                    EventQueue.invokeLater(this);
                }
            }
        }

        public void childrenAdded(NodeMemberEvent ev) {
        }

        public void childrenRemoved(NodeMemberEvent ev) {
        }

        public void childrenReordered(NodeReorderEvent ev) {
        }

        public void nodeDestroyed(NodeEvent ev) {
        }

        public void stateChanged(ChangeEvent event) {
            if (this.selected) {
                this.selected = false;
            } else {
                this.selected = true;
                this.doInitialize();
                this.dynaModel.checkSubmenu(this);
            }
        }

        private void doInitialize() {
            this.slave.waitFinishedSuper();
        }

        private class MenuFolder
        extends FolderInstance {
            public MenuFolder() {
                super(LazyMenu.this.master);
            }

            public String instanceName() {
                return (class$org$openide$awt$MenuBar$LazyMenu == null ? (class$org$openide$awt$MenuBar$LazyMenu = MenuBar.class$("org.openide.awt.MenuBar$LazyMenu")) : class$org$openide$awt$MenuBar$LazyMenu).getName();
            }

            public Class instanceClass() {
                return class$javax$swing$JMenu == null ? (class$javax$swing$JMenu = MenuBar.class$("javax.swing.JMenu")) : class$javax$swing$JMenu;
            }

            public Object instanceCreate() throws IOException, ClassNotFoundException {
                return LazyMenu.this;
            }

            public void waitFinished() {
            }

            void waitFinishedSuper() {
                super.waitFinished();
            }

            protected InstanceCookie acceptDataObject(DataObject dob) {
                InstanceCookie ic = super.acceptDataObject(dob);
                if (ic == null) {
                    JMenuItem item = ExecBridge.createMenuItem(dob);
                    return item != null ? new InstanceSupport.Instance(item) : null;
                }
                return ic;
            }

            protected InstanceCookie acceptCookie(InstanceCookie cookie) throws IOException, ClassNotFoundException {
                Class c;
                boolean is = (class$org$openide$util$actions$Presenter$Menu == null ? (class$org$openide$util$actions$Presenter$Menu = MenuBar.class$("org.openide.util.actions.Presenter$Menu")) : class$org$openide$util$actions$Presenter$Menu).isAssignableFrom(c = cookie.instanceClass()) || (class$javax$swing$JMenuItem == null ? (class$javax$swing$JMenuItem = MenuBar.class$("javax.swing.JMenuItem")) : class$javax$swing$JMenuItem).isAssignableFrom(c) || (class$javax$swing$JSeparator == null ? (class$javax$swing$JSeparator = MenuBar.class$("javax.swing.JSeparator")) : class$javax$swing$JSeparator).isAssignableFrom(c) || (class$javax$swing$Action == null ? (class$javax$swing$Action = MenuBar.class$("javax.swing.Action")) : class$javax$swing$Action).isAssignableFrom(c);
                return is ? cookie : null;
            }

            protected InstanceCookie acceptFolder(DataFolder df) {
                boolean hasIcon = df.getPrimaryFile().getAttribute("SystemFileSystem.icon") != null;
                return new LazyMenu((DataFolder)df, (boolean)hasIcon).slave;
            }

            protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
                LazyMenu m = LazyMenu.this;
                LinkedList cInstances = new LinkedList();
                MenuBar.allInstances(cookies, cInstances);
                m.removeAll();
                if (cInstances.isEmpty()) {
                    JMenuItem item = new JMenuItem(NbBundle.getMessage((Class)(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = MenuBar.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject), (String)"CTL_EmptyMenu"));
                    item.setEnabled(false);
                    m.add(item);
                }
                m.dynaModel.loadSubmenu(cInstances, m);
                return m;
            }

            private List alignVertically(List menuItems) {
                ArrayList<JMenuItem> result = new ArrayList<JMenuItem>(menuItems.size());
                JMenuItem curItem = null;
                Iterator iter = menuItems.iterator();
                while (iter.hasNext()) {
                    curItem = (JMenuItem)iter.next();
                    if (curItem != null && curItem.getIcon() == null) {
                        curItem.setIcon(BLANK_ICON);
                    }
                    result.add(curItem);
                }
                return result;
            }

            protected Task postCreationTask(Runnable run) {
                return new AWTTask(run);
            }
        }
    }

    private static final class MarkedKeyEvent
    extends KeyEvent {
        public MarkedKeyEvent(Component c, int id, long when, int mods, int code, char kchar, int loc) {
            super(c, id, when, mods, code, kchar, loc);
        }
    }

    private final class MenuBarFolder
    extends FolderInstance {
        private ArrayList managed;

        public MenuBarFolder(DataFolder folder) {
            super(folder);
            this.managed = new ArrayList();
            this.recreate();
        }

        private void cleanUp() {
            Iterator it = this.managed.iterator();
            while (it.hasNext()) {
                MenuBar.this.remove((Component)it.next());
            }
            this.managed.clear();
        }

        private void addComponent(Component c) {
            MenuBar.this.add(c, this.managed.size());
            this.managed.add(c);
        }

        public String instanceName() {
            return (class$org$openide$awt$MenuBar == null ? (class$org$openide$awt$MenuBar = MenuBar.class$("org.openide.awt.MenuBar")) : class$org$openide$awt$MenuBar).getName();
        }

        public Class instanceClass() {
            return class$org$openide$awt$MenuBar == null ? (class$org$openide$awt$MenuBar = MenuBar.class$("org.openide.awt.MenuBar")) : class$org$openide$awt$MenuBar;
        }

        protected InstanceCookie acceptCookie(InstanceCookie cookie) throws IOException, ClassNotFoundException {
            Class cls;
            boolean is = (class$java$awt$Component == null ? (class$java$awt$Component = MenuBar.class$("java.awt.Component")) : class$java$awt$Component).isAssignableFrom(cls = cookie.instanceClass()) || (class$org$openide$util$actions$Presenter$Toolbar == null ? (class$org$openide$util$actions$Presenter$Toolbar = MenuBar.class$("org.openide.util.actions.Presenter$Toolbar")) : class$org$openide$util$actions$Presenter$Toolbar).isAssignableFrom(cls) || (class$javax$swing$Action == null ? (class$javax$swing$Action = MenuBar.class$("javax.swing.Action")) : class$javax$swing$Action).isAssignableFrom(cls);
            return is ? cookie : null;
        }

        protected InstanceCookie acceptFolder(DataFolder df) {
            return new LazyMenu((DataFolder)df, (boolean)false).slave;
        }

        protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
            LinkedList ll = new LinkedList();
            MenuBar.allInstances(cookies, ll);
            MenuBar mb = MenuBar.this;
            if (ll.equals(Arrays.asList(mb.getComponents()))) {
                return mb;
            }
            this.cleanUp();
            Iterator it = ll.iterator();
            while (it.hasNext()) {
                Component component = this.convertToComponent(it.next());
                if (component == null) continue;
                this.addComponent(component);
            }
            mb.validate();
            mb.repaint();
            return mb;
        }

        private Component convertToComponent(Object obj) {
            Component retVal = null;
            if (obj instanceof Component) {
                retVal = (Component)obj;
            } else if (obj instanceof Presenter.Toolbar) {
                retVal = ((Presenter.Toolbar)obj).getToolbarPresenter();
            } else if (obj instanceof Action) {
                Action a = (Action)obj;
                JButton button = new JButton();
                Actions.connect((AbstractButton)button, (Action)a);
                retVal = button;
            }
            if (retVal instanceof JButton) {
                ((JButton)retVal).setBorderPainted(false);
                ((JButton)retVal).setMargin(new Insets(0, 2, 0, 2));
            }
            return retVal;
        }

        DataFolder getFolder() {
            return this.folder;
        }

        protected Task postCreationTask(Runnable run) {
            return new AWTTask(run);
        }
    }
}

