/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.config.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.netbeans.modules.j2ee.sun.share.config.ui.PanelFocusCookie;
import org.netbeans.modules.j2ee.sun.share.config.ui.PanelView;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public abstract class AbstractDesignEditor
extends TopComponent
implements PanelFocusCookie,
ExplorerManager.Provider {
    public static final int DEFAULT_WIDTH = 400;
    public static final int DEFAULT_HEIGHT = 400;
    protected static EmptyInspectorNode emptyInspectorNode;
    private static final String EMPTY_INSPECTOR_ICON_BASE = "/org/netbeans/modules/form/resources/emptyInspector";
    private ExplorerManager manager = null;
    protected JComponent structureView;
    protected JComponent propertiesView;
    protected JComponent contentView;
    protected static String iconURL;
    protected static final long serialVersionUID = 1L;

    protected AbstractDesignEditor() {
    }

    public AbstractDesignEditor(PanelView panel) {
        this.contentView = panel;
        this.contentView.setPreferredSize(new Dimension(400, 400));
        this.initComponents();
        this.setRootContext(panel.getRoot());
    }

    public AbstractDesignEditor(PanelView panel, JComponent structure) {
        this.contentView = panel;
        this.contentView.setPreferredSize(new Dimension(400, 400));
        this.structureView = structure;
        this.initComponents();
        this.setRootContext(panel.getRoot());
    }

    public void setRootContext(Node node) {
        this.getExplorerManager().setRootContext(node);
    }

    protected void initComponents() {
        ExplorerManager manager = this.getExplorerManager();
        emptyInspectorNode = new EmptyInspectorNode();
        manager.setRootContext((Node)emptyInspectorNode);
        this.setIcon(Utilities.loadImage((String)iconURL));
        this.setName("CTL_ComponentPanelTitle");
        this.putClientProperty("TabPolicy", "HideWhenAlone");
        this.setToolTipText("HINT_ComponentPanel");
        manager.addPropertyChangeListener((PropertyChangeListener)new NodeSelectedListener());
        this.setLayout(new BorderLayout());
    }

    public JComponent getContentView() {
        return this.contentView;
    }

    public JComponent getStructureView() {
        if (this.structureView == null) {
            this.structureView = this.createStructureComponent();
        }
        return this.structureView;
    }

    public abstract JComponent createStructureComponent();

    public JComponent getPropertiesView() {
        if (this.propertiesView == null) {
            this.propertiesView = this.createPropertiesComponent();
            this.propertiesView.addPropertyChangeListener(new PropertiesDisplayListener());
        }
        return this.propertiesView;
    }

    public abstract JComponent createPropertiesComponent();

    public void open() {
        if (this.contentView != null) {
            ((PanelView)((Object)this.contentView)).open();
        }
    }

    public boolean canClose() {
        if (this.contentView != null) {
            return ((PanelView)((Object)this.contentView)).canClose();
        }
        return true;
    }

    public boolean setFocusOn(String panelViewNameHint, String panelNameHint, Object focusObject) {
        if (this.contentView != null) {
            return ((PanelView)((Object)this.contentView)).setFocusOn(panelViewNameHint, panelNameHint, focusObject);
        }
        return false;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("ComponentPanel");
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 400);
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
        }
        return this.manager;
    }

    static {
        iconURL = "/org/netbeans/modules/form/resources/inspector.gif";
    }

    static class EmptyInspectorNode
    extends AbstractNode {
        public EmptyInspectorNode() {
            super(Children.LEAF);
            this.setIconBase(AbstractDesignEditor.EMPTY_INSPECTOR_ICON_BASE);
        }

        public boolean canRename() {
            return false;
        }
    }

    class PropertiesDisplayListener
    implements PropertyChangeListener {
        PropertiesDisplayListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("displayWritableOnly".equals(evt.getPropertyName())) {
                // empty if block
            }
        }
    }

    class NodeSelectedListener
    implements PropertyChangeListener {
        NodeSelectedListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!"selectedNodes".equals(evt.getPropertyName())) {
                return;
            }
            Node[] selectedNodes = AbstractDesignEditor.this.getExplorerManager().getSelectedNodes();
        }
    }
}

