/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome;

import java.io.IOException;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;

public class WelcomeOptions {
    private static WelcomeOptions theInstance;
    private static final String PROP_SHOW_ON_STARTUP = "showOnStartup";
    private static final String PROP_FIRST_TIME_START = "firstTimeStart";
    private static final String FOLDER_NAME = "WelcomePage";

    private WelcomeOptions() {
    }

    public static synchronized WelcomeOptions getDefault() {
        if (null == theInstance) {
            theInstance = new WelcomeOptions();
        }
        return theInstance;
    }

    public void setShowOnStartup(boolean show) {
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(FOLDER_NAME);
        if (null != fo) {
            try {
                fo.setAttribute(PROP_SHOW_ON_STARTUP, (Object)show);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    public boolean isShowOnStartup() {
        Object val;
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(FOLDER_NAME);
        if (null != fo && null != (val = fo.getAttribute(PROP_SHOW_ON_STARTUP)) && val instanceof Boolean) {
            return (Boolean)val;
        }
        return true;
    }

    public void setFirstTimeStart(boolean firstTime) {
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(FOLDER_NAME);
        if (null != fo) {
            try {
                fo.setAttribute(PROP_FIRST_TIME_START, (Object)firstTime);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    public boolean isFirstTimeStart() {
        Object val;
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(FOLDER_NAME);
        if (null != fo && null != (val = fo.getAttribute(PROP_FIRST_TIME_START)) && val instanceof Boolean) {
            return (Boolean)val;
        }
        return true;
    }
}

