/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.web;

import com.sun.star.awt.KeyEvent;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XKeyListener;
import com.sun.star.awt.XWindow;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XCloseable;
import com.sun.star.wizards.common.ConfigSet;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.SystemDialog;
import com.sun.star.wizards.ui.UnoDialog;
import com.sun.star.wizards.ui.event.DataAware;
import com.sun.star.wizards.ui.event.ListModelBinder;
import com.sun.star.wizards.ui.event.Task;
import com.sun.star.wizards.ui.event.TaskListener;
import com.sun.star.wizards.web.AbstractErrorHandler;
import com.sun.star.wizards.web.BackgroundsDialog;
import com.sun.star.wizards.web.ErrorHandler;
import com.sun.star.wizards.web.FTPDialog;
import com.sun.star.wizards.web.IconsDialog;
import com.sun.star.wizards.web.ImageListDialog;
import com.sun.star.wizards.web.Process;
import com.sun.star.wizards.web.ProcessErrorHandler;
import com.sun.star.wizards.web.ProcessStatusRenderer;
import com.sun.star.wizards.web.StatusDialog;
import com.sun.star.wizards.web.TOCPreview;
import com.sun.star.wizards.web.WWD_Startup;
import com.sun.star.wizards.web.data.CGDocument;
import com.sun.star.wizards.web.data.CGPublish;
import com.sun.star.wizards.web.data.CGSession;
import com.sun.star.wizards.web.data.CGSessionName;

public abstract class WWD_Events
extends WWD_Startup {
    private static final short[] EMPTY_SHORT_ARRAY = new short[0];
    protected String currentSession = "";
    private static String[] EMPTY_STRING_ARRAY = new String[0];
    private ImageListDialog bgDialog;
    private IconsDialog iconsDialog;
    private TOCPreview docPreview;
    private Process process;
    private boolean exitOnCreate = true;

    public WWD_Events(XMultiServiceFactory xMultiServiceFactory) throws Exception {
        super(xMultiServiceFactory);
        Create create = new Create();
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface((Class)XWindow.class, (Object)this.chkFTP);
        xWindow.addKeyListener((XKeyListener)create);
        xWindow = (XWindow)UnoRuntime.queryInterface((Class)XWindow.class, (Object)this.chkLocalDir);
        xWindow.addKeyListener((XKeyListener)create);
        xWindow = (XWindow)UnoRuntime.queryInterface((Class)XWindow.class, (Object)this.chkZip);
        xWindow.addKeyListener((XKeyListener)create);
    }

    protected void leaveStep(int n, int n2) {
        if (n != 1 || n2 == 2) {
            // empty if block
        }
    }

    protected void enterStep(int n, int n2) {
        if (n == 1) {
            String string = "";
            short[] sArray = (short[])Helper.getUnoPropertyValue((Object)WWD_Events.getModel((Object)this.lstLoadSettings), (String)"SelectedItems");
            string = sArray.length == 0 || sArray[0] == 0 ? "" : ((CGSessionName)((Object)this.settings.cp_SavedSessions.getElementAt((int)sArray[0]))).cp_Name;
            if (!string.equals(this.currentSession)) {
                this.loadSession(string);
            }
        }
        if (n2 == 5) {
            // empty if block
        }
    }

    public void sessionSelected() {
        short[] sArray = (short[])Helper.getUnoPropertyValue((Object)WWD_Events.getModel((Object)this.lstLoadSettings), (String)"SelectedItems");
        WWD_Events.setEnabled((Object)this.btnDelSession, (sArray.length > 0 && sArray[0] > 0 ? 1 : 0) != 0);
    }

    public void loadSession(String string) {
        try {
            StatusDialog statusDialog = this.getStatusDialog();
            Task task = new Task("LoadDocs", "", 10);
            statusDialog.execute((UnoDialog)this, task, this.resources.resLoadingSession);
            task.start();
            this.setSelectedDoc(EMPTY_SHORT_ARRAY);
            Helper.setUnoPropertyValue((Object)WWD_Events.getModel((Object)this.lstDocuments), (String)"SelectedItems", (Object)EMPTY_SHORT_ARRAY);
            Helper.setUnoPropertyValue((Object)WWD_Events.getModel((Object)this.lstDocuments), (String)"StringItemList", (Object)EMPTY_STRING_ARRAY);
            Object object = null;
            if (string.equals("")) {
                object = Configuration.getConfigurationRoot((XMultiServiceFactory)this.xMSF, (String)"/org.openoffice.Office.WebWizard/WebWizard/DefaultSession", (boolean)false);
            } else {
                object = Configuration.getConfigurationRoot((XMultiServiceFactory)this.xMSF, (String)"/org.openoffice.Office.WebWizard/WebWizard/SavedSessions", (boolean)false);
                object = Configuration.getNode((String)string, (Object)object);
            }
            CGSession cGSession = new CGSession();
            cGSession.setRoot((Object)this.settings);
            cGSession.readConfiguration(object, "cp_");
            task.setMax(cGSession.cp_Content.cp_Documents.getSize() * 5 + 7);
            task.advance(true);
            if (string.equals("")) {
                this.setSaveSessionName(cGSession);
            }
            this.mount(cGSession, task, false, statusDialog.xControl);
            this.checkSteps();
            this.currentSession = string;
            while (task.getStatus() <= task.getMax()) {
                task.advance(false);
            }
            task.removeTaskListener((TaskListener)statusDialog);
        }
        catch (Exception exception) {
            this.unexpectedError(exception);
        }
        try {
            this.refreshStylePreview();
            this.updateIconsetText();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void delSession() {
        short[] sArray = (short[])Helper.getUnoPropertyValue((Object)WWD_Events.getModel((Object)this.lstLoadSettings), (String)"SelectedItems");
        if (sArray.length == 0) {
            return;
        }
        if (sArray[0] == 0) {
            return;
        }
        boolean bl = AbstractErrorHandler.showMessage(this.xMSF, this.xControl.getPeer(), this.resources.resDelSessionConfirm, 6);
        if (bl) {
            try {
                String string = (String)this.settings.cp_SavedSessions.getKey((int)sArray[0]);
                Configuration.removeNode((XMultiServiceFactory)this.xMSF, (String)"/org.openoffice.Office.WebWizard/WebWizard/SavedSessions", (String)string);
                this.settings.cp_SavedSessions.remove((int)sArray[0]);
                this.settings.savedSessions.remove(sArray[0] - 1);
                short[] sArray2 = new short[]{0};
                sArray2[0] = this.settings.cp_SavedSessions.getSize() > sArray[0] ? sArray[0] : (short)(sArray[0] - 1);
                if (sArray2[0] == 0) {
                    Helper.setUnoPropertyValue((Object)WWD_Events.getModel((Object)this.btnDelSession), (String)"Enabled", (Object)Boolean.FALSE);
                }
                Helper.setUnoPropertyValue((Object)WWD_Events.getModel((Object)this.lstLoadSettings), (String)"SelectedItems", (Object)sArray2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.unexpectedError(exception);
            }
        }
    }

    public short[] getSelectedDoc() {
        return this.selectedDoc;
    }

    public void setSelectedDoc(short[] sArray) {
        CGDocument cGDocument = this.getDoc(this.selectedDoc);
        CGDocument cGDocument2 = this.getDoc(sArray);
        if (cGDocument2 == null) {
            this.fillExportList(EMPTY_STRING_ARRAY);
        } else if (cGDocument == null || !cGDocument.appType.equals(cGDocument2.appType)) {
            this.fillExportList((Object[])this.settings.getExporters(cGDocument2.appType));
        }
        this.selectedDoc = sArray;
        this.mount((Object)cGDocument2, this.docAware);
        this.disableDocUpDown();
    }

    public void addDocument() {
        String[] stringArray = this.getDocAddDialog().callOpenDialog(true, this.settings.cp_DefaultSession.cp_InDirectory);
        if (stringArray == null) {
            return;
        }
        Task task = new Task("", "", stringArray.length * 5);
        if (stringArray.length > 2) {
            StatusDialog statusDialog = this.getStatusDialog();
            statusDialog.setLabel(this.resources.resValidatingDocuments);
            statusDialog.execute((UnoDialog)this, task, this.resources.prodName);
            LoadDocs loadDocs = new LoadDocs(this.xControl, stringArray, task);
            loadDocs.loadDocuments();
            task.removeTaskListener((TaskListener)statusDialog);
        } else {
            LoadDocs loadDocs = new LoadDocs(this.xControl, stringArray, task);
            loadDocs.loadDocuments();
        }
    }

    public void removeDocument() {
        if (this.selectedDoc.length == 0) {
            return;
        }
        this.settings.cp_DefaultSession.cp_Content.cp_Documents.remove((int)this.selectedDoc[0]);
        while (this.selectedDoc[0] >= this.getDocsCount()) {
            this.selectedDoc[0] = (short)(this.selectedDoc[0] - 1);
        }
        if (this.selectedDoc[0] == -1) {
            this.selectedDoc = EMPTY_SHORT_ARRAY;
        }
        this.docListDA.updateUI();
        this.checkSteps();
    }

    public void docUp() {
        Object object = this.settings.cp_DefaultSession.cp_Content.cp_Documents.getElementAt((int)this.selectedDoc[0]);
        this.settings.cp_DefaultSession.cp_Content.cp_Documents.remove((int)this.selectedDoc[0]);
        this.selectedDoc[0] = (short)(this.selectedDoc[0] - 1);
        this.settings.cp_DefaultSession.cp_Content.cp_Documents.add((int)this.selectedDoc[0], object);
        this.docListDA.updateUI();
        this.disableDocUpDown();
    }

    public void docDown() {
        Object object = this.settings.cp_DefaultSession.cp_Content.cp_Documents.getElementAt((int)this.selectedDoc[0]);
        this.settings.cp_DefaultSession.cp_Content.cp_Documents.remove((int)this.selectedDoc[0]);
        this.selectedDoc[0] = (short)(this.selectedDoc[0] + 1);
        this.settings.cp_DefaultSession.cp_Content.cp_Documents.add((int)this.selectedDoc[0], object);
        this.docListDA.updateUI();
        this.disableDocUpDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chooseBackground() {
        try {
            WWD_Events.setEnabled((Object)this.btnBackgrounds, (boolean)false);
            if (this.bgDialog == null) {
                this.bgDialog = new BackgroundsDialog(this.xMSF, this.settings.cp_BackgroundImages, this.resources);
                this.bgDialog.createWindowPeer(this.xControl.getPeer());
            }
            this.bgDialog.setSelected(this.settings.cp_DefaultSession.cp_Design.cp_BackgroundImage);
            short s = this.bgDialog.executeDialog((UnoDialog)this);
            if (s == 1) {
                this.setBackground(this.bgDialog.getSelected());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            WWD_Events.setEnabled((Object)this.btnBackgrounds, (boolean)true);
        }
    }

    public void setBackground(Object object) {
        if (object == null) {
            object = "";
        }
        this.settings.cp_DefaultSession.cp_Design.cp_BackgroundImage = (String)object;
        this.refreshStylePreview();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chooseIconset() {
        try {
            WWD_Events.setEnabled((Object)this.btnIconSets, (boolean)false);
            if (this.iconsDialog == null) {
                this.iconsDialog = new IconsDialog(this.xMSF, this.settings.cp_IconSets, this.resources);
                this.iconsDialog.createWindowPeer(this.xControl.getPeer());
            }
            this.iconsDialog.setIconset(this.settings.cp_DefaultSession.cp_Design.cp_IconSet);
            short s = this.iconsDialog.executeDialog((UnoDialog)this);
            if (s == 1) {
                this.setIconset(this.iconsDialog.getIconset());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            WWD_Events.setEnabled((Object)this.btnIconSets, (boolean)true);
        }
    }

    public void setIconset(String string) {
        this.settings.cp_DefaultSession.cp_Design.cp_IconSet = string;
        this.updateIconsetText();
    }

    private CGPublish setPublishUrl(String string, String string2, int n) {
        if (string2 == null) {
            return null;
        }
        CGPublish cGPublish = this.getPublisher(string);
        cGPublish.cp_URL = string2;
        cGPublish.cp_Publish = true;
        this.updatePublishUI(n);
        cGPublish.overwriteApproved = true;
        return cGPublish;
    }

    private void updatePublishUI(int n) {
        ((DataAware)this.pubAware.get(n)).updateUI();
        ((DataAware)this.pubAware.get(n + 1)).updateUI();
        this.checkPublish();
    }

    public void setPublishLocalDir() {
        String string = this.showFolderDialog("Local destination directory", "", this.settings.cp_DefaultSession.cp_OutDirectory);
        this.setPublishUrl("local", string, 0);
    }

    public void setFTPPublish() {
        if (this.showFTPDialog(this.getPublisher("ftp"))) {
            this.getPublisher((String)"ftp").cp_Publish = true;
            this.updatePublishUI(2);
        }
    }

    private boolean showFTPDialog(CGPublish cGPublish) {
        try {
            return this.getFTPDialog(cGPublish).execute((UnoDialog)this) == 1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void setZipFilename() {
        SystemDialog systemDialog = this.getZipDialog();
        String string = systemDialog.callStoreDialog(this.settings.cp_DefaultSession.cp_OutDirectory, this.resources.resDefaultArchiveFilename);
        this.setPublishUrl("zip", string, 4);
        this.getPublisher((String)"zip").overwriteApproved = true;
    }

    public void documentPreview() {
        try {
            if (this.docPreview == null) {
                this.docPreview = new TOCPreview(this.xMSF, this.settings, this.resources, this.stylePreview.tempDir, this.myFrame);
            }
            this.docPreview.refresh(this.settings);
        }
        catch (Exception exception) {
            this.unexpectedError(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean publishTargetApproved() {
        String string;
        String string2;
        boolean bl = true;
        CGPublish cGPublish = this.getPublisher("local");
        if (cGPublish.cp_Publish) {
            string2 = this.getFileAccess().getPath(cGPublish.url, null);
            if (this.getFileAccess().exists(cGPublish.url, false)) {
                if (!this.getFileAccess().isDirectory(cGPublish.url)) {
                    String string3 = JavaTools.replaceSubString((String)this.resources.resLocalTargetExistsAsfile, (String)string2, (String)"%FILENAME");
                    AbstractErrorHandler.showMessage(this.xMSF, this.xControl.getPeer(), string3, 1);
                    return false;
                }
                String[] stringArray = this.getFileAccess().listFiles(cGPublish.url, true);
                if (stringArray.length > 0) {
                    string = JavaTools.replaceSubString((String)this.resources.resLocalTragetNotEmpty, (String)string2, (String)"%FILENAME");
                    bl = AbstractErrorHandler.showMessage(this.xMSF, this.xControl.getPeer(), string, "warningbox", 0x1000000, Integer.MIN_VALUE, 2);
                    if (!bl) {
                        return bl;
                    }
                }
            } else {
                String string4 = JavaTools.replaceSubString((String)this.resources.resLocalTargetCreate, (String)string2, (String)"%FILENAME");
                try {
                    bl = AbstractErrorHandler.showMessage(this.xMSF, this.xControl.getPeer(), string4, 7);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (!bl) {
                    return bl;
                }
                try {
                    this.getFileAccess().fileAccess.createFolder(cGPublish.cp_URL);
                }
                catch (Exception exception) {
                    String string5 = JavaTools.replaceSubString((String)this.resources.resLocalTargetCouldNotCreate, (String)string2, (String)"%FILENAME");
                    AbstractErrorHandler.showMessage(this.xMSF, this.xControl.getPeer(), string5, 1);
                    return false;
                }
            }
        }
        cGPublish = this.getPublisher("zip");
        if (cGPublish.cp_Publish) {
            string2 = this.getFileAccess().getPath(cGPublish.cp_URL, null);
            if (this.getFileAccess().exists(cGPublish.cp_URL, false)) {
                if (this.getFileAccess().isDirectory(cGPublish.cp_URL)) {
                    String string6 = JavaTools.replaceSubString((String)this.resources.resZipTargetIsDir, (String)string2, (String)"%FILENAME");
                    AbstractErrorHandler.showMessage(this.xMSF, this.xControl.getPeer(), string6, 1);
                    return false;
                }
                if (!cGPublish.overwriteApproved) {
                    String string7 = JavaTools.replaceSubString((String)this.resources.resZipTargetExists, (String)string2, (String)"%FILENAME");
                    bl = AbstractErrorHandler.showMessage(this.xMSF, this.xControl.getPeer(), string7, 7);
                    if (!bl) {
                        return false;
                    }
                }
            }
        }
        cGPublish = this.getPublisher("ftp");
        if (!cGPublish.cp_Publish) return true;
        string2 = this.getFileAccess().getPath(cGPublish.cp_URL, null);
        if (this.getFileAccess().exists(cGPublish.url, false)) {
            if (this.getFileAccess().isDirectory(cGPublish.url)) {
                String[] stringArray = this.getFileAccess().listFiles(cGPublish.url, true);
                if (stringArray.length <= 0) return true;
                string = JavaTools.replaceSubString((String)this.resources.resFTPTargetNotEmpty, (String)string2, (String)"%FILENAME");
                bl = AbstractErrorHandler.showMessage(this.xMSF, this.xControl.getPeer(), string, 4);
                if (bl) return true;
                return bl;
            }
            String string8 = JavaTools.replaceSubString((String)this.resources.resFTPTargetExistsAsfile, (String)string2, (String)"%FILENAME");
            AbstractErrorHandler.showMessage(this.xMSF, this.xControl.getPeer(), string8, 1);
            return false;
        }
        String string9 = JavaTools.replaceSubString((String)this.resources.resFTPTargetCreate, (String)string2, (String)"%FILENAME");
        bl = AbstractErrorHandler.showMessage(this.xMSF, this.xControl.getPeer(), string9, 7);
        if (!bl) {
            return bl;
        }
        try {
            this.getFileAccess().fileAccess.createFolder(cGPublish.url);
            return true;
        }
        catch (Exception exception) {
            String string10 = JavaTools.replaceSubString((String)this.resources.resFTPTargetCouldNotCreate, (String)string2, (String)"%FILENAME");
            AbstractErrorHandler.showMessage(this.xMSF, this.xControl.getPeer(), string10, 1);
            return false;
        }
    }

    private boolean saveSession() {
        try {
            Object object = null;
            String string = this.getSessionSaveName();
            ConfigSet configSet = this.settings.cp_DefaultSession.cp_Content.cp_Documents;
            for (int i = 0; i < configSet.getSize(); ++i) {
                ((CGDocument)((Object)configSet.getElementAt((int)i))).cp_Index = i;
            }
            Object object2 = Configuration.getConfigurationRoot((XMultiServiceFactory)this.xMSF, (String)"/org.openoffice.Office.WebWizard/WebWizard/SavedSessions", (boolean)true);
            try {
                object = Configuration.getNode((String)string, (Object)object2);
                if (object != null && !AbstractErrorHandler.showMessage(this.xMSF, this.xControl.getPeer(), JavaTools.replaceSubString((String)this.resources.resSessionExists, (String)string, (String)"${NAME}"), 3)) {
                    return false;
                }
                Configuration.removeNode((Object)object2, (String)string);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.settings.cp_DefaultSession.cp_Index = 0;
            object = Configuration.addConfigNode((Object)object2, (String)string);
            this.settings.cp_DefaultSession.cp_Name = string;
            this.settings.cp_DefaultSession.writeConfiguration(object, "cp_");
            this.settings.cp_SavedSessions.reindexSet(object2, string, "Index");
            Configuration.commit((Object)object2);
            this.settings.cp_SavedSessions.clear();
            Object object3 = Configuration.getConfigurationRoot((XMultiServiceFactory)this.xMSF, (String)"/org.openoffice.Office.WebWizard/WebWizard/SavedSessions", (boolean)false);
            this.settings.cp_SavedSessions.readConfiguration(object3, (Object)"cp_");
            this.settings.cp_LastSavedSession = string;
            this.currentSession = string;
            this.settings.cp_LastSavedSession = string;
            this.prepareSessionLists();
            ListModelBinder.fillList((Object)this.lstLoadSettings, (Object[])this.settings.cp_SavedSessions.items(), null);
            ListModelBinder.fillComboBox((Object)this.cbSaveSettings, (Object[])this.settings.savedSessions.items(), null);
            this.selectSession();
            this.currentSession = this.settings.cp_LastSavedSession;
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private String targetStringFor(String string) {
        CGPublish cGPublish = this.getPublisher(string);
        if (cGPublish.cp_Publish) {
            return "\n" + this.getFileAccess().getPath(cGPublish.cp_URL, null);
        }
        return "";
    }

    public void finishWizardFinished() {
        if (this.process.getResult()) {
            String string = this.targetStringFor("local") + this.targetStringFor("zip") + this.targetStringFor("ftp");
            String string2 = JavaTools.replaceSubString((String)this.resources.resFinishedSuccess, (String)string, (String)"%FILENAME");
            AbstractErrorHandler.showMessage(this.xMSF, this.xControl.getPeer(), string2, 9);
            if (this.exitOnCreate) {
                this.xDialog.endExecute();
            }
        } else {
            AbstractErrorHandler.showMessage(this.xMSF, this.xControl.getPeer(), this.resources.resFinishedNoSuccess, 8);
        }
    }

    public void cancel() {
        this.xDialog.endExecute();
    }

    public void finishWizard() {
        this.finishWizard(true);
    }

    public void finishWizard(boolean bl) {
        this.exitOnCreate = bl;
        CGPublish cGPublish = this.getPublisher("ftp");
        if (cGPublish.cp_Publish && !this.proxies && (cGPublish.password == null || cGPublish.password.equals(""))) {
            if (this.showFTPDialog(cGPublish)) {
                this.updatePublishUI(2);
                this.finishWizard2();
            }
        } else {
            this.finishWizard2();
        }
    }

    private void finishWizard2() {
        Object object;
        CGPublish cGPublish = this.getPublisher("local");
        cGPublish.url = cGPublish.cp_URL;
        cGPublish = this.getPublisher("zip");
        String string = JavaTools.replaceSubString((String)cGPublish.cp_URL, (String)"%25", (String)"%");
        string = JavaTools.replaceSubString((String)string, (String)"%2F", (String)"/");
        cGPublish.url = "vnd.sun.star.pkg://" + string + "/";
        cGPublish = this.getPublisher("ftp");
        cGPublish.url = FTPDialog.getFullURL(cGPublish);
        if (!this.publishTargetApproved()) {
            return;
        }
        cGPublish.cp_Publish = this.__ftp;
        if (this.isSaveSession()) {
            if (!this.saveSession()) {
                return;
            }
        } else {
            this.settings.cp_LastSavedSession = "";
        }
        try {
            object = Configuration.getConfigurationRoot((XMultiServiceFactory)this.xMSF, (String)"/org.openoffice.Office.WebWizard/WebWizard", (boolean)true);
            Configuration.set((String)this.settings.cp_LastSavedSession, (String)"LastSavedSession", (Object)object);
            Configuration.commit((Object)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.proxies) {
            cGPublish.cp_Publish = false;
        }
        cGPublish = this.getPublisher("zip");
        if (this.getFileAccess().exists(cGPublish.cp_URL, false)) {
            this.getFileAccess().delete(cGPublish.cp_URL);
        }
        try {
            object = new ProcessErrorHandler(this.xMSF, this.xControl.getPeer(), this.resources);
            this.process = new Process(this.settings, this.xMSF, (ErrorHandler)object);
            StatusDialog statusDialog = this.getStatusDialog();
            statusDialog.setRenderer(new ProcessStatusRenderer(this.resources));
            statusDialog.execute((UnoDialog)this, this.process.myTask, this.resources.prodName);
            this.process.runProcess();
            this.finishWizardFinished();
            this.process.myTask.removeTaskListener((TaskListener)statusDialog);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void cleanup() {
        try {
            this.dpStylePreview.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.stylePreview.cleanup();
        try {
            if (this.bgDialog != null) {
                this.bgDialog.xComponent.dispose();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (this.iconsDialog != null) {
                this.iconsDialog.xComponent.dispose();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (this.ftpDialog != null) {
                this.ftpDialog.xComponent.dispose();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.xComponent.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface((Class)XCloseable.class, (Object)this.myFrame);
            if (xCloseable != null) {
                xCloseable.close(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public class LoadDocs {
        private XControl xC;
        String[] files;
        Task task;

        public LoadDocs(XControl xControl, String[] stringArray, Task task) {
            this.xC = xControl;
            this.files = stringArray;
            this.task = task;
        }

        public void loadDocuments() {
            int n = WWD_Events.this.getSelectedDoc().length > 0 ? WWD_Events.this.selectedDoc[0] + 1 : WWD_Events.this.getDocsCount();
            int n2 = this.files.length > 1 ? 1 : 0;
            int n3 = 0;
            WWD_Events.this.settings.cp_DefaultSession.cp_InDirectory = n2 == 1 ? this.files[0] : FileAccess.getParentDir((String)this.files[0]);
            for (int i = n2; i < this.files.length; ++i) {
                CGDocument cGDocument = new CGDocument();
                cGDocument.setRoot((Object)WWD_Events.this.settings);
                String string = cGDocument.cp_URL = n2 == 0 ? this.files[i] : FileAccess.connectURLs((String)this.files[0], (String)this.files[i]);
                if (WWD_Events.this.checkDocument(cGDocument, this.task, this.xC)) {
                    WWD_Events.this.settings.cp_DefaultSession.cp_Content.cp_Documents.add(n + i - n3 - n2, (Object)cGDocument);
                    continue;
                }
                ++n3;
            }
            if (this.files.length > n2 + n3) {
                WWD_Events.this.setSelectedDoc(new short[]{(short)n});
            }
            WWD_Events.this.docListDA.updateUI();
            WWD_Events.this.checkSteps();
            while (this.task.getStatus() < this.task.getMax()) {
                this.task.advance(false);
            }
        }
    }

    private class Create
    implements XKeyListener {
        long time = 0L;
        int count = 0;

        private Create() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            Boolean bl;
            if (keyEvent.KeyChar == '&') {
                this.time = System.currentTimeMillis();
            } else if (keyEvent.KeyChar == '%' && System.currentTimeMillis() - this.time < 300L && (bl = (Boolean)WWD_Events.this.getControlProperty("btnWizardFinish", "Enabled")).booleanValue()) {
                WWD_Events.this.finishWizard(false);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void disposing(EventObject eventObject) {
        }
    }
}

