Gem::Specification.new do |s|
  s.name = %q{color-tools}
  s.version = "1.3.0"
  s.date = %q{2005-08-07}
  s.summary = %q{color-tools provides colour space definition and manpiulation as well as commonly named RGB colours.}
  s.email = %q{austin@rubyforge.org}
  s.homepage = %q{http://rubyforge.org/projects/ruby-pdf}
  s.rubyforge_project = %q{ruby-pdf}
  s.description = %q{color-tools is a Ruby library to provide RGB, CMYK, and other colourspace support to applications that require it. It also provides 152 named RGB colours. It offers 152 named RGB colours (184 with spelling variations) that are commonly supported and used in HTML, SVG, and X11 applications. A technique for generating a monochromatic contrasting palette is also included.}
  s.autorequire = %q{color}
  s.has_rdoc = true
  s.authors = ["Austin Ziegler"]
  s.files = ["Changelog", "Install", "lib", "metaconfig", "pre-setup.rb", "Rakefile", "README", "setup.rb", "tests", "lib/color", "lib/color.rb", "lib/color/cmyk.rb", "lib/color/css.rb", "lib/color/grayscale.rb", "lib/color/hsl.rb", "lib/color/palette", "lib/color/palette.rb", "lib/color/rgb", "lib/color/rgb-colors.rb", "lib/color/rgb.rb", "lib/color/yiq.rb", "lib/color/palette/gimp.rb", "lib/color/palette/monocontrast.rb", "lib/color/rgb/metallic.rb", "tests/testall.rb", "tests/test_cmyk.rb", "tests/test_css.rb", "tests/test_gimp.rb", "tests/test_grayscale.rb", "tests/test_hsl.rb", "tests/test_monocontrast.rb", "tests/test_rgb.rb", "tests/test_yiq.rb"]
  s.rdoc_options = ["--title", "color-tools", "--main", "README", "--line-numbers"]
  s.extra_rdoc_files = ["README", "Install", "Changelog"]
end
