/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.factory;

import com.sleepycat.bdb.DataIndex;
import com.sleepycat.bdb.DataStore;
import com.sleepycat.bdb.ForeignKeyIndex;
import com.sleepycat.bdb.PrimaryKeyAssigner;
import com.sleepycat.bdb.bind.DataBinding;
import com.sleepycat.bdb.bind.EntityBinding;
import com.sleepycat.bdb.bind.serial.ClassCatalog;
import com.sleepycat.bdb.bind.serial.SerialFormat;
import com.sleepycat.bdb.bind.serial.TupleSerialMarshalledBinding;
import com.sleepycat.bdb.bind.serial.TupleSerialMarshalledKeyExtractor;
import com.sleepycat.bdb.bind.tuple.TupleBinding;
import com.sleepycat.bdb.bind.tuple.TupleFormat;
import com.sleepycat.bdb.bind.tuple.TupleMarshalledBinding;
import com.sleepycat.bdb.collection.StoredMap;
import com.sleepycat.bdb.collection.StoredSortedMap;
import com.sleepycat.db.Db;

public class TupleSerialDbFactory {
    private static final TupleFormat TUPLE_FORMAT = new TupleFormat();
    private ClassCatalog catalog;

    public TupleSerialDbFactory(ClassCatalog classCatalog) {
        this.catalog = classCatalog;
    }

    public final ClassCatalog getCatalog() {
        return this.catalog;
    }

    public DataStore newDataStore(Db db, Class clazz, PrimaryKeyAssigner primaryKeyAssigner) {
        return new DataStore(db, TUPLE_FORMAT, new SerialFormat(this.catalog, clazz), primaryKeyAssigner);
    }

    public DataIndex newDataIndex(DataStore dataStore, Db db, String string, boolean bl, boolean bl2) {
        return new DataIndex(dataStore, db, TUPLE_FORMAT, this.getKeyExtractor(dataStore, string, bl, bl2));
    }

    public ForeignKeyIndex newForeignKeyIndex(DataStore dataStore, Db db, String string, boolean bl, boolean bl2, DataStore dataStore2, int n) {
        return new ForeignKeyIndex(dataStore, db, this.getKeyExtractor(dataStore, string, bl, bl2), dataStore2, n);
    }

    public StoredMap newMap(DataStore dataStore, Class clazz, boolean bl) {
        return new StoredMap(dataStore, this.getKeyBinding(clazz), (EntityBinding)this.getEntityBinding(dataStore), bl);
    }

    public StoredMap newMap(DataIndex dataIndex, Class clazz, boolean bl) {
        return new StoredMap(dataIndex, this.getKeyBinding(clazz), (EntityBinding)this.getEntityBinding(dataIndex.getStore()), bl);
    }

    public StoredSortedMap newSortedMap(DataStore dataStore, Class clazz, boolean bl) {
        return new StoredSortedMap(dataStore, this.getKeyBinding(clazz), (EntityBinding)this.getEntityBinding(dataStore), bl);
    }

    public StoredSortedMap newSortedMap(DataIndex dataIndex, Class clazz, boolean bl) {
        return new StoredSortedMap(dataIndex, this.getKeyBinding(clazz), (EntityBinding)this.getEntityBinding(dataIndex.getStore()), bl);
    }

    private TupleSerialMarshalledKeyExtractor getKeyExtractor(DataStore dataStore, String string, boolean bl, boolean bl2) {
        return new TupleSerialMarshalledKeyExtractor(this.getEntityBinding(dataStore), TUPLE_FORMAT, string, bl, bl2);
    }

    private TupleSerialMarshalledBinding getEntityBinding(DataStore dataStore) {
        return new TupleSerialMarshalledBinding((TupleFormat)dataStore.getKeyFormat(), (SerialFormat)dataStore.getValueFormat());
    }

    private DataBinding getKeyBinding(Class clazz) {
        TupleBinding tupleBinding = TupleBinding.getPrimitiveBinding(clazz, TUPLE_FORMAT);
        if (tupleBinding == null) {
            tupleBinding = new TupleMarshalledBinding(TUPLE_FORMAT, clazz);
        }
        return tupleBinding;
    }
}

