/**
 * <copyright>
 *
 * Copyright (c) 2003-2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: ETypeImpl.java,v 1.10 2005/11/29 15:16:19 emerks Exp $
 */
package org.eclipse.emf.ecore.sdo.impl;


import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.sdo.EProperty;
import org.eclipse.emf.ecore.sdo.EType;
import org.eclipse.emf.ecore.sdo.SDOPackage;
import org.eclipse.emf.ecore.sdo.util.SDOUtil;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.InternalEList;

import commonj.sdo.Property;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>EType</b></em>'.
 * @extends Adapter
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.emf.ecore.sdo.impl.ETypeImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.sdo.impl.ETypeImpl#getURI <em>URI</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.sdo.impl.ETypeImpl#getInstanceClass <em>Instance Class</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.sdo.impl.ETypeImpl#getProperties <em>Properties</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.sdo.impl.ETypeImpl#getEClassifier <em>EClassifier</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ETypeImpl extends EObjectImpl implements EType, Adapter
{
  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private static final long serialVersionUID = 1L;

  /**
   * The default value of the '{@link #getName() <em>Name</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getName()
   * @generated
   * @ordered
   */
  protected static final String NAME_EDEFAULT = null;

  /**
   * The default value of the '{@link #getURI() <em>URI</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getURI()
   * @generated
   * @ordered
   */
  protected static final String URI_EDEFAULT = null;

  /**
   * The default value of the '{@link #getInstanceClass() <em>Instance Class</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getInstanceClass()
   * @generated
   * @ordered
   */
  protected static final Class INSTANCE_CLASS_EDEFAULT = null;

  /**
   * The cached value of the '{@link #getEClassifier() <em>EClassifier</em>}' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getEClassifier()
   * @generated
   * @ordered
   */
  protected EClassifier eClassifier = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected ETypeImpl()
  {
    super();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EClass eStaticClass()
  {
    return SDOPackage.Literals.ETYPE;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public String getName()
  {
    return eClassifier.getName();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public String getURI()
  {
    return eClassifier.getEPackage().getNsURI();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public Class getInstanceClass()
  {
    return eClassifier.getInstanceClass();
  }

  protected EList properties;
  protected EList eAllStructuralFeatures;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public EList getPropertiesGen()
  {
    if (eAllStructuralFeatures == null)
    {
      if (eClassifier instanceof EClass)
      {
        EList eAllStructuralFeatures = ((EClass)eClassifier).getEAllStructuralFeatures();
        properties = adaptProperties(eAllStructuralFeatures);
        this.eAllStructuralFeatures = eAllStructuralFeatures;
      }
      else
      {
        properties = new EcoreEList.UnmodifiableEList.FastCompare(this, SDOPackage.eINSTANCE.getType_Properties(), 0, null);
      }
    }
    else 
    {
      EList eAllStructuralFeatures = ((EClass)eClassifier).getEAllStructuralFeatures();
      if (this.eAllStructuralFeatures != eAllStructuralFeatures)
      {
        properties = adaptProperties(eAllStructuralFeatures);
        this.eAllStructuralFeatures = eAllStructuralFeatures;
      }
    }
    return properties;
  }

  protected EList adaptProperties(List eStructuralFeatures)
  {
    EProperty [] properties = new EProperty [eStructuralFeatures.size()];
    for (int i = 0; i < properties.length; ++i)
    {
      properties[i] = SDOUtil.adaptProperty((EStructuralFeature)eStructuralFeatures.get(i));
    }

    return 
      new EcoreEList.UnmodifiableEList.FastCompare
        (this, SDOPackage.eINSTANCE.getType_Properties(), properties.length, properties);
  }

  public List getProperties()
  {
    return getPropertiesGen();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClassifier getEClassifier()
  {
    return eClassifier;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setEClassifier(EClassifier newEClassifier)
  {
    EClassifier oldEClassifier = eClassifier;
    eClassifier = newEClassifier;
    if (eNotificationRequired())
      eNotify(new ENotificationImpl(this, Notification.SET, SDOPackage.ETYPE__ECLASSIFIER, oldEClassifier, eClassifier));
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public boolean isInstance(Object object)
  {
    return eClassifier.isInstance(object);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public Property getProperty(String propertyName)
  {
    return getEProperty(propertyName);
  }

  protected Map propertyNameToPropertyMap;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public EProperty getEProperty(String propertyName)
  {
    if (propertyNameToPropertyMap == null)
    {
      Map result = new HashMap();
      for (Iterator i = getProperties().iterator(); i.hasNext(); )
      {
        EProperty eProperty = (EProperty)i.next();
        result.put(eProperty.getName(), eProperty);
        String xmlName = ExtendedMetaData.INSTANCE.getName(eProperty.getEStructuralFeature());
        if (!result.containsKey(xmlName))
        {
          result.put(xmlName, eProperty);
        }
      }
      propertyNameToPropertyMap = result;
    }

    return (EProperty)propertyNameToPropertyMap.get(propertyName);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
  {
    switch (featureID)
    {
      case SDOPackage.ETYPE__PROPERTIES:
        return ((InternalEList)getProperties()).basicRemove(otherEnd, msgs);
    }
    return super.eInverseRemove(otherEnd, featureID, msgs);
  }

  public boolean isAdapterForType(Object type)
  {
    return type == EType.class;
  }

  public void notifyChanged(Notification msg)
  {
  }

  public Notifier getTarget()
  {
    return getEClassifier();
  }

  public void setTarget(Notifier newTarget)
  {
    setEClassifier((EClassifier)newTarget);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Object eGet(int featureID, boolean resolve, boolean coreType)
  {
    switch (featureID)
    {
      case SDOPackage.ETYPE__NAME:
        return getName();
      case SDOPackage.ETYPE__URI:
        return getURI();
      case SDOPackage.ETYPE__INSTANCE_CLASS:
        return getInstanceClass();
      case SDOPackage.ETYPE__PROPERTIES:
        return getProperties();
      case SDOPackage.ETYPE__ECLASSIFIER:
        return getEClassifier();
    }
    return super.eGet(featureID, resolve, coreType);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void eSet(int featureID, Object newValue)
  {
    switch (featureID)
    {
      case SDOPackage.ETYPE__ECLASSIFIER:
        setEClassifier((EClassifier)newValue);
        return;
    }
    super.eSet(featureID, newValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void eUnset(int featureID)
  {
    switch (featureID)
    {
      case SDOPackage.ETYPE__ECLASSIFIER:
        setEClassifier((EClassifier)null);
        return;
    }
    super.eUnset(featureID);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public boolean eIsSet(int featureID)
  {
    switch (featureID)
    {
      case SDOPackage.ETYPE__NAME:
        return NAME_EDEFAULT == null ? getName() != null : !NAME_EDEFAULT.equals(getName());
      case SDOPackage.ETYPE__URI:
        return URI_EDEFAULT == null ? getURI() != null : !URI_EDEFAULT.equals(getURI());
      case SDOPackage.ETYPE__INSTANCE_CLASS:
        return INSTANCE_CLASS_EDEFAULT == null ? getInstanceClass() != null : !INSTANCE_CLASS_EDEFAULT.equals(getInstanceClass());
      case SDOPackage.ETYPE__PROPERTIES:
        return !getProperties().isEmpty();
      case SDOPackage.ETYPE__ECLASSIFIER:
        return eClassifier != null;
    }
    return super.eIsSet(featureID);
  }

} //ETypeImpl
