/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.ui.ProjectBlock;

public class ProjectAndFileBlock
extends ProjectBlock {
    private Text fMainText;
    private Button fileButton;

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite comp = (Composite)this.getControl();
        this.createVerticalSpacer(comp, 1);
        this.createScriptFileEditor(comp);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        config.setAttribute("ATTR_STARTUP_FILE", "");
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        String mainTypeName = "";
        try {
            mainTypeName = config.getAttribute("ATTR_STARTUP_FILE", "");
        }
        catch (CoreException ce) {
            PerlDebugPlugin.log(ce);
        }
        this.fMainText.setText(mainTypeName);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        super.performApply(config);
        config.setAttribute("ATTR_STARTUP_FILE", this.fMainText.getText());
    }

    public String getName() {
        return "project and file";
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        boolean valid = super.isValid(config);
        if (!valid) {
            return false;
        }
        String name = this.fMainText.getText().trim();
        if (name.length() == 0) {
            this.setErrorMessage("Startup File is not specified");
            return false;
        }
        String[] files = this.getPerlFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].equals(name)) {
                return true;
            }
            ++i;
        }
        this.setErrorMessage("File does not exist or match to the project");
        return false;
    }

    private void createScriptFileEditor(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText("File to e&xecute:");
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.fMainText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.fMainText.setLayoutData((Object)gd);
        this.fMainText.setFont(font);
        this.fMainText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ProjectAndFileBlock.this.updateLaunchConfigurationDialog();
            }
        });
        this.fileButton = this.createPushButton((Composite)group, "&Search...", null);
        this.fileButton.addSelectionListener((SelectionListener)new ButtonListener());
    }

    private String[] getPerlFiles() {
        String projectName = this.getSelectedProject();
        if (projectName == null || projectName.length() == 0) {
            return new String[0];
        }
        IWorkspaceRoot workspaceRoot = PerlDebugPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject(projectName);
        PerlProjectVisitor visitor = new PerlProjectVisitor();
        try {
            project.accept((IResourceVisitor)visitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return visitor.getList();
    }

    protected void newProjectSelected() {
        super.newProjectSelected();
        this.fMainText.setText("");
    }

    private static class PerlProjectVisitor
    implements IResourceVisitor {
        private static final String PERL_EDITOR_ID = "org.epic.perleditor.editors.PerlEditor";
        private static final String EMB_PERL_FILE_EXTENSION = "epl";
        private List fileList = new ArrayList();

        PerlProjectVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            IEditorDescriptor defaultEditorDescriptor = PerlDebugPlugin.getDefault().getWorkbench().getEditorRegistry().getDefaultEditor(resource.getFullPath().toString());
            if (defaultEditorDescriptor == null) {
                return true;
            }
            if (defaultEditorDescriptor.getId().equals(PERL_EDITOR_ID) && !resource.getFileExtension().equals(EMB_PERL_FILE_EXTENSION)) {
                this.fileList.add(resource.getFullPath().removeFirstSegments(1).toString());
            }
            return true;
        }

        public String[] getList() {
            return this.fileList.toArray(new String[this.fileList.size()]);
        }
    }

    private class ButtonListener
    extends SelectionAdapter {
        ButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object[] files = ProjectAndFileBlock.this.getPerlFiles();
            FileLabelProvider labelProvider = new FileLabelProvider();
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(ProjectAndFileBlock.this.getShell(), (ILabelProvider)labelProvider);
            dialog.setTitle("File Selection");
            dialog.setMessage("Matching files:");
            dialog.setElements(files);
            String perlFile = ProjectAndFileBlock.this.fMainText.getText();
            if (perlFile != null) {
                dialog.setInitialSelections(new Object[]{perlFile});
            }
            if (dialog.open() == 0) {
                ProjectAndFileBlock.this.fMainText.setText((String)dialog.getFirstResult());
            }
        }
    }

    private static class FileLabelProvider
    extends LabelProvider {
        FileLabelProvider() {
        }

        public Image getImage(Object element) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)PerlDebugPlugin.getDefault().toString(), (String)"icons/epic.gif").createImage();
        }
    }
}

