/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import org.eclipse.draw2d.ArrowButton;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ButtonBorder;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ScrollBarLayout;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class PaletteScrollBar
extends ScrollBar {
    private static final ButtonBorder BORDER = new ButtonBorder(new ButtonBorder.ButtonScheme(new Color[]{ColorConstants.buttonLightest}, new Color[]{ColorConstants.buttonDarker}, new Color[]{ColorConstants.buttonDarker}, new Color[]{ColorConstants.buttonDarker}));
    private static final Border CONTRAST = new CompoundBorder((Border)new MarginBorder(1, 0, 0, 0){

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            if (!((Clickable)figure).getModel().isMouseOver()) {
                return;
            }
            Rectangle r = 1.getPaintRectangle((IFigure)figure, (Insets)insets);
            graphics.setForegroundColor(ColorConstants.button);
            graphics.drawLine(r.x, r.y, r.right(), r.y);
        }
    }, (Border)BORDER);
    public static final int BUTTON_HEIGHT = 12;
    private static final int SCROLL_TIME = 200;
    private static final Image TRANSPARENCY;
    protected Label downLabel;
    protected Label upLabel;

    static {
        Display display = Display.getCurrent();
        PaletteData pData = new PaletteData(255, 65280, 0xFF0000);
        RGB rgb = ColorConstants.button.getRGB();
        int fillColor = pData.getPixel(rgb);
        ImageData iData = new ImageData(1, 1, 24, pData);
        iData.setPixel(0, 0, fillColor);
        iData.setAlpha(0, 0, 200);
        TRANSPARENCY = new Image((Device)display, iData);
    }

    public boolean containsPoint(int x, int y) {
        return this.findDescendantAtExcluding(x, y, Figure.IdentitySearch.INSTANCE) != null;
    }

    protected Clickable createDefaultDownButton() {
        return this.createTransparentArrowButton();
    }

    protected Clickable createDefaultUpButton() {
        return this.createTransparentArrowButton();
    }

    private ArrowButton createTransparentArrowButton() {
        ArrowButton button = new ArrowButton(){

            protected void paintFigure(Graphics g) {
                if (!this.getModel().isMouseOver()) {
                    g.drawImage(TRANSPARENCY, new Rectangle(0, 0, 1, 1), this.getBounds());
                } else {
                    super.paintFigure(g);
                }
            }
        };
        button.setRolloverEnabled(true);
        button.setBorder((Border)BORDER);
        return button;
    }

    public IFigure findFigureAt(int x, int y, TreeSearch search) {
        IFigure result = super.findFigureAt(x, y, search);
        if (result != this) {
            return result;
        }
        return null;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return new Dimension(wHint, hHint);
    }

    protected void initialize() {
        super.initialize();
        this.setLayoutManager((LayoutManager)new ScrollBarLayout(this.transposer){

            protected Rectangle layoutButtons(ScrollBar scrollBar) {
                Rectangle bounds = this.transposer.t(scrollBar.getClientArea());
                Dimension buttonSize = new Dimension(bounds.width, 12);
                PaletteScrollBar.this.getButtonUp().setBounds(this.transposer.t(new Rectangle(bounds.getTopLeft(), buttonSize)));
                Rectangle r = new Rectangle(bounds.x, bounds.bottom() - buttonSize.height, buttonSize.width, buttonSize.height);
                PaletteScrollBar.this.getButtonDown().setBounds(this.transposer.t(r));
                if (scrollBar.getBackgroundColor() == ColorConstants.listBackground && PaletteScrollBar.this.getButtonDown().getBorder() != CONTRAST) {
                    PaletteScrollBar.this.getButtonDown().setBorder(CONTRAST);
                }
                Rectangle trackBounds = bounds.getCropped(new Insets(buttonSize.height, 0, buttonSize.height, 0));
                RangeModel model = scrollBar.getRangeModel();
                PaletteScrollBar.this.getButtonUp().setVisible(model.getValue() != model.getMinimum());
                PaletteScrollBar.this.getButtonDown().setVisible(model.getValue() != model.getMaximum() - model.getExtent());
                return trackBounds;
            }
        });
        this.setPageUp(null);
        this.setPageDown(null);
        this.setThumb(null);
        this.setOpaque(false);
    }

    protected void stepDown() {
        this.timedStep(false);
    }

    protected void stepUp() {
        this.timedStep(true);
    }

    protected void timedStep(boolean up) {
        int increment = Math.max(this.getExtent() * 1 / 2, this.getStepIncrement());
        int value = this.getValue();
        long startTime = System.currentTimeMillis();
        long elapsedTime = System.currentTimeMillis() - startTime;
        while (elapsedTime < 200L) {
            int step = (int)((long)increment * elapsedTime / 200L);
            step = up ? value - step : value + step;
            this.setValue(step);
            this.getUpdateManager().performUpdate();
            elapsedTime = System.currentTimeMillis() - startTime;
        }
    }

    protected void updateDownLabel() {
        this.getButtonDown().setVisible(this.getValue() < this.getMaximum() - this.getExtent());
    }

    protected void updateUpLabel() {
        this.getButtonUp().setVisible(this.getValue() > this.getMinimum());
    }
}

