/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.console;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;

public class ConsolePreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private ColorFieldEditor commandColorEditor;
    private ColorFieldEditor messageColorEditor;
    private ColorFieldEditor errorColorEditor;
    private BooleanFieldEditor showOnMessage;
    private BooleanFieldEditor showOnError;
    private BooleanFieldEditor restrictOutput;
    private IntegerFieldEditor highWaterMark;

    public ConsolePreferencesPage() {
        super(1);
        this.setPreferenceStore(SVNUIPlugin.getPlugin().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        IPreferenceStore store = this.getPreferenceStore();
        this.restrictOutput = new BooleanFieldEditor("pref_console_limit_output", Policy.bind("ConsolePreferencePage.limitOutput"), composite);
        this.addField((FieldEditor)this.restrictOutput);
        this.highWaterMark = new IntegerFieldEditor("pref_console_high_water_mark", Policy.bind("ConsolePreferencePage.highWaterMark"), composite);
        this.highWaterMark.setValidRange(1000, 0x7FFFFFFE);
        this.addField((FieldEditor)this.highWaterMark);
        this.highWaterMark.setEnabled(store.getBoolean("pref_console_limit_output"), composite);
        this.showOnMessage = new BooleanFieldEditor("pref_console_show_on_message", Policy.bind("ConsolePreferencePage.showOnMessage"), composite);
        this.addField((FieldEditor)this.showOnMessage);
        this.showOnError = new BooleanFieldEditor("pref_console_show_on_error", Policy.bind("ConsolePreferencePage.showOnError"), composite);
        this.addField((FieldEditor)this.showOnError);
        this.createLabel(composite, Policy.bind("ConsolePreferencePage.consoleColorSettings"));
        this.commandColorEditor = this.createColorFieldEditor("pref_console_command_color", Policy.bind("ConsolePreferencePage.commandColor"), composite);
        this.addField((FieldEditor)this.commandColorEditor);
        this.messageColorEditor = this.createColorFieldEditor("pref_console_message_color", Policy.bind("ConsolePreferencePage.messageColor"), composite);
        this.addField((FieldEditor)this.messageColorEditor);
        this.errorColorEditor = this.createColorFieldEditor("pref_console_error_color", Policy.bind("ConsolePreferencePage.errorColor"), composite);
        this.addField((FieldEditor)this.errorColorEditor);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.tigris.subversion.subclipse.ui.console_preference_page_context");
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        this.highWaterMark.setEnabled(this.restrictOutput.getBooleanValue(), this.getFieldEditorParent());
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private ColorFieldEditor createColorFieldEditor(String preferenceName, String label, Composite parent) {
        ColorFieldEditor editor = new ColorFieldEditor(preferenceName, label, parent);
        editor.setPage((DialogPage)this);
        editor.setPreferenceStore(this.getPreferenceStore());
        return editor;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        SVNUIPlugin.getPlugin().savePluginPreferences();
        return super.performOk();
    }
}

